/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import kiraririria.arichatclassic.CommonProxy;
import kiraririria.arichatclassic.common.Emotion;
import kiraririria.arichatclassic.engine.GenerationSettings;
import kiraririria.arichatclassic.engine.InstructSettings;
import kiraririria.arichatclassic.engine.SummarySettings;
import kiraririria.arichatclassic.engine.api.IModel;
import kiraririria.arichatclassic.engine.api.KoboldAI;
import kiraririria.arichatclassic.engine.api.OpenRouterModel;
import kiraririria.arichatclassic.engine.auth.OpenRouterAuth;
import kiraririria.arichatclassic.engine.prompt.Sysprompt;
import kiraririria.arichatclassic.utils.config.ArichatButtons;
import kiraririria.arichatclassic.utils.config.AuthButtons;
import kiraririria.arichatclassic.utils.config.CardsButtons;
import kiraririria.arichatclassic.utils.config.ValueInstruct;
import kiraririria.arichatclassic.utils.config.ValueModel;
import kiraririria.arichatclassic.utils.config.ValueProfile;
import kiraririria.arichatclassic.utils.config.ValueSummary;
import mchorse.mappet.client.gui.GuiInteractionScreen;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.ConfigBuilder;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.config.values.ValueBoolean;
import mchorse.mclib.config.values.ValueInt;
import mchorse.mclib.config.values.ValueString;
import mchorse.mclib.events.RegisterConfigEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="arichatclassic", name="ArichatClassic", version="0.1.2", updateJSON="https://raw.githubusercontent.com/kiraririria/arichat/main/version.json", dependencies="required-after:mappet@[0.9,);", acceptedMinecraftVersions="[1.12.2]")
public class ArichatClassic {
    public static final String MODID = "arichatclassic";
    public static final String NAME = "ArichatClassic";
    public static final String VERSION = "0.1.2";
    @SidedProxy(clientSide="kiraririria.arichatclassic.ClientProxy", serverSide="kiraririria.arichatclassic.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    @Mod.Instance(value="arichatclassic")
    public static ArichatClassic instance;
    public static boolean connected;
    public static String model;
    public static GenerationSettings settings;
    public static InstructSettings instructSettings;
    public static SummarySettings summarySettings;
    public static List<Sysprompt> syspromptList;
    public static ValueBoolean cardsOnlyCreative;
    public static ValueBoolean enableChatEditing;
    public static ValueBoolean usePerson;
    public static ValueBoolean streamResponse;
    public static ValueBoolean useReasoning;
    public static ValueProfile profileSettings;
    public static ValueInt highlightColor;
    public static ValueBoolean asteriskItalic;
    public static ValueInt parenthesisColor;
    public static ValueBoolean parenthesisMod;
    public static ValueInt asteriskMod;
    public static ValueInt summaryMessageCount;
    public static ValueInt mainAPIMod;
    public static ValueString koboldUrl;
    public static ValueString openrouterUrl;
    public static ValueString openrouterKey;
    public static ValueModel openrouterModel;
    public static ValueInstruct valueInstruct;
    public static ValueSummary valueSummary;
    public static ValueBoolean hideMacros;
    public static List<Emotion> lastemo;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        McLib.EVENT_BUS.register((Object)this);
        logger = event.getModLog();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        ArichatClassic.getMainConnection().checkConnectionAsync(aBoolean -> {});
    }

    public static void log(String message) {
        System.out.println("\u001b[35mARICHAT CLASSIC: " + message + "\u001b[0m");
    }

    public static void errorlog(String message) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("[ARICHAT CLASSIC: " + message + "]"), true);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString("[ARICHAT CLASSIC: " + message + "]"));
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiInteractionScreen) {
                GuiInteractionScreen dialogue = (GuiInteractionScreen)screen;
                dialogue.AIInProgress = false;
                dialogue.enableRegenAnswer();
            }
        });
    }

    @SubscribeEvent
    public void onConfigRegister(RegisterConfigEvent event) {
        ConfigBuilder builder = event.createBuilder(MODID);
        builder.category("general").register(new ArichatButtons("buttons").clientSide());
        cardsOnlyCreative = builder.getBoolean("cards_only_creative", true);
        enableChatEditing = builder.getBoolean("enable_chat_editing", true);
        usePerson = builder.getBoolean("use_person", false);
        streamResponse = builder.getBoolean("stream_response", true);
        useReasoning = builder.getBoolean("use_reasoning", true);
        ConfigBuilder designConf = builder.category("design");
        asteriskMod = designConf.getInt("asterisk_mod", 1).modes(new IKey[]{IKey.lang((String)"arichatclassic.config.asterisk_mod.disable"), IKey.lang((String)"arichatclassic.config.asterisk_mod.hide"), IKey.lang((String)"arichatclassic.config.asterisk_mod.visible")});
        highlightColor = designConf.getInt("highlight_color", 35071).color();
        parenthesisColor = designConf.getInt("parenthesis_color", 35071).color();
        asteriskItalic = designConf.getBoolean("asterisk_italic", true);
        parenthesisMod = designConf.getBoolean("parenthesis_mod", false);
        ConfigBuilder summaryConf = builder.category("summary");
        summaryMessageCount = summaryConf.getInt("summary_message_count", 20);
        valueSummary = new ValueSummary("summaryfile");
        summaryConf.register((Value)valueSummary);
        builder.category("cards").register(new CardsButtons("cards").clientSide());
        ConfigBuilder presetsConf = builder.category("presets");
        profileSettings = new ValueProfile("presets");
        presetsConf.register((Value)profileSettings);
        valueInstruct = new ValueInstruct("instruct");
        presetsConf.register((Value)valueInstruct);
        ConfigBuilder modelConf = builder.category("model");
        mainAPIMod = modelConf.getInt("api_mod", 1).modes(new IKey[]{IKey.lang((String)"arichatclassic.config.api_mod.kobold"), IKey.lang((String)"arichatclassic.config.api_mod.openrouter")});
        koboldUrl = modelConf.getString("kobold_url", "http://localhost:5001");
        openrouterUrl = modelConf.getString("openrouter_url", "https://openrouter.ai");
        openrouterKey = modelConf.getString("open_key", "");
        openrouterModel = new ValueModel("openrouter_model");
        modelConf.register((Value)openrouterModel);
        modelConf.register(new AuthButtons("auth").clientSide());
        ConfigBuilder otherConf = builder.category("other");
        hideMacros = otherConf.getBoolean("hide_macros", true);
        builder.getCategory().markClientSide();
    }

    public static IModel getMainConnection() {
        if ((Integer)mainAPIMod.get() == 0) {
            return new KoboldAI();
        }
        return new OpenRouterModel();
    }

    public static void authorizeWithOpenRouter() {
        new Thread(() -> {
            try {
                OpenRouterAuth.main(new String[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                Platform.runLater(() -> ArichatClassic.log("Error of authorizeWithOpenRouter: " + e.getMessage()));
            }
        }).start();
    }

    static {
        connected = false;
        model = "";
        settings = new GenerationSettings();
        instructSettings = new InstructSettings();
        summarySettings = new SummarySettings();
        syspromptList = new ArrayList<Sysprompt>();
        lastemo = Collections.emptyList();
    }
}

