/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.imageio.ImageIO;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.CommonProxy;
import kiraririria.arichatclassic.client.ArichatClassicPack;
import kiraririria.arichatclassic.client.ArichatClassicTree;
import kiraririria.arichatclassic.client.KeyboardHandler;
import kiraririria.arichatclassic.client.api.CardList;
import kiraririria.arichatclassic.client.api.CardSection;
import kiraririria.arichatclassic.engine.CharacterCard;
import kiraririria.arichatclassic.engine.GenerationSettings;
import kiraririria.arichatclassic.engine.InstructSettings;
import kiraririria.arichatclassic.engine.PngMetadataHandler;
import kiraririria.arichatclassic.engine.SummarySettings;
import kiraririria.arichatclassic.engine.prompt.Sysprompt;
import kiraririria.arichatclassic.utils.ImageUtil;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.files.FileTree;
import mchorse.mclib.utils.files.GlobalTree;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    public static File cardsFolder;
    public static File presetsFolder;
    public static File instructFolder;
    public static File syspromptFolder;
    public static File summaryFolder;
    public static ArichatClassicPack pack;
    public static ArichatClassicTree tree;
    public static final CardList cardList;
    public static boolean haveAIInDialog;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new KeyboardHandler());
        cardsFolder = new File(configFile, "cards");
        cardsFolder.mkdirs();
        presetsFolder = new File(configFile, "presets");
        presetsFolder.mkdirs();
        syspromptFolder = new File(configFile, "sysprompt");
        syspromptFolder.mkdirs();
        instructFolder = new File(configFile, "instructs");
        instructFolder.mkdirs();
        summaryFolder = new File(configFile, " sumprompt");
        summaryFolder.mkdirs();
        pack = new ArichatClassicPack(cardsFolder);
        ReflectionUtils.registerResourcePack((IResourcePack)pack);
        tree = new ArichatClassicTree(cardsFolder);
        GlobalTree.TREE.register((FileTree)tree);
        ClientProxy.importAllResourcesIfFolderEmpty(cardsFolder, "cards");
        ClientProxy.importAllResourcesIfFolderEmpty(presetsFolder, "presets");
        ClientProxy.importAllResourcesIfFolderEmpty(instructFolder, "instructs");
        ClientProxy.importAllResourcesIfFolderEmpty(syspromptFolder, "sysprompt");
        ClientProxy.importAllResourcesIfFolderEmpty(summaryFolder, "sumprompt");
        this.convertCards();
        cardList.rebuildCache();
    }

    private static void importAllResourcesIfFolderEmpty(File targetFolder, String resourceFolderPath) {
        if (targetFolder.exists() && targetFolder.isDirectory()) {
            File[] files = targetFolder.listFiles();
            if (files != null && files.length > 0) {
                return;
            }
        } else {
            targetFolder.mkdirs();
        }
        List<String> resourceFiles = ClientProxy.getResourceFiles(resourceFolderPath);
        if (resourceFiles.isEmpty()) {
            String defaultFileName = ClientProxy.getDefaultFileName(resourceFolderPath);
            if (defaultFileName != null) {
                ClientProxy.importSingleResource(targetFolder, resourceFolderPath + "/" + defaultFileName, defaultFileName);
            }
        } else {
            for (String fileName : resourceFiles) {
                String fullResourcePath = resourceFolderPath + "/" + fileName;
                ClientProxy.importSingleResource(targetFolder, fullResourcePath, fileName);
            }
        }
    }

    private static List<String> getResourceFiles(String resourceFolderPath) {
        ArrayList<String> filenames = new ArrayList<String>();
        String basePath = "assets/arichatclassic/" + resourceFolderPath + "/";
        try {
            Enumeration<URL> urls = ClientProxy.class.getClassLoader().getResources(basePath);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().equals("file")) {
                    try {
                        File[] files;
                        String path = URLDecoder.decode(url.getPath(), "UTF-8");
                        File directory = new File(path);
                        if (!directory.exists() || !directory.isDirectory() || (files = directory.listFiles()) == null) continue;
                        for (File file : files) {
                            if (!file.isFile()) continue;
                            filenames.add(file.getName());
                        }
                        continue;
                    }
                    catch (Exception e) {
                        ArichatClassic.log("Failed to read resources from file system: " + e.getMessage());
                        continue;
                    }
                }
                if (!url.getProtocol().equals("jar")) continue;
                String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
                try {
                    JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String fileName;
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (!name.startsWith(basePath) || entry.isDirectory() || (fileName = name.substring(basePath.length())).contains("/")) continue;
                        filenames.add(fileName);
                    }
                    jar.close();
                }
                catch (Exception e) {
                    ArichatClassic.log("Failed to read resources from JAR: " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            ArichatClassic.log("Failed to get resources for " + resourceFolderPath + ": " + e.getMessage());
        }
        return new ArrayList<String>(new HashSet(filenames));
    }

    private static void importSingleResource(File targetFolder, String resourcePath, String fileName) {
        File targetFile = new File(targetFolder, fileName);
        if (!targetFile.exists()) {
            try (InputStream in = ClientProxy.getResourceStream(resourcePath);){
                Files.copy(in, targetFile.toPath(), new CopyOption[0]);
                ArichatClassic.log("Imported resource: " + resourcePath);
            }
            catch (IOException | NullPointerException e) {
                ArichatClassic.log("Failed to import resource: " + e.getMessage());
            }
        }
    }

    private static String getDefaultFileName(String folderName) {
        switch (folderName) {
            case "cards": {
                return "mchorse.png";
            }
            case "presets": {
                return "default.json";
            }
            case "instructs": {
                return "default.json";
            }
            case "sysprompt": {
                return "roleplay.json";
            }
        }
        return null;
    }

    private static InputStream getResourceStream(String resourcePath) throws IOException {
        ResourceLocation resLoc = RLUtils.create((String)"arichatclassic", (String)resourcePath);
        IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resLoc);
        return resource.func_110527_b();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    public static void loadSettings() {
        ArichatClassic.settings = GenerationSettings.loadFromFile(new File(presetsFolder, ArichatClassic.profileSettings.getFile()));
        ArichatClassic.instructSettings = InstructSettings.loadFromFile(new File(instructFolder, ArichatClassic.valueInstruct.getFile()));
        ArichatClassic.summarySettings = SummarySettings.loadFromFile(new File(summaryFolder, ArichatClassic.valueSummary.getFile()));
    }

    public static void loadCards() {
        cardList.clear();
        CardSection cardSection = new CardSection("cards");
        cardSection.setParentList(cardList);
        cardList.register(cardSection);
        cardList.rebuildCache();
    }

    public static void loadPrompts() {
        ArichatClassic.syspromptList.clear();
        for (File file : Sysprompt.sysprompts()) {
            Sysprompt prompt = Sysprompt.load(file);
            if (prompt == null) continue;
            ArichatClassic.syspromptList.add(prompt);
        }
        ClientProxy.ensureRoleplayFirst();
    }

    private static void ensureRoleplayFirst() {
        Sysprompt roleplayPrompt = null;
        int roleplayIndex = -1;
        for (int i = 0; i < ArichatClassic.syspromptList.size(); ++i) {
            Sysprompt prompt = ArichatClassic.syspromptList.get(i);
            if (!"roleplay".equals(prompt.name)) continue;
            roleplayPrompt = prompt;
            roleplayIndex = i;
            break;
        }
        if (roleplayPrompt != null && roleplayIndex > 0) {
            ArichatClassic.syspromptList.remove(roleplayIndex);
            ArichatClassic.syspromptList.add(0, roleplayPrompt);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ClientProxy.loadCards();
        ClientProxy.loadSettings();
        ClientProxy.loadPrompts();
    }

    private void convertCards() {
        try {
            File[] files = cardsFolder.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (!file.getName().toLowerCase().endsWith(".json")) continue;
                try {
                    String jsonContent = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                    CharacterCard card = CharacterCard.empty();
                    card.fromJson(jsonContent);
                    String baseName = file.getName().replace(".json", "");
                    File pngFile = new File(cardsFolder, baseName + ".png");
                    InputStream pngInputStream = pngFile.exists() ? Files.newInputStream(pngFile.toPath(), new OpenOption[0]) : this.createStubImage(card);
                    byte[] newImage = PngMetadataHandler.writePngMetadata(pngInputStream, card.toJson());
                    try (FileOutputStream fos = new FileOutputStream(pngFile);){
                        fos.write(newImage);
                        fos.flush();
                    }
                    if (pngInputStream instanceof FileInputStream) {
                        pngInputStream.close();
                    }
                    if (file.delete()) {
                        ArichatClassic.log("Converted and deleted JSON card: " + file.getName());
                    } else {
                        ArichatClassic.log("Failed to delete JSON file: " + file.getName());
                    }
                    ImageUtil.handleImage(baseName + ".png");
                }
                catch (Exception e) {
                    ArichatClassic.log("Failed to convert card " + file.getName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            ArichatClassic.log("Error during card conversion: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private InputStream createStubImage(CharacterCard card) throws IOException {
        int width = 800;
        int height = 1200;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        Font titleFont = new Font("Arial", 1, 72);
        Font nameFont = new Font("Arial", 1, 64);
        Font infoFont = new Font("Arial", 0, 48);
        int totalTextHeight = 0;
        int lineSpacing = 60;
        totalTextHeight += 72 + lineSpacing;
        if (!card.name.isEmpty()) {
            totalTextHeight += 64 + lineSpacing;
        }
        if (!card.creator.isEmpty()) {
            totalTextHeight += 48 + lineSpacing;
        }
        if (!card.characterVersion.isEmpty()) {
            totalTextHeight += 48 + lineSpacing;
        }
        int y = (height - totalTextHeight) / 2 + 200;
        g.setFont(titleFont);
        String title = "CHARACTER";
        int titleWidth = g.getFontMetrics().stringWidth(title);
        g.drawString(title, (width - titleWidth) / 2, y);
        y += 72 + lineSpacing;
        if (!card.name.isEmpty()) {
            g.setFont(nameFont);
            String name = card.name;
            if (name.length() > 15) {
                String firstPart = name.substring(0, 15);
                String secondPart = name.substring(15);
                int nameWidth = g.getFontMetrics().stringWidth(firstPart);
                g.drawString(firstPart, (width - nameWidth) / 2, y);
                secondPart = secondPart.length() > 15 ? secondPart.substring(0, 15) + "..." : secondPart;
                nameWidth = g.getFontMetrics().stringWidth(secondPart);
                g.drawString(secondPart, (width - nameWidth) / 2, y += 64);
                y += lineSpacing;
            } else {
                int nameWidth = g.getFontMetrics().stringWidth(name);
                g.drawString(name, (width - nameWidth) / 2, y);
                y += 64 + lineSpacing;
            }
        }
        if (!card.creator.isEmpty()) {
            g.setFont(infoFont);
            String creator = card.creator;
            if (creator.length() > 20) {
                creator = creator.substring(0, 17) + "...";
            }
            int creatorWidth = g.getFontMetrics().stringWidth(creator);
            g.drawString(creator, (width - creatorWidth) / 2, y);
            y += 48 + lineSpacing;
        }
        if (!card.characterVersion.isEmpty()) {
            g.setFont(infoFont);
            String version = card.characterVersion;
            int versionWidth = g.getFontMetrics().stringWidth(version);
            g.drawString(version, (width - versionWidth) / 2, y);
            y += 48 + lineSpacing;
        }
        g.setColor(Color.BLACK);
        g.setStroke(new BasicStroke(10.0f));
        g.drawRect(20, 20, width - 40, height - 40);
        g.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    static {
        cardList = new CardList();
        haveAIInDialog = false;
    }
}

