/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.api;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.api.GenerationHandler;
import kiraririria.arichatclassic.engine.api.IModel;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.EmoMacroPostProcessor;
import kiraririria.arichatclassic.engine.prompt.JsMacroPostProcessor;
import net.minecraft.entity.player.EntityPlayer;

public class ArichatClassicAPI {
    private static final Map<UUID, GenerationResult> activeResults = new ConcurrentHashMap<UUID, GenerationResult>();

    public static UUID startTextGeneration(String prompt, Conversation conversation, EntityPlayer player) {
        UUID id = UUID.randomUUID();
        GenerationResult result = new GenerationResult(id, prompt);
        activeResults.put(id, result);
        Consumer<String> onUpdate = chunk -> {
            GenerationResult res = activeResults.get(id);
            if (res != null) {
                res.appendText((String)chunk);
            }
        };
        Runnable onComplete = () -> {
            GenerationResult res = activeResults.get(id);
            if (res != null) {
                String finalText = res.getGeneratedText();
                if (player != null) {
                    finalText = JsMacroPostProcessor.process(finalText, player);
                    finalText = EmoMacroPostProcessor.process(finalText, player);
                }
                res.generatedText = finalText;
                res.setCompleted(true);
            }
        };
        if (conversation != null) {
            GenerationHandler.runGeneration(id, prompt, conversation, onUpdate, onComplete);
        } else {
            GenerationHandler.runGeneration(id, prompt, onUpdate, onComplete);
        }
        return id;
    }

    public static UUID startExpressionGeneration(String prompt, Conversation conversation, EntityPlayer player) {
        UUID id = UUID.randomUUID();
        GenerationResult result = new GenerationResult(id, prompt);
        activeResults.put(id, result);
        Consumer<String> onUpdate = chunk -> {
            GenerationResult res = activeResults.get(id);
            if (res != null) {
                res.appendText((String)chunk);
            }
        };
        Runnable onComplete = () -> {
            GenerationResult res = activeResults.get(id);
            if (res != null) {
                String finalText = res.getGeneratedText();
                if (player != null) {
                    finalText = JsMacroPostProcessor.process(finalText, player);
                    finalText = EmoMacroPostProcessor.process(finalText, player);
                }
                res.generatedText = finalText;
                res.setCompleted(true);
            }
        };
        GenerationHandler.runExpressionGeneration(id, prompt, conversation, onUpdate, onComplete);
        return id;
    }

    public static UUID startCustomGeneration(JsonObject jsonObject, EntityPlayer player) {
        UUID id = UUID.randomUUID();
        String prompt = jsonObject.has("prompt") ? jsonObject.get("prompt").getAsString() : "";
        GenerationResult result = new GenerationResult(id, prompt);
        activeResults.put(id, result);
        Thread generationThread = new Thread(() -> {
            block4: {
                try {
                    boolean[] wasReasoning = new boolean[]{false};
                    AtomicReference<String> currentText = new AtomicReference<String>("");
                    IModel model = ArichatClassic.getMainConnection();
                    model.generateTextStream(prompt, jsonObject, chunk -> {
                        GenerationResult res = activeResults.get(id);
                        if (res == null) {
                            return;
                        }
                        if (chunk.startsWith("[R]")) {
                            currentText.set("[R]" + (String)currentText.get() + chunk.replace("[R]", ""));
                            res.appendText((String)chunk);
                            currentText.set(((String)currentText.get()).replace("[R]", ""));
                            wasReasoning[0] = true;
                        } else {
                            if (wasReasoning[0]) {
                                currentText.set("");
                                wasReasoning[0] = false;
                            }
                            currentText.set((String)currentText.get() + chunk);
                            res.appendText((String)chunk);
                        }
                    });
                    GenerationResult res = activeResults.get(id);
                    if (res != null) {
                        String finalText = currentText.get();
                        if (player != null) {
                            finalText = JsMacroPostProcessor.process(finalText, player);
                            finalText = EmoMacroPostProcessor.process(finalText, player);
                        }
                        res.generatedText = finalText;
                        res.setCompleted(true);
                    }
                }
                catch (Exception e) {
                    GenerationResult res = activeResults.get(id);
                    if (res == null) break block4;
                    res.setError(e.getMessage());
                    ArichatClassic.errorlog("API Generation Error: " + e.getMessage());
                }
            }
        });
        generationThread.start();
        return id;
    }

    public static GenerationResult getResult(UUID id) {
        return activeResults.get(id);
    }

    public static boolean isGenerationCompleted(UUID id) {
        GenerationResult result = activeResults.get(id);
        return result != null && result.isCompleted();
    }

    public static boolean stopGeneration(UUID id) {
        GenerationHandler.stopGeneration(id);
        GenerationResult result = activeResults.remove(id);
        return result != null;
    }

    public static String getGeneratedText(UUID id) {
        GenerationResult result = activeResults.get(id);
        if (result != null && result.isCompleted() && !result.isError()) {
            return result.getGeneratedText();
        }
        return null;
    }

    public static void cleanupOldResults(long removeIfOlderThanMillis) {
    }

    public static void removeResult(UUID id) {
        activeResults.remove(id);
    }

    public static int getActiveGenerationsCount() {
        return activeResults.size();
    }

    public static String generateTextSync(String prompt, Conversation conversation, EntityPlayer player, long timeoutMillis) {
        UUID id = ArichatClassicAPI.startTextGeneration(prompt, conversation, player);
        long startTime = System.currentTimeMillis();
        while (!ArichatClassicAPI.isGenerationCompleted(id)) {
            if (System.currentTimeMillis() - startTime > timeoutMillis) {
                ArichatClassicAPI.stopGeneration(id);
                ArichatClassicAPI.removeResult(id);
                return null;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                ArichatClassicAPI.stopGeneration(id);
                ArichatClassicAPI.removeResult(id);
                Thread.currentThread().interrupt();
                return null;
            }
        }
        String result = ArichatClassicAPI.getGeneratedText(id);
        ArichatClassicAPI.removeResult(id);
        return result;
    }

    public static class GenerationResult {
        private final UUID id;
        private final String prompt;
        private String generatedText;
        private boolean isCompleted;
        private boolean isError;
        private String errorMessage;

        public GenerationResult(UUID id, String prompt) {
            this.id = id;
            this.prompt = prompt;
            this.generatedText = "";
            this.isCompleted = false;
            this.isError = false;
            this.errorMessage = null;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public String getGeneratedText() {
            return this.generatedText;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public boolean isError() {
            return this.isError;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void appendText(String text) {
            this.generatedText = this.generatedText + text;
        }

        public void setCompleted(boolean completed) {
            this.isCompleted = completed;
        }

        public void setError(String errorMessage) {
            this.isError = true;
            this.errorMessage = errorMessage;
            this.isCompleted = true;
        }
    }
}

