/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.api.GenerationHandler;
import kiraririria.arichatclassic.common.Emotion;
import kiraririria.arichatclassic.engine.CharacterCard;
import kiraririria.arichatclassic.engine.InstructSettings;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.InstructFormatter;
import kiraririria.arichatclassic.engine.prompt.MacroContext;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;
import kiraririria.arichatclassic.engine.prompt.PromptBuilder;
import kiraririria.arichatclassic.network.Dispatcher;
import kiraririria.arichatclassic.network.client.ClientHandlerUpdateDialogueMorph;
import kiraririria.arichatclassic.network.common.PacketTrigger;
import kiraririria.arichatclassic.network.common.PacketUpdateDialogueMorph;
import kiraririria.arichatclassic.network.common.PacketUpdateDialogueReaction;
import kiraririria.arichatclassic.utils.EmojiUtil;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.dialogues.Dialogue;
import mchorse.mappet.api.dialogues.DialogueFragment;
import mchorse.mappet.api.dialogues.nodes.ArichatActionReactionNode;
import mchorse.mappet.api.dialogues.nodes.ArichatReactionNode;
import mchorse.mappet.api.dialogues.nodes.ICardHandler;
import mchorse.mappet.client.gui.GuiInteractionScreen;
import mchorse.mappet.client.gui.mclib.GuiDialogTextElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DialogueGenerator {
    public static void generateResponse(UUID dialogueId, ArichatReactionNode node, Dialogue dialogue, EntityPlayerMP player, DialogueFragment reaction, Runnable onComplete) {
        CharacterCard card = DialogueGenerator.validateCharacterCard(ClientProxy.cardList.getImageCardByFilename((String)node.card).card);
        Conversation conversation = new Conversation(player.getDisplayNameString(), card, node.sysprompt);
        List<String> history = DialogueGenerator.buildHistory();
        history.add(dialogue.history.get(dialogue.history.size() - 1));
        String prompt = DialogueGenerator.buildFullPrompt(conversation, (EntityPlayer)player, history);
        if (node instanceof ArichatActionReactionNode) {
            ArichatClassic.lastemo = ((ArichatActionReactionNode)node).emotions;
        }
        DialogueGenerator.runDialogueGeneration(dialogueId, prompt, conversation, updatedText -> {
            String processedText;
            PacketUpdateDialogueReaction packet = new PacketUpdateDialogueReaction(dialogueId, "processedText");
            if (updatedText.startsWith("[R]")) {
                updatedText = updatedText.replace("[R]", "");
                packet.reasoning = true;
            }
            packet.reactionText = processedText = DialogueGenerator.processGeneratedText(updatedText);
            reaction.text = processedText;
            Dispatcher.sendTo(packet, player);
        }, () -> {
            GenerationHandler.stopGeneration(dialogueId);
            dialogue.history.add(reaction.text);
            Dispatcher.sendTo(new PacketUpdateDialogueReaction(dialogueId), player);
            onComplete.run();
            if (node instanceof ArichatActionReactionNode) {
                if (!((ArichatActionReactionNode)node).macros) {
                    DialogueGenerator.generateExpression((ArichatActionReactionNode)node, (EntityPlayer)player, reaction, conversation);
                } else {
                    ArichatClassic.lastemo = ((ArichatActionReactionNode)node).emotions;
                }
            }
        });
    }

    public static void generatePromptResponse(UUID dialogueId, String prompt, Dialogue dialogue, EntityPlayerMP player, DialogueFragment reaction, Runnable onComplete) {
        List<String> history = DialogueGenerator.buildHistory();
        if (!dialogue.history.isEmpty()) {
            history.add(dialogue.history.get(dialogue.history.size() - 1));
        }
        CharacterCard emptyCard = CharacterCard.empty();
        emptyCard.name = "Assistant";
        Conversation conversation = new Conversation(player.getDisplayNameString(), emptyCard, null);
        MacroContext context = new MacroContext(conversation, (EntityPlayer)player, history);
        String processedPrompt = MacroProcessor.process(prompt, context);
        DialogueGenerator.runDialogueGeneration(dialogueId, processedPrompt, updatedText -> {
            String processedText;
            reaction.text = processedText = DialogueGenerator.processGeneratedText(updatedText);
            Dispatcher.sendTo(new PacketUpdateDialogueReaction(dialogueId, processedText), player);
        }, () -> {
            GenerationHandler.stopGeneration(dialogueId);
            dialogue.history.add(reaction.text);
            Dispatcher.sendTo(new PacketUpdateDialogueReaction(dialogueId), player);
            onComplete.run();
        });
    }

    private static String format(String text) {
        text = text.replace("<s>", "");
        text = text.trim();
        return text.replaceAll("[^\\p{L}\\p{N}]", "");
    }

    private static void generateExpression(ArichatActionReactionNode node, EntityPlayer player, DialogueFragment reaction, Conversation conversation) {
        String reactionPrompt = PromptBuilder.buildReactionPrompt(node.emotions, conversation, reaction.text, node.complex, node.emotionPrompt);
        UUID dialogueId = UUID.randomUUID();
        DialogueGenerator.runExpressionGeneration(dialogueId, reactionPrompt, conversation, updatedText -> {
            Optional<Emotion> emotion;
            updatedText = updatedText.trim();
            if ((updatedText = DialogueGenerator.format(updatedText)).split(" ").length > 1) {
                updatedText = updatedText.split(" ")[1];
            }
            if ((emotion = Emotion.getEmotionByName(node.emotions, updatedText)).isPresent()) {
                DialogueGenerator.executeExpression(player, emotion.get());
            } else {
                ArichatClassic.log("Error get emotion: " + updatedText);
            }
        }, () -> GenerationHandler.stopGeneration(dialogueId));
    }

    public static void executeExpression(EntityPlayer player, Emotion emotion) {
        if (player instanceof EntityPlayerSP) {
            ClientHandlerUpdateDialogueMorph.setMorph(emotion.morph);
        } else {
            Dispatcher.sendTo(new PacketUpdateDialogueMorph(emotion.morph), (EntityPlayerMP)player);
        }
        if (emotion.trigger != null & !emotion.trigger.isEmpty()) {
            if (player.field_70170_p.field_72995_K) {
                Dispatcher.sendToServer(new PacketTrigger(emotion.trigger.serializeNBT(), player.func_145782_y()));
            } else {
                emotion.trigger.trigger((EntityLivingBase)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void regenerateResponse(UUID uuid, Runnable onComplete) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiInteractionScreen) {
            GuiInteractionScreen gui = (GuiInteractionScreen)screen;
            if (gui.fragment.reaction.ai) {
                String prompt;
                Conversation conversation;
                GenerationHandler.stopGeneration(gui.fragment.reaction.dialogueIDAI);
                gui.fragment.reaction.dialogueIDAI = uuid;
                List<String> history = DialogueGenerator.buildHistory();
                history.remove(history.size() - 1);
                if (gui.fragment.reaction.node != null) {
                    CharacterCard card = DialogueGenerator.validateCharacterCard(ClientProxy.cardList.getImageCardByFilename((String)gui.fragment.reaction.node.getCard()).card);
                    conversation = new Conversation(Minecraft.func_71410_x().field_71439_g.getDisplayNameString(), card, gui.fragment.reaction.node.getSysPrompt());
                    prompt = DialogueGenerator.buildFullPrompt(conversation, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, history);
                } else {
                    CharacterCard card = CharacterCard.empty();
                    card.name = "Assistant";
                    conversation = new Conversation(Minecraft.func_71410_x().field_71439_g.getDisplayNameString(), card, null);
                    MacroContext context = new MacroContext(conversation, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, history);
                    prompt = MacroProcessor.process(gui.fragment.reaction.ltPrompt, context);
                }
                Dialogue dialogue = (Dialogue)Mappet.dialogues.load(gui.fragment.reaction.dialogueID);
                DialogueGenerator.runDialogueGeneration(uuid, prompt, conversation, updatedText -> {
                    String processedText;
                    gui.fragment.reaction.text = processedText = DialogueGenerator.processGeneratedText(updatedText);
                    gui.reactionText.setText(processedText);
                }, () -> {
                    GenerationHandler.stopGeneration(uuid);
                    dialogue.history.add(gui.fragment.reaction.text);
                    gui.replies.setVisible(true);
                    gui.AIInProgress = false;
                    gui.enableRegenAnswer();
                    onComplete.run();
                    ICardHandler node = gui.fragment.reaction.node;
                    if (node instanceof ArichatActionReactionNode && !((ArichatActionReactionNode)node).macros) {
                        DialogueGenerator.generateExpression((ArichatActionReactionNode)node, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, gui.fragment.reaction, conversation);
                    }
                });
            }
        }
    }

    private static void runDialogueGeneration(UUID dialogueId, String prompt, Conversation conversation, Consumer<String> updateCallback, Runnable completionCallback) {
        GenerationHandler.runGeneration(dialogueId, prompt, conversation, updateCallback, completionCallback);
    }

    private static void runDialogueGeneration(UUID dialogueId, String prompt, Consumer<String> updateCallback, Runnable completionCallback) {
        GenerationHandler.runGeneration(dialogueId, prompt, updateCallback, completionCallback);
    }

    private static void runExpressionGeneration(UUID dialogueId, String prompt, Conversation conversation, Consumer<String> updateCallback, Runnable completionCallback) {
        GenerationHandler.runExpressionGeneration(dialogueId, prompt, conversation, updateCallback, completionCallback);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String buildFullPrompt(Conversation conversation, EntityPlayer player, List<String> history) {
        StringBuilder prompt = new StringBuilder(PromptBuilder.buildPrompt(conversation, player));
        prompt.append("\n***\n");
        InstructSettings instruct = ArichatClassic.instructSettings;
        MacroContext context = new MacroContext(conversation, player, history);
        for (int i = 0; i < history.size(); ++i) {
            String formattedText;
            block9: {
                String speaker;
                String reply = history.get(i);
                if (i % 2 == 0) {
                    speaker = conversation.characterCard.name;
                    if (instruct != null && !instruct.output_sequence.isEmpty()) {
                        formattedText = InstructFormatter.formatMessage(speaker, DialogueGenerator.formatCharacterLine(reply), false, false, null, conversation.userName, conversation.characterCard.name, instruct);
                        break block9;
                    } else {
                        formattedText = DialogueGenerator.formatCharacterLine(reply);
                        prompt.append(speaker).append(": ").append(formattedText).append("\n");
                        continue;
                    }
                }
                speaker = conversation.userName;
                if (instruct != null && !instruct.input_sequence.isEmpty()) {
                    formattedText = InstructFormatter.formatMessage(speaker, DialogueGenerator.formatUserLine(reply), true, false, null, conversation.userName, conversation.characterCard.name, instruct);
                } else {
                    formattedText = DialogueGenerator.formatUserLine(reply);
                    prompt.append(speaker).append(": ").append(formattedText).append("\n");
                    continue;
                }
            }
            formattedText = MacroProcessor.process(formattedText, context);
            prompt.append(formattedText);
            if (formattedText.endsWith("\n")) continue;
            prompt.append("\n");
        }
        if (!conversation.characterCard.postHistoryInstructions.isEmpty()) {
            prompt.append("***\n");
            String instructions = conversation.characterCard.postHistoryInstructions;
            instructions = MacroProcessor.process(instructions, context);
            prompt.append(instructions);
            prompt.append("\n");
        }
        if (instruct != null && !instruct.output_sequence.isEmpty()) {
            String prefix = instruct.output_sequence;
            if (instruct.macro) {
                prefix = MacroProcessor.process(prefix, context);
            }
            prompt.append(prefix);
            return prompt.toString();
        }
        prompt.append(conversation.characterCard.name).append(":");
        return prompt.toString();
    }

    static String formatCharacterLine(String text) {
        return text;
    }

    static String formatUserLine(String text) {
        return text.replaceAll(">\\s*", "");
    }

    static String processGeneratedText(String text) {
        text = EmojiUtil.removeEmojisWithSpaceCleanup(text);
        return text;
    }

    public static CharacterCard validateCharacterCard(CharacterCard card) {
        if (card.name.isEmpty()) {
            card.name = "You";
        }
        return card;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> buildHistory() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        List<String> history = new ArrayList<String>();
        if (screen instanceof GuiInteractionScreen) {
            GuiInteractionScreen dialogue = (GuiInteractionScreen)screen;
            ArrayList tempHistory = new ArrayList();
            dialogue.reaction.getChildren().forEach(iGuiElement -> {
                GuiDialogTextElement textElement = (GuiDialogTextElement)((Object)iGuiElement);
                tempHistory.add(textElement.getText());
            });
            int count = (Integer)ArichatClassic.summaryMessageCount.get();
            if (count % 2 == 0) {
                --count;
            }
            if (((Dialogue)Mappet.dialogues.load((String)dialogue.fragment.reaction.dialogueID)).summarise) {
                history = DialogueGenerator.removeFirstNElements(tempHistory, dialogue.summaredCount - 1);
                history = history.subList(Math.max(0, history.size() - count), history.size());
            } else {
                history = tempHistory;
            }
        }
        return history;
    }

    public static <T> List<T> removeFirstNElements(List<T> list, int n) {
        if (list == null || n <= 0) {
            return new ArrayList<T>(list);
        }
        if (n >= list.size()) {
            return new ArrayList();
        }
        return new ArrayList<T>(list.subList(n, list.size()));
    }
}

