/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.api;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.engine.api.IModel;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.EmoMacroPostProcessor;
import kiraririria.arichatclassic.engine.prompt.JsMacroPostProcessor;
import kiraririria.arichatclassic.engine.prompt.OpenRouterRequestBuilder;
import kiraririria.arichatclassic.engine.prompt.RequestBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class GenerationHandler {
    private static final Map<UUID, GenerationTask> activeGenerations = new ConcurrentHashMap<UUID, GenerationTask>();

    public static boolean hasRunningTasks() {
        return !activeGenerations.isEmpty();
    }

    public static void runGeneration(UUID dialogueId, String prompt, Conversation conversation, Consumer<String> onUpdate, Runnable onComplete) {
        GenerationTask task = new GenerationTask(prompt, ArichatClassic.getMainConnection().buildHeaders(prompt, conversation.userName), conversation, onUpdate, onComplete);
        activeGenerations.put(dialogueId, task);
        task.start();
    }

    public static void runGeneration(UUID dialogueId, String prompt, Consumer<String> onUpdate, Runnable onComplete) {
        JsonObject object = (Integer)ArichatClassic.mainAPIMod.get() == 0 ? RequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, (Boolean)ArichatClassic.streamResponse.get()) : OpenRouterRequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, (Boolean)ArichatClassic.streamResponse.get());
        GenerationTask task = new GenerationTask(prompt, object, null, onUpdate, onComplete);
        activeGenerations.put(dialogueId, task);
        task.start();
    }

    public static void runPromptGeneration(UUID dialogueId, String prompt, Consumer<String> onUpdate, Runnable onComplete) {
        JsonObject object = (Integer)ArichatClassic.mainAPIMod.get() == 0 ? RequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, false) : OpenRouterRequestBuilder.buildEBaseRequest(prompt, ArichatClassic.settings, false, ".");
        GenerationTask task = new GenerationTask(prompt, object, null, onUpdate, onComplete);
        activeGenerations.put(dialogueId, task);
        task.start(object, false);
    }

    public static void runExpressionGeneration(UUID dialogueId, String prompt, Conversation conversation, Consumer<String> onUpdate, Runnable onComplete) {
        JsonObject object = (Integer)ArichatClassic.mainAPIMod.get() == 0 ? RequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, conversation.userName, false) : OpenRouterRequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, true, conversation.userName);
        GenerationTask task = new GenerationTask(prompt, object, conversation, onUpdate, onComplete);
        activeGenerations.put(dialogueId, task);
        JsonObject _object = (Integer)ArichatClassic.mainAPIMod.get() == 0 ? RequestBuilder.buildExpressionRequest(prompt, ArichatClassic.settings, conversation.userName) : OpenRouterRequestBuilder.buildExpressionRequest(prompt, ArichatClassic.settings, conversation.userName);
        task.start(_object, (Integer)ArichatClassic.mainAPIMod.get() != 0);
    }

    public static void stopGeneration(UUID dialogueId) {
        GenerationTask task = activeGenerations.remove(dialogueId);
        if (task != null) {
            task.stop();
        }
    }

    public static boolean isGenerating(UUID dialogueId) {
        return activeGenerations.containsKey(dialogueId);
    }

    public static boolean isAvailable() {
        return true;
    }

    private static class GenerationTask {
        private final String prompt;
        private final JsonObject jsonObject;
        private final Conversation conversation;
        private final Consumer<String> onUpdate;
        private final Runnable onComplete;
        private Thread generationThread;
        private final AtomicReference<String> currentText = new AtomicReference<String>("");
        private EntityPlayer player = null;

        public GenerationTask(String prompt, JsonObject jsonObject, Conversation conversation, Consumer<String> onUpdate, Runnable onComplete) {
            this.prompt = prompt;
            this.onUpdate = onUpdate;
            this.onComplete = onComplete;
            this.jsonObject = jsonObject;
            this.conversation = conversation;
            this.player = this.getPlayerFromConversation();
        }

        public void start() {
            this.generationThread = new Thread(() -> {
                IModel model = ArichatClassic.getMainConnection();
                try {
                    boolean[] wasReasoning = new boolean[]{false};
                    model.generateTextStream(this.prompt, this.jsonObject, chunk -> {
                        if (chunk.startsWith("[R]")) {
                            this.currentText.set("[R]" + this.currentText.get() + chunk.replace("[R]", ""));
                            this.onUpdate.accept(this.currentText.get());
                            this.currentText.set(this.currentText.get().replace("[R]", ""));
                            wasReasoning[0] = true;
                        } else {
                            if (wasReasoning[0]) {
                                this.currentText.set("");
                                wasReasoning[0] = false;
                            }
                            this.currentText.set(this.currentText.get() + chunk);
                            this.onUpdate.accept(this.currentText.get());
                        }
                    });
                    String finalText = this.currentText.get();
                    if (this.player != null) {
                        finalText = JsMacroPostProcessor.process(finalText, this.player);
                        finalText = EmoMacroPostProcessor.process(finalText, this.player);
                    }
                    this.currentText.set(finalText);
                    this.onUpdate.accept(finalText);
                    this.onComplete.run();
                }
                catch (IOException e) {
                    ArichatClassic.errorlog(e.getMessage());
                }
            });
            this.generationThread.start();
        }

        public void start(JsonObject jsonObject, boolean stream) {
            this.generationThread = new Thread(() -> {
                IModel model = ArichatClassic.getMainConnection();
                try {
                    model.generateTextStream(jsonObject, chunk -> {
                        this.currentText.set(this.currentText.get() + chunk);
                        this.onUpdate.accept(this.currentText.get());
                    }, stream);
                    String finalText = this.currentText.get();
                    if (this.player != null) {
                        finalText = JsMacroPostProcessor.process(finalText, this.player);
                        finalText = EmoMacroPostProcessor.process(finalText, this.player);
                    }
                    this.currentText.set(finalText);
                    this.onUpdate.accept(finalText);
                    this.onComplete.run();
                }
                catch (IOException e) {
                    ArichatClassic.errorlog(e.getMessage());
                }
            });
            this.generationThread.start();
        }

        private EntityPlayer getPlayerFromConversation() {
            try {
                return Minecraft.func_71410_x().field_71439_g;
            }
            catch (Exception e) {
                return null;
            }
        }

        public void stop() {
            if (this.generationThread != null && this.generationThread.isAlive()) {
                this.generationThread.interrupt();
            }
        }
    }
}

