/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.api;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.api.DialogueGenerator;
import kiraririria.arichatclassic.api.GenerationHandler;
import kiraririria.arichatclassic.engine.CharacterCard;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.MacroContext;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;
import kiraririria.arichatclassic.network.Dispatcher;
import kiraririria.arichatclassic.network.common.PacketSummariseDialogue;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.dialogues.Dialogue;
import mchorse.mappet.api.dialogues.nodes.ICardHandler;
import mchorse.mappet.api.states.States;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.client.gui.GuiInteractionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;

public class SummaryGenerator {
    public static void generateSummary(String id, ICardHandler node, List<String> history, String cur, EntityPlayer player, Runnable onComplete) {
        UUID dialogueId = UUID.randomUUID();
        String npcName = "You";
        CharacterCard card = null;
        if (node != null) {
            card = DialogueGenerator.validateCharacterCard(ClientProxy.cardList.getImageCardByFilename((String)node.getCard()).card);
            npcName = card.name;
        }
        Conversation conversation = null;
        if (card != null) {
            conversation = new Conversation(player.getDisplayNameString(), card, null);
        }
        String prompt = SummaryGenerator.buildSummaryPrompt(player.getDisplayNameString(), npcName, history, cur, conversation);
        StringBuilder summaryBuilder = new StringBuilder();
        SummaryGenerator.runSummaryGeneration(dialogueId, prompt, updatedText -> {
            if (!summaryBuilder.toString().equals(updatedText)) {
                summaryBuilder.append(DialogueGenerator.processGeneratedText(updatedText));
            }
        }, () -> {
            String s = summaryBuilder.toString();
            Dispatcher.sendToServer(new PacketSummariseDialogue(id, s));
            GuiInteractionScreen.setLocalSummary(s);
            GenerationHandler.stopGeneration(dialogueId);
            onComplete.run();
        });
    }

    private static void runSummaryGeneration(UUID dialogueId, String prompt, Consumer<String> updateCallback, Runnable completionCallback) {
        GenerationHandler.runPromptGeneration(dialogueId, prompt, updateCallback, completionCallback);
    }

    private static String buildSummaryPrompt(String playerName, String charName, List<String> history, String cur, Conversation conversation) {
        String promptTemplate = ArichatClassic.summarySettings.sumprompt;
        MacroContext context = new MacroContext(conversation, null, null);
        if (conversation != null) {
            context.setVar("user", playerName);
            context.setVar("char", charName);
        }
        StringBuilder prompt = new StringBuilder(MacroProcessor.process(promptTemplate, context));
        if (!cur.isEmpty()) {
            prompt.append("\n***\n");
            prompt.append("[Previous summary: ").append(cur).append("]");
        }
        prompt.append("\n***\n");
        for (int i = 0; i < history.size(); ++i) {
            String speaker;
            String formattedText;
            String reply = history.get(i);
            if (i % 2 == 0) {
                formattedText = DialogueGenerator.formatCharacterLine(reply);
                speaker = charName;
            } else {
                formattedText = DialogueGenerator.formatUserLine(reply);
                speaker = playerName;
            }
            prompt.append(String.format("%s: %s\n", speaker, formattedText));
        }
        return prompt.toString();
    }

    public static boolean shouldSummary(EntityPlayer player) {
        Character character = Character.get(player);
        assert (character != null);
        Dialogue dialogue = character.getDialogue();
        if (dialogue == null) {
            GuiScreen screen;
            if (player.field_70170_p.field_72995_K && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiInteractionScreen && (dialogue = (Dialogue)Mappet.dialogues.load(((GuiInteractionScreen)screen).fragment.reaction.dialogueID)) != null) {
                return dialogue.summarise;
            }
            return false;
        }
        return dialogue.summarise;
    }

    public static String getSummary(EntityPlayer player) {
        Character character = Character.get(player);
        assert (character != null);
        States states = character.getStates();
        Dialogue dialogue = character.getDialogue();
        if (dialogue == null) {
            GuiScreen screen;
            if (player.field_70170_p.field_72995_K && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiInteractionScreen && (dialogue = (Dialogue)Mappet.dialogues.load(((GuiInteractionScreen)screen).fragment.reaction.dialogueID)) != null) {
                return states.getSummary(dialogue.getId());
            }
            return "";
        }
        return states.getSummary(dialogue.getId());
    }
}

