/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kiraririria.arichatclassic.client.api.CardSection;
import kiraririria.arichatclassic.client.api.ImageCard;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CardCategory {
    public CardSection parent;
    public String title;
    public boolean hidden;
    public List<ImageCard> morphs = new ArrayList<ImageCard>();

    public CardCategory(CardSection parent, String title) {
        this.parent = parent;
        this.title = title;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitle() {
        if (Objects.equals(this.title, "cards")) {
            return I18n.func_135052_a((String)"arichatclassic.category.cards", (Object[])new Object[]{""});
        }
        return I18n.func_135052_a((String)"arichatclassic.category.cards", (Object[])new Object[]{this.title});
    }

    public List<ImageCard> getMorphs() {
        return this.morphs;
    }

    public boolean isHidden() {
        return this.morphs.isEmpty() || this.hidden;
    }

    public ImageCard getEqual(ImageCard morph) {
        for (ImageCard child : this.morphs) {
            if (!child.toNBT().equals((Object)morph.toNBT())) continue;
            return child;
        }
        return null;
    }

    public void clear() {
        this.morphs.clear();
        this.notifyParent();
    }

    public final void add(ImageCard morph) {
        MorphManager.INSTANCE.applySettings((AbstractMorph)morph.morph);
        this.addMorph(morph);
        this.notifyParent();
    }

    protected void addMorph(ImageCard morph) {
        this.morphs.add(morph);
    }

    public boolean isEditable(ImageCard morph) {
        return false;
    }

    public void edit(ImageCard morph) {
        this.notifyParent();
    }

    public boolean remove(ImageCard morph) {
        boolean result = this.morphs.remove(morph);
        if (result) {
            this.notifyParent();
        }
        return result;
    }

    public boolean keyTyped(EntityPlayer player, int keycode) {
        return false;
    }

    private void notifyParent() {
        if (this.parent != null && this.parent.parentList != null) {
            this.parent.parentList.invalidateCache();
        }
    }
}

