/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.client.api.CardCategory;
import kiraririria.arichatclassic.client.api.CardSection;
import kiraririria.arichatclassic.client.api.ImageCard;
import net.minecraft.world.World;

public class CardList {
    public List<CardSection> sections = new ArrayList<CardSection>();
    private Map<String, ImageCard> filenameToCardCache = null;
    private boolean cacheValid = false;

    public void register(CardSection section) {
        this.sections.add(section);
        this.invalidateCache();
    }

    public void update(World world) {
        for (CardSection section : this.sections) {
            section.update(world);
        }
    }

    public void clear() {
        this.sections.clear();
        this.invalidateCache();
    }

    public <T> T getSection(Class<T> clazz) {
        for (CardSection section : this.sections) {
            if (section.getClass() != clazz) continue;
            return clazz.cast(section);
        }
        return null;
    }

    public ImageCard getImageCardByFilename(String filename) {
        if (filename.isEmpty()) {
            return ImageCard.empty();
        }
        if (!this.cacheValid || this.filenameToCardCache == null) {
            this.rebuildCache();
        }
        return this.filenameToCardCache.get(filename);
    }

    public List<ImageCard> findImageCardsByPartialName(String partialName) {
        ArrayList<ImageCard> result = new ArrayList<ImageCard>();
        if (!this.cacheValid || this.filenameToCardCache == null) {
            this.rebuildCache();
        }
        for (Map.Entry<String, ImageCard> entry : this.filenameToCardCache.entrySet()) {
            if (!entry.getKey().toLowerCase().contains(partialName.toLowerCase())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    public void rebuildCache() {
        this.filenameToCardCache = new HashMap<String, ImageCard>();
        for (CardSection section : this.sections) {
            for (CardCategory category : section.categories) {
                for (ImageCard imageCard : category.morphs) {
                    if (imageCard.filename == null || imageCard.filename.isEmpty()) continue;
                    this.filenameToCardCache.put(imageCard.filename, imageCard);
                }
            }
        }
        this.cacheValid = true;
        ArichatClassic.log("Rebuilt image card cache, found " + this.filenameToCardCache.size() + " cards");
    }

    public void invalidateCache() {
        this.cacheValid = false;
        this.filenameToCardCache = null;
    }

    public boolean hasImageCard(String filename) {
        if (!this.cacheValid || this.filenameToCardCache == null) {
            this.rebuildCache();
        }
        return this.filenameToCardCache.containsKey(filename);
    }

    public List<String> getAllFilenames() {
        if (!this.cacheValid || this.filenameToCardCache == null) {
            this.rebuildCache();
        }
        return new ArrayList<String>(this.filenameToCardCache.keySet());
    }
}

