/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.client.api.CardCategory;
import kiraririria.arichatclassic.client.api.CardList;
import kiraririria.arichatclassic.client.api.ImageCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCardSection;
import kiraririria.arichatclassic.client.gui.cards.GuiCardsList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CardSection {
    public String title;
    public List<CardCategory> categories = new ArrayList<CardCategory>();
    public boolean hidden;
    CardList parentList;

    public CardSection(String title) {
        this.title = title;
        CardCategory extra = new CardCategory(this, "cards");
        this.processDirectory(ClientProxy.cardsFolder, extra, "");
        this.categories.sort(Comparator.comparing(o -> o.title));
    }

    public CardSection(String title, CardList parentList) {
        this.title = title;
        this.parentList = parentList;
        CardCategory extra = new CardCategory(this, "cards");
        this.processDirectory(ClientProxy.cardsFolder, extra, "");
        this.categories.sort(Comparator.comparing(o -> o.title));
    }

    private void processDirectory(File directory, CardCategory parentCategory, String currentPath) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                ImageCard card;
                if (file.isDirectory()) {
                    CardCategory subCategory = new CardCategory(this, file.getName());
                    this.processDirectory(file, subCategory, currentPath + file.getName() + "/");
                    continue;
                }
                if (!file.getName().toLowerCase().endsWith(".png") || (card = ImageCard.importCard(currentPath + file.getName())) == null) continue;
                parentCategory.add(card);
            }
            this.categories.add(parentCategory);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitle() {
        return I18n.func_135052_a((String)("arichatclassic.section." + this.title), (Object[])new Object[0]);
    }

    public void add(CardCategory category) {
        this.categories.add(category);
        this.notifyCacheInvalidation();
    }

    public void remove(CardCategory category) {
        this.categories.remove(category);
        this.notifyCacheInvalidation();
    }

    public void update(World world) {
        this.notifyCacheInvalidation();
    }

    public void reset() {
        this.categories.clear();
        this.notifyCacheInvalidation();
    }

    @SideOnly(value=Side.CLIENT)
    public GuiCardSection getGUI(Minecraft mc, GuiCardsList parent, Consumer<GuiCardSection> callback) {
        return new GuiCardSection(mc, parent, this, callback);
    }

    private void notifyCacheInvalidation() {
        if (this.parentList != null) {
            this.parentList.invalidateCache();
        }
    }

    public void setParentList(CardList parentList) {
        this.parentList = parentList;
    }
}

