/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.api;

import kiraririria.arichatclassic.client.ArichatClassicPack;
import kiraririria.arichatclassic.engine.CharacterCard;
import mchorse.blockbuster_pack.morphs.ImageMorph;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ImageCard {
    public ImageMorph morph;
    public CharacterCard card;
    public String filename;

    private ImageCard(ImageMorph morph, CharacterCard card, String filename) {
        this.morph = morph;
        this.card = card;
        this.filename = filename;
    }

    public static ImageCard importCard(String cardName) {
        CharacterCard characterCard = CharacterCard.fromPng(cardName.split(".png")[0]);
        ImageMorph image = new ImageMorph();
        image.texture = RLUtils.create((String)ArichatClassicPack.ARICHAT_DOMAIN, (String)cardName);
        return new ImageCard(image, characterCard, cardName);
    }

    public static ImageCard empty() {
        CharacterCard characterCard = CharacterCard.empty();
        ImageMorph image = new ImageMorph();
        return new ImageCard(image, characterCard, "");
    }

    public final NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.toNBT(tag);
        return tag;
    }

    public void toNBT(NBTTagCompound tag) {
        tag.func_74782_a("Morph", (NBTBase)this.morph.toNBT());
        tag.func_74782_a("CharacterCard", (NBTBase)this.card.toNBT());
        tag.func_74778_a("FileName", this.filename);
    }

    public void reset() {
        this.morph = new ImageMorph();
        this.card = CharacterCard.empty();
        this.filename = "";
    }

    public void fromNBT(NBTTagCompound tag) {
        this.reset();
        this.morph.fromNBT(tag.func_74775_l("Morph"));
        this.card.deserializeNBT(tag.func_74775_l("CharacterCard"));
        this.filename = tag.func_74779_i("FileName");
    }

    public final ImageCard copy() {
        ImageCard morph = new ImageCard(new ImageMorph(), CharacterCard.empty(), "");
        assert (this.getClass().isInstance(morph));
        morph.copy(this);
        return morph;
    }

    public void copy(ImageCard from) {
        this.morph.copy((AbstractMorph)from.morph);
        this.card.copy(from.card);
        this.filename = from.filename;
    }
}

