/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.client.gui.config.GuiProfileOverlayPanel;
import kiraririria.arichatclassic.common.Emotion;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.triggers.GuiTriggerElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class GuiEmotionPanel
extends GuiProfileOverlayPanel<EmotionEntry> {
    private final List<Emotion> emotions;
    private final Consumer<List<Emotion>> callback;
    private final GuiTextElement nameField;
    private final GuiTextElement descriptionField;
    private final GuiNestedEdit morphButton;
    private final GuiTriggerElement triggerButton;
    private final GuiIconElement addButton;
    private final GuiIconElement removeButton;
    private final GuiIconElement copyButton;
    private final GuiIconElement pasteButton;
    private final GuiElement editor;

    public GuiEmotionPanel(Minecraft mc, List<Emotion> emotions, Consumer<List<Emotion>> callback, boolean isComplex) {
        super(mc, IKey.lang((String)"arichatclassic.gui.aiaction.title"));
        this.title.tooltip(IKey.lang((String)"arichatclassic.gui.aiaction.emotion_tooltip"));
        this.emotions = new ArrayList<Emotion>(emotions);
        this.callback = callback;
        this.nameField = new GuiTextElement(mc, 1000, this::updateCurrentEmotion);
        this.descriptionField = new GuiTextElement(mc, 1000, this::updateCurrentEmotion);
        this.morphButton = new GuiNestedEdit(mc, this::openMorphMenu);
        this.triggerButton = new GuiTriggerElement(mc);
        this.addButton = new GuiIconElement(mc, Icons.ADD, b -> this.addEmotion());
        this.removeButton = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeEmotion());
        this.copyButton = new GuiIconElement(mc, Icons.COPY, b -> this.copyEmotions());
        this.pasteButton = new GuiIconElement(mc, Icons.PASTE, b -> this.pasteEmotions());
        this.addButton.tooltip(IKey.lang((String)"arichatclassic.gui.aiaction.add"), Direction.TOP);
        this.removeButton.tooltip(IKey.lang((String)"arichatclassic.gui.aiaction.remove"), Direction.TOP);
        this.copyButton.tooltip(IKey.lang((String)"arichatclassic.gui.aiaction.copy_all"), Direction.TOP);
        this.pasteButton.tooltip(IKey.lang((String)"arichatclassic.gui.aiaction.paste_all"), Direction.TOP);
        this.icons.add(new IGuiElement[]{this.addButton, this.removeButton, this.pasteButton, this.copyButton});
        this.editor = Elements.column((Minecraft)mc, (int)10, (int)10, (GuiElement[])new GuiElement[]{Elements.label((IKey)IKey.lang((String)"arichatclassic.gui.aiaction.name")), this.nameField, Elements.label((IKey)IKey.lang((String)"arichatclassic.gui.aiaction.morph")), this.morphButton});
        if (isComplex) {
            this.editor.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"arichatclassic.gui.aiaction.description")).tooltip(IKey.lang((String)"arichatclassic.gui.aiaction.description_tooltip")));
            this.editor.add((IGuiElement)this.descriptionField);
        }
        this.editor.add((IGuiElement)Elements.label((IKey)IKey.lang((String)"arichatclassic.gui.aiaction.trigger")));
        this.editor.add((IGuiElement)this.triggerButton);
        this.editor.flex().relative(this.content).x(0.3f).w(0.5f).h(1.0f);
        this.list.flex().w(0.3f);
        this.content.add((IGuiElement)this.editor);
        this.loadEmotions();
        this.updateState();
    }

    private void loadEmotions() {
        this.list.clear();
        for (Emotion emotion : this.emotions) {
            this.list.add((Object)new EmotionEntry(emotion));
        }
        if (!this.list.getList().isEmpty()) {
            this.list.setIndex(0);
            this.pickItem((EmotionEntry)this.list.getCurrentFirst(), true);
        }
        this.updateState();
    }

    private void updateState() {
        boolean hasElements = !this.list.getList().isEmpty();
        this.editor.setVisible(hasElements);
        this.editor.setEnabled(hasElements);
        this.removeButton.setEnabled(hasElements);
        this.copyButton.setEnabled(hasElements);
        if (!hasElements) {
            this.clearFields();
        }
    }

    private void addEmotion() {
        Emotion emotion = new Emotion();
        this.emotions.add(emotion);
        EmotionEntry entry = new EmotionEntry(emotion);
        this.list.add((Object)entry);
        this.list.setCurrent((Object)entry);
        this.updateFields();
        this.updateState();
    }

    private void removeEmotion() {
        EmotionEntry entry = (EmotionEntry)this.list.getCurrentFirst();
        if (entry != null) {
            int index = this.list.getList().indexOf(entry);
            this.emotions.remove(entry.emotion);
            this.list.remove((Object)entry);
            if (!this.list.getList().isEmpty()) {
                if (index > 0) {
                    --index;
                }
                this.list.setIndex(index);
                this.pickItem((EmotionEntry)this.list.getCurrentFirst(), true);
            } else {
                this.clearFields();
            }
        }
        this.updateState();
    }

    private void copyEmotions() {
        NBTTagList list = new NBTTagList();
        for (Emotion emotion : this.emotions) {
            list.func_74742_a((NBTBase)emotion.serializeNBT());
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Emotions", (NBTBase)list);
        GuiScreen.func_146275_d((String)compound.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pasteEmotions() {
        try {
            String data = GuiScreen.func_146277_j();
            NBTTagCompound compound = JsonToNBT.func_180713_a((String)data);
            NBTTagList list = compound.func_150295_c("Emotions", 10);
            this.emotions.clear();
            this.list.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Emotion emotion = new Emotion();
                emotion.deserializeNBT(list.func_150305_b(i));
                this.emotions.add(emotion);
                this.list.add((Object)new EmotionEntry(emotion));
            }
            if (!this.list.getList().isEmpty()) {
                this.list.setIndex(0);
                this.pickItem((EmotionEntry)this.list.getCurrentFirst(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.updateState();
        }
    }

    private void openMorphMenu(boolean editing) {
        EmotionEntry entry = (EmotionEntry)this.list.getCurrentFirst();
        if (entry != null) {
            GuiMappetDashboard.get((Minecraft)this.mc).openMorphMenu(this.getParentContainer(), editing, entry.emotion.morph, morph -> {
                entry.emotion.morph = MorphUtils.copy((AbstractMorph)morph);
                this.morphButton.setMorph(morph);
            });
        }
    }

    private void updateCurrentEmotion(String text) {
        EmotionEntry entry = (EmotionEntry)this.list.getCurrentFirst();
        if (entry != null) {
            entry.emotion.name = this.nameField.field.func_146179_b();
            entry.emotion.description = this.descriptionField.field.func_146179_b();
            this.list.update();
        }
    }

    private Trigger updateCurrentTrigger() {
        EmotionEntry entry = (EmotionEntry)this.list.getCurrentFirst();
        if (entry != null) {
            return entry.emotion.trigger;
        }
        return null;
    }

    private void updateFields() {
        EmotionEntry entry = (EmotionEntry)this.list.getCurrentFirst();
        if (entry != null) {
            this.nameField.setText(entry.emotion.name);
            this.descriptionField.setText(entry.emotion.description);
            this.morphButton.setMorph(entry.emotion.morph);
            this.triggerButton.set(entry.emotion.trigger);
        }
    }

    private void clearFields() {
        this.nameField.setText("");
        this.descriptionField.setText("");
        this.morphButton.setMorph(null);
        this.triggerButton.set(new Trigger());
    }

    @Override
    protected GuiListElement<EmotionEntry> createList(Minecraft mc) {
        return new GuiEmotionListElement(mc, list -> this.pickItem((EmotionEntry)list.get(0), false));
    }

    @Override
    protected void pickItem(EmotionEntry item, boolean select) {
        super.pickItem(item, select);
        this.updateFields();
    }

    @Override
    protected void fillData(EmotionEntry item) {
        this.updateFields();
    }

    public void onClose() {
        super.onClose();
        this.emotions.forEach(emotion -> {
            Trigger n = new Trigger();
            n.deserializeNBT(emotion.trigger.serializeNBT());
            emotion.trigger = n;
        });
        this.callback.accept(this.emotions);
    }

    public static class GuiEmotionListElement
    extends GuiListElement<EmotionEntry> {
        public GuiEmotionListElement(Minecraft mc, Consumer<List<EmotionEntry>> callback) {
            super(mc, callback);
        }

        protected String elementToString(EmotionEntry element) {
            return element.emotion.name;
        }
    }

    public static class EmotionEntry {
        public Emotion emotion;

        public EmotionEntry(Emotion emotion) {
            this.emotion = emotion;
        }
    }
}

