/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.vecmath.Vector2d;
import mchorse.mappet.client.gui.utils.text.TextLine;
import mchorse.mappet.client.gui.utils.text.utils.Cursor;
import mchorse.mappet.client.gui.utils.text.utils.StringGroup;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.mclib.utils.undo.UndoManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class GuiUEMultiTextElement<T extends TextLine>
extends GuiElement
implements ITextColoring {
    public ScrollArea horizontal = new ScrollArea();
    public ScrollArea vertical = new ScrollArea();
    public Consumer<String> callback;
    protected int padding = 10;
    protected int lineHeight = 12;
    protected int textColor = 0xFFFFFF;
    protected boolean textShadow;
    protected boolean wrapping;
    private int dragging;
    protected List<T> text = new ArrayList<T>();
    public final Cursor cursor = new Cursor();
    public final Cursor selection = new Cursor(-1, 0);
    private int lastMX;
    private int lastMY;
    private long lastUpdate;
    private StringGroup lastGroup;
    private UndoManager<GuiUEMultiTextElement> undo;
    private int lastW;

    public GuiUEMultiTextElement(Minecraft mc) {
        super(mc);
    }

    public void wrap(boolean wrapping) {
        this.wrapping = wrapping;
    }

    public void setColor(int textColor, boolean textShadow) {
        this.textColor = textColor;
        this.textShadow = textShadow;
    }

    public void setText(String text) {
        this.text.clear();
        for (String line : text.split("\n")) {
            this.text.add(this.createTextLine(line));
        }
        this.cursor.set(0, 0);
        this.selection.set(-1, 0);
        this.horizontal.scroll = 0;
        this.vertical.scroll = 0;
        this.undo = new UndoManager(100).simpleMerge();
        if (this.area.w > 0) {
            this.recalculateWrapping();
            this.recalculateSizes();
        }
    }

    protected T createTextLine(String line) {
        return (T)new TextLine(line);
    }

    public String getText() {
        return this.text.stream().map(t -> t.text).collect(Collectors.joining("\n"));
    }

    public int getWrappedWidth() {
        return this.area.w - this.padding * 3 - this.getShiftX();
    }

    public boolean isSelected() {
        return !this.selection.isEmpty();
    }

    public void startSelecting() {
        this.selection.copy(this.cursor);
    }

    public String getText(Cursor a, Cursor b) {
        StringJoiner joiner = new StringJoiner("\n");
        Cursor min = a.isThisLessTo(b) ? a : b;
        Cursor max = a.isThisLessTo(b) ? b : a;
        for (int i = min.line; i <= Math.min(max.line, this.text.size() - 1); ++i) {
            String line = ((TextLine)this.text.get((int)i)).text;
            if (i == min.line && i == max.line) {
                joiner.add(line.substring(min.getOffset(line), max.getOffset(line)));
                continue;
            }
            if (i == min.line) {
                joiner.add(min.end(line));
                continue;
            }
            if (i == max.line) {
                joiner.add(max.start(line));
                continue;
            }
            joiner.add(line);
        }
        return joiner.toString();
    }

    public void clear() {
        this.setText("");
    }

    public Cursor getMin() {
        return this.selection.isThisLessTo(this.cursor) ? this.selection : this.cursor;
    }

    public Cursor getMax() {
        return this.selection.isThisLessTo(this.cursor) ? this.cursor : this.selection;
    }

    public void resize() {
        super.resize();
        if (this.lastW != this.area.w) {
            this.lastW = this.area.w;
            this.recalculateWrapping();
        }
        this.recalculateSizes();
        this.horizontal.clamp();
        this.vertical.clamp();
    }

    protected void recalculateWrapping() {
        if (this.wrapping) {
            for (TextLine textLine : this.text) {
                this.calculateWrappedLine(textLine);
            }
        }
    }

    protected void calculateWrappedLine(T textLine) {
        if (this.wrapping) {
            ((TextLine)textLine).calculateWrappedLines(this.font, this.getWrappedWidth());
        } else {
            ((TextLine)textLine).resetWrapping();
        }
    }

    protected void recalculateSizes() {
        int w = 0;
        int h = 0;
        for (TextLine textLine : this.text) {
            if (!this.wrapping) {
                w = Math.max(this.font.func_78256_a(textLine.text), w);
            }
            h += textLine.getLines() * this.lineHeight;
        }
        int offset = this.getShiftX();
        this.horizontal.copy(this.area);
        this.horizontal.x += offset;
        this.horizontal.w -= offset;
        this.horizontal.scrollSize = this.wrapping ? w : this.getHorizontalSize(w);
        this.vertical.copy(this.area);
        this.vertical.scrollSize = h - (this.lineHeight - this.font.field_78288_b) + this.padding * 2;
    }

    public void draw(GuiContext context) {
        super.draw(context);
        GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)this.area.w, (int)this.area.h, (GuiContext)context);
        int x = this.area.x + this.padding;
        int y = this.area.y + this.padding;
        Cursor min = this.getMin();
        Cursor max = this.getMax();
        if (this.isSelected()) {
            this.drawSelectionBar(x, y, min, max);
        }
        int ci = this.text.size();
        for (int i = 0; i < ci; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            String line = textLine.text;
            int newX = x - this.horizontal.scroll + this.getShiftX();
            int newY = y - this.vertical.scroll;
            if (newY > this.area.ey()) break;
            int lines = textLine.getLines() - 1;
            if (newY + this.font.field_78288_b + lines * this.lineHeight >= this.area.y) {
                int cursorW = 0;
                int cursorA = 0;
                if (textLine.wrappedLines == null) {
                    this.drawTextLine(line, i, 0, newX, newY);
                } else {
                    int wrappedW = 0;
                    int cj = textLine.wrappedLines.size();
                    for (int j = 0; j < cj; ++j) {
                        String wrappedLine = textLine.wrappedLines.get(j);
                        int lineW = this.font.func_78256_a(wrappedLine);
                        int lineY = newY + j * this.lineHeight;
                        if (cursorW >= wrappedW && cursorW < wrappedW + lineW || this.cursor.offset >= textLine.text.length()) {
                            Gui.func_73734_a((int)(newX + cursorW - wrappedW), (int)(lineY - 1), (int)(newX + cursorW - wrappedW + 1), (int)(lineY + this.font.field_78288_b + 1), (int)(cursorA + 0xFFFFFF));
                        }
                        this.drawTextLine(wrappedLine, i, j, newX, lineY);
                        wrappedW += lineW;
                    }
                }
            }
            y += textLine.getLines() * this.lineHeight;
        }
        this.horizontal.drawScrollbar();
        this.vertical.drawScrollbar();
        GuiDraw.unscissor((GuiContext)context);
    }

    protected int getShiftX() {
        return 0;
    }

    protected int getHorizontalSize(int w) {
        return w + this.padding * 2 + this.getShiftX();
    }

    protected void drawTextLine(String line, int i, int j, int nx, int ny) {
        this.font.func_175065_a(line, (float)nx, (float)ny, this.textColor, this.textShadow);
    }

    private void drawSelectionBar(int x, int y, Cursor min, Cursor max) {
        Vector2d minPos = this.getCursorPosition(min);
        Vector2d maxPos = this.getCursorPosition(max);
        this.drawSelectionArea(x + (int)minPos.x, y + (int)minPos.y, x + (int)maxPos.x, y + (int)maxPos.y);
    }

    protected Vector2d getCursorPosition(Cursor cursor) {
        Vector2d pos = new Vector2d();
        if (this.wrapping) {
            this.getCusrorPositionWrapped(cursor, pos);
        } else {
            String line = ((TextLine)this.text.get((int)cursor.line)).text;
            pos.x = this.font.func_78256_a(cursor.start(line));
            pos.y = cursor.line * this.lineHeight;
        }
        pos.x = pos.x - (double)this.horizontal.scroll + (double)this.getShiftX();
        pos.y -= (double)this.vertical.scroll;
        return pos;
    }

    private void getCusrorPositionWrapped(Cursor cursor, Vector2d pos) {
        int lines = 0;
        int offset = 0;
        int c = this.text.size();
        for (int i = 0; i < c; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            int textLines = textLine.getLines();
            if (i == cursor.line) {
                if (textLine.wrappedLines == null) {
                    offset = this.font.func_78256_a(cursor.start(textLine.text));
                    break;
                }
                int textOffset = 0;
                for (int j = 0; j < textLine.wrappedLines.size(); ++j) {
                    String wrappedLine = textLine.wrappedLines.get(j);
                    if (cursor.offset >= textOffset && cursor.offset < textOffset + wrappedLine.length()) {
                        offset = this.font.func_78256_a(wrappedLine.substring(0, cursor.offset - textOffset));
                        break;
                    }
                    ++lines;
                    textOffset += wrappedLine.length();
                }
                if (cursor.offset < textLine.text.length()) break;
                --lines;
                offset = this.font.func_78256_a(textLine.wrappedLines.get(textLine.wrappedLines.size() - 1));
                break;
            }
            lines += textLines;
        }
        pos.x = offset;
        pos.y = lines * this.lineHeight;
    }

    private void drawSelectionArea(int x1, int y1, int x2, int y2) {
        int endY;
        int selectionPad = 2;
        int color = -2013265920 + (Integer)McLib.primaryColor.get();
        boolean middle = y2 > y1 + this.lineHeight;
        boolean bottom = y2 > y1;
        int endX = bottom || middle ? this.area.ex() : x2 + 2;
        int n = endY = bottom && !middle ? y2 : y1 + this.font.field_78288_b;
        if (!bottom && !middle) {
            endY += 2;
        }
        Gui.func_73734_a((int)(x1 - 2), (int)(y1 - 2), (int)endX, (int)endY, (int)color);
        if (middle) {
            Gui.func_73734_a((int)this.area.x, (int)(y1 + this.font.field_78288_b), (int)this.area.ex(), (int)y2, (int)color);
        }
        if (bottom) {
            Gui.func_73734_a((int)this.area.x, (int)y2, (int)(x2 + 2), (int)(y2 + this.font.field_78288_b + 2), (int)color);
        }
    }
}

