/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.cards;

import java.util.function.Consumer;
import kiraririria.arichatclassic.client.api.CardCategory;
import kiraririria.arichatclassic.client.api.CardSection;
import kiraririria.arichatclassic.client.api.ImageCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCards;
import kiraririria.arichatclassic.client.gui.cards.GuiCardsList;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Keys;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;

public class GuiCardSection
extends GuiElement {
    public GuiCardsList parent;
    public CardSection section;
    public Consumer<GuiCardSection> callback;
    public int cellWidth = 110;
    public int cellHeight = 140;
    public boolean last;
    public boolean favorite;
    public ImageCard morph;
    public CardCategory category;
    protected ImageCard hoverMorph;
    protected CardCategory hoverCategory;
    private String filter = "";

    public GuiCardSection(Minecraft mc, GuiCardsList parent, CardSection section, Consumer<GuiCardSection> callback) {
        super(mc);
        this.parent = parent;
        this.section = section;
        this.callback = callback;
    }

    public GuiCardSection size(int w, int h) {
        this.cellWidth = w;
        this.cellHeight = h;
        return this;
    }

    public void set(ImageCard morph, CardCategory category) {
        this.morph = morph;
        this.category = category;
    }

    public void pick(ImageCard morph, CardCategory category) {
        this.set(morph, category);
        if (this.callback != null) {
            this.callback.accept(this);
        }
    }

    public void reset() {
        this.set(null, null);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public boolean noFilter() {
        return this.filter.isEmpty() && !this.favorite;
    }

    public boolean isMatching(ImageCard morph) {
        if (this.favorite) {
            return morph.morph.favorite;
        }
        if (this.filter.isEmpty()) {
            return true;
        }
        return morph.morph.texture.func_110623_a().toLowerCase().contains(this.filter) || morph.card.tags.toString().toLowerCase().contains(this.filter);
    }

    public void calculateXY(GuiCards morphs) {
        int j = 0;
        for (ImageCard morph : this.category.getMorphs()) {
            if (morph == this.morph) {
                int row = this.getPerRow();
                morphs.x = j % row;
                morphs.y = j / row;
                return;
            }
            if (!this.isMatching(morph)) continue;
            ++j;
        }
    }

    public ImageCard getMorphAt(GuiCards morphs) {
        int row = this.getPerRow();
        int size = this.category.getMorphs().size();
        if (morphs.y >= 0 && size != 0) {
            int i;
            if (morphs.y < size / row + 1 && (i = morphs.x + morphs.y * row) >= size) {
                return this.category.getMorphs().get(size - 1);
            }
            int j = 0;
            if (morphs.x < 0) {
                morphs.x = row - 1;
            }
            if (morphs.x > row - 1) {
                morphs.x = 0;
            }
            for (ImageCard morph : this.category.getMorphs()) {
                if (!this.isMatching(morph)) continue;
                if (j % row == morphs.x && j / row == morphs.y) {
                    return morph;
                }
                ++j;
            }
            return null;
        }
        return null;
    }

    public int getY(ImageCard selected) {
        if (this.section.categories.isEmpty()) {
            return 0;
        }
        int y = 20;
        int row = this.getPerRow();
        for (CardCategory category : this.section.categories) {
            int count = this.getMorphsSize(category);
            if (category.isHidden() || count == 0 && !this.noFilter()) continue;
            y += 21;
            int j = 0;
            for (int i = 0; i < category.getMorphs().size(); ++i) {
                ImageCard morph = category.getMorphs().get(i);
                if (!this.isMatching(morph)) continue;
                if (j != 0 && j % row == 0) {
                    y += this.cellHeight;
                }
                if (morph == selected) {
                    return y;
                }
                ++j;
            }
            y += this.cellHeight + 5;
        }
        return -1;
    }

    public int getMorphsSize(CardCategory category) {
        if (this.noFilter()) {
            return category.getMorphs().size();
        }
        int count = 0;
        for (ImageCard morph : category.getMorphs()) {
            count += this.isMatching(morph) ? 1 : 0;
        }
        return count;
    }

    public int getPerRow() {
        return Math.max(this.area.w / this.cellWidth, 1);
    }

    public int getCategoryHeight(CardCategory category) {
        return this.getCategoryHeight(this.getMorphsSize(category));
    }

    public int getCategoryHeight(int given) {
        int size = Math.max(given, 1);
        return (int)Math.ceil((float)size / (float)this.getPerRow()) * this.cellHeight;
    }

    public int getFullHeight() {
        int h = 20 + (this.last ? 30 : 0);
        if (!this.section.hidden) {
            int visibleCategories = 0;
            for (CardCategory category : this.section.categories) {
                int count = this.getMorphsSize(category);
                h += 21;
                if (category.isHidden() || count == 0 && !this.noFilter()) continue;
                h += this.getCategoryHeight(category) + 5;
                ++visibleCategories;
            }
            if (visibleCategories > 0) {
                h -= 5;
            }
        }
        return (int)Math.round((double)h * 1.2);
    }

    public boolean mouseClicked(GuiContext context) {
        boolean result = false;
        if (this.area.isInside(context) && !this.section.categories.isEmpty()) {
            if (context.mouseY - this.area.y < 20 && context.mouseButton == 0) {
                this.section.hidden = !this.section.hidden;
                return true;
            }
            int x = context.mouseX - this.area.x;
            int y = context.mouseY - this.area.y - 20;
            int row = this.getPerRow();
            block0: for (CardCategory category : this.section.categories) {
                int count = this.getMorphsSize(category);
                if (y < 16 && context.mouseButton == 0) {
                    category.hidden = !category.hidden;
                    return true;
                }
                y -= 21;
                if (category.isHidden() || count == 0 && !this.noFilter()) continue;
                int ix = (int)((float)x / ((float)this.area.w / (float)row));
                int iy = y / this.cellHeight;
                int i = ix + (y < 0 ? -1 : iy) * row;
                if (i >= 0 && i < count) {
                    int real = category.getMorphs().size();
                    if (count == real) {
                        this.pick(category.getMorphs().get(i), category);
                        result = true;
                        break;
                    }
                    int k = -1;
                    for (int j = 0; j < real; ++j) {
                        ImageCard morph = category.getMorphs().get(j);
                        if (this.isMatching(morph)) {
                            ++k;
                        }
                        if (i != k) continue;
                        this.pick(morph, category);
                        result = true;
                        break block0;
                    }
                }
                y -= this.getCategoryHeight(count) + 5;
            }
            if (!result) {
                this.pick(null, null);
            }
        }
        return super.mouseClicked(context) || result;
    }

    public GuiContextMenu createContextMenu(GuiContext context) {
        if (this.parent == null) {
            return super.createContextMenu(context);
        }
        GuiSimpleContextMenu contextMenu = new GuiSimpleContextMenu(this.mc);
        ImageCard morph = this.hoverMorph;
        if (morph != null) {
            contextMenu.action(Icons.EDIT, IKey.lang((String)"arichatclassic.gui.cards.edit"), () -> this.parent.enterEditMorph(morph));
            contextMenu.action(Icons.COPY, IKey.lang((String)"arichatclassic.gui.cards.copy"), () -> GuiScreen.func_146275_d((String)morph.toNBT().toString()));
        }
        return contextMenu;
    }

    public void draw(GuiContext context) {
        this.drawMorphs(context);
        int h = this.getFullHeight();
        if (this.area.h != h) {
            this.flex().h(h);
            this.getParent().getParent().resize();
        }
        super.draw(context);
    }

    protected void drawMorphs(GuiContext context) {
        if (!this.section.categories.isEmpty()) {
            Icon toggleIcon = this.section.hidden ? Icons.MOVE_DOWN : Icons.MOVE_UP;
            Gui.func_73734_a((int)this.area.x, (int)this.area.y, (int)this.area.ex(), (int)(this.area.y + 20), (int)-1157627904);
            this.font.func_175063_a(this.section.getTitle(), (float)(this.area.x + 7), (float)(this.area.y + 10 - this.font.field_78288_b / 2), 0xFFFFFF);
            toggleIcon.render(this.area.ex() - 18 - 3, this.area.y + 10 + (this.section.hidden ? 1 : -1), 0.0f, 0.5f);
            int y = 20;
            this.hoverMorph = null;
            this.hoverCategory = null;
            if (!this.section.hidden) {
                Area viewport = context.getViewport();
                int row = this.getPerRow();
                for (CardCategory category : this.section.categories) {
                    int count = this.getMorphsSize(category);
                    GuiDraw.drawTextBackground((FontRenderer)this.font, (String)category.getTitle(), (int)(this.area.x + 7), (int)(this.area.y + y + 8 - this.font.field_78288_b / 2), (int)0xEEEEEE, (int)-2013265920, (int)2);
                    (category.hidden ? Icons.MOVE_DOWN : Icons.MOVE_UP).render(this.area.ex() - 18 - 3, this.area.y + y + 8 + (category.hidden ? 1 : -1), 0.0f, 0.5f);
                    Area.SHARED.copy(this.area);
                    Area.SHARED.y = this.area.y + y;
                    Area.SHARED.h = 16 + this.getCategoryHeight(category);
                    if (Area.SHARED.isInside(context.mouseX, context.mouseY)) {
                        this.hoverCategory = category;
                    }
                    float x = 0.0f;
                    y += 21;
                    if (category.isHidden() || count == 0 && !this.noFilter()) continue;
                    int j = 0;
                    for (int i = 0; i < category.getMorphs().size(); ++i) {
                        ImageCard morph = category.getMorphs().get(i);
                        if (!this.isMatching(morph)) continue;
                        if (j != 0 && j % row == 0) {
                            x = 0.0f;
                            y += this.cellHeight;
                        }
                        int mx = this.area.x + Math.round(x);
                        int my = this.area.y + y;
                        int w = Math.round((x += (float)this.area.w / (float)row) - (float)(mx - this.area.x));
                        Area.SHARED.set(mx, my, w, this.cellHeight);
                        if (Area.SHARED.isInside(context.mouseX, context.mouseY)) {
                            this.hoverMorph = morph;
                        }
                        if (Area.SHARED.intersects(viewport)) {
                            GuiDraw.scissor((int)mx, (int)my, (int)w, (int)this.cellHeight, (GuiContext)context);
                            this.drawMorph(context, (AbstractMorph)morph.morph, mx, my, w, this.cellHeight, this.hoverMorph == morph, this.morph == morph);
                            GuiDraw.unscissor((GuiContext)context);
                        }
                        if (Area.SHARED.y > viewport.ey()) {
                            return;
                        }
                        ++j;
                    }
                    y += this.cellHeight + 5;
                }
            }
        }
    }

    protected void drawMorph(GuiContext context, AbstractMorph morph, int x, int y, int w, int h, boolean hover, boolean selected) {
        if (selected && !morph.errorRendering) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)(-1442840576 + (Integer)McLib.primaryColor.get()));
        } else if (hover) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)0x66000000);
        }
        int spot = (int)((float)w * 0.4f);
        int spotX = x + w / 2;
        int spotY = y + h / 2;
        GuiDraw.drawDropCircleShadow((int)spotX, (int)spotY, (int)spot, (int)((int)((float)spot * 0.65f)), (int)10, (int)0x44000000, (int)0);
        if (morph.errorRendering) {
            GuiDraw.drawOutline((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-1996554240, (int)4);
            GuiDraw.drawOutline((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-65536, (int)2);
        } else if (MorphUtils.renderOnScreen((AbstractMorph)morph, (EntityPlayer)this.mc.field_71439_g, (int)(x + w / 2), (int)(y + (int)((float)h * 0.82f)), (float)((float)w / 1.35f), (float)1.0f)) {
            if (selected) {
                GuiDraw.drawOutline((int)x, (int)y, (int)(x + w), (int)(y + h), (int)(-16777216 + (Integer)McLib.primaryColor.get()), (int)2);
            }
            if (morph.keybind != -1) {
                String key = Keys.getKeyName((int)morph.keybind);
                int kw = this.font.func_78256_a(key);
                int kx = x + w - 6 - kw;
                int ky = y + h - 6 - this.font.field_78288_b;
                Gui.func_73734_a((int)(kx - 3), (int)(ky - 2), (int)(kx + kw + 3), (int)(ky + this.font.field_78288_b + 2), (int)-16777216);
                this.font.func_175063_a(key, (float)kx, (float)ky, 0xFFFFFF);
            }
            if (morph.favorite) {
                GlStateManager.func_179112_b((int)770, (int)771);
                GuiDraw.drawOutlinedIcon((Icon)Icons.FAVORITE, (int)(x + 2), (int)(y + 2), (int)-1);
            }
        }
    }
}

