/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.cards;

import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.client.ArichatClassicPack;
import kiraririria.arichatclassic.client.api.ImageCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCardPanel;
import kiraririria.arichatclassic.engine.CharacterCard;
import mchorse.blockbuster_pack.morphs.ImageMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GuiCardSettingsPanel
extends GuiCardPanel<ImageCard, GuiCard> {
    public GuiScrollElement left;
    public GuiScrollElement leftup;
    public GuiButtonElement reset;
    public GuiButtonElement save;
    public GuiTextElement displayName;
    public String cardName;
    public String storedTag;
    public GuiTextElement data;
    public ImageMorph morph = new ImageMorph();

    public GuiCardSettingsPanel(Minecraft mc, GuiCard editor) {
        super(mc, editor);
        this.imageCard = editor.card;
        this.cardName = this.imageCard.morph.texture.func_110623_a();
        this.displayName = new GuiTextElement(mc, 1000000, string -> {
            this.cardName = string;
            this.morph.texture = this.getMorphLoc();
        });
        this.displayName.setText(this.cardName);
        this.morph.texture = this.getMorphLoc();
        this.left = new GuiScrollElement(mc);
        this.left.scroll.opposite = true;
        this.left.cancelScrollEdge();
        this.left.flex().relative((GuiElement)this).w(0.5f).h(1.0f).column(5).stretch().scroll().height(20).padding(10);
        this.leftup = new GuiScrollElement(mc);
        this.leftup.scroll.opposite = true;
        this.leftup.cancelScrollEdge();
        this.leftup.flex().relative((GuiElement)this).w(0.25f).h(1.0f).column(5).stretch().scroll().height(20).padding(10);
        this.reset = new GuiButtonElement(mc, IKey.lang((String)"arichatclassic.gui.cards.reset"), button -> {
            NBTTagCompound tag = new NBTTagCompound();
            this.imageCard.toNBT(tag);
            this.storedTag = tag.toString();
            this.data.setText(this.storedTag);
        });
        this.save = new GuiButtonElement(mc, IKey.lang((String)"arichatclassic.gui.cards.save"), button -> {
            if (this.cardName.isEmpty()) {
                return;
            }
            ImageCard characterCard = ImageCard.empty();
            try {
                characterCard.copy((ImageCard)editor.card);
                characterCard.fromNBT(JsonToNBT.func_180713_a((String)this.storedTag));
            }
            catch (NBTException e) {
                throw new RuntimeException(e);
            }
            CharacterCard.savePng(characterCard, this.cardName);
            ClientProxy.loadCards();
            editor.morphs.reload();
            editor.morphs.exit();
            Minecraft.func_71410_x().func_147108_a(null);
        });
        this.cardName = this.imageCard.morph.texture.func_110623_a();
        this.data = new GuiTextElement(mc, 1000000, string -> {
            this.storedTag = string;
        });
        this.data.flex().relative((GuiElement)this).set(10.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -30).w(1.0f, -20).row(5).preferred(0).height(20);
        this.leftup.add((IGuiElement)Elements.row((Minecraft)mc, (int)8, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.reset, this.save}));
        this.leftup.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"arichatclassic.gui.cards.filename")).marginTop(8), this.displayName});
        this.add(new IGuiElement[]{this.leftup, this.data});
    }

    public ResourceLocation getMorphLoc() {
        ResourceLocation location = RLUtils.create((String)ArichatClassicPack.ARICHAT_DOMAIN, (String)this.cardName);
        if (ReflectionUtils.getTextures((TextureManager)Minecraft.func_71410_x().field_71446_o).get(location) == null) {
            return this.imageCard.morph.texture;
        }
        return location;
    }

    @Override
    public void fillData(ImageCard morph) {
        super.fillData(morph);
    }

    @Override
    public void finishEditing() {
        super.finishEditing();
    }

    public void updateNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.imageCard.toNBT(tag);
        this.storedTag = tag.toString();
        this.data.setText(this.storedTag);
    }

    @Override
    public void startEditing() {
        super.startEditing();
        this.updateNBT();
        this.cardName = this.imageCard.morph.texture.func_110623_a();
        this.morph.texture = this.imageCard.morph.texture;
        this.displayName.setText(this.cardName);
        this.morph.texture = this.getMorphLoc();
    }

    public void draw(GuiContext context) {
        super.draw(context);
        this.morph.renderOnScreen((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.displayName.area.x * 12, this.displayName.area.y * 4, 100.0f, 1.0f);
        if (this.data.isVisible()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"arichatclassic.gui.cards.nbt_data", (Object[])new Object[0]), (float)this.data.area.x, (float)(this.data.area.y - 12), 0xFFFFFF);
        }
    }
}

