/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.cards;

import java.util.ArrayList;
import java.util.List;
import kiraririria.arichatclassic.client.api.CardCategory;
import kiraririria.arichatclassic.client.api.ImageCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCardSection;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiCards
extends GuiScrollElement {
    private static final CardCategory EMPTY_CATEGORY = new CardCategory(null, null);
    public String filter = "";
    public List<GuiCardSection> sections = new ArrayList<GuiCardSection>();
    public GuiCardSection selected;
    public int x;
    public int y;
    private boolean scrollTo;

    public GuiCards(Minecraft mc) {
        super(mc);
        this.scroll.scrollSpeed = 45;
        IKey category = IKey.lang((String)"metamorph.gui.morphs.keys.category");
        this.keys().register(IKey.lang((String)"metamorph.gui.morphs.keys.down"), 208, () -> this.pickMorph(0, 1)).category(category);
        this.keys().register(IKey.lang((String)"metamorph.gui.morphs.keys.up"), 200, () -> this.pickMorph(0, -1)).category(category);
        this.keys().register(IKey.lang((String)"metamorph.gui.morphs.keys.right"), 205, () -> this.pickMorph(1, 0)).category(category);
        this.keys().register(IKey.lang((String)"metamorph.gui.morphs.keys.left"), 203, () -> this.pickMorph(-1, 0)).category(category);
    }

    private void pickMorph(int x, int y) {
        if (this.selected == null || this.selected.morph == null) {
            x = 0;
            y = 0;
            this.selected = this.sections.get(0);
            this.selected.category = this.selected.section.categories.get(0);
            this.y = 0;
            this.x = 0;
        } else {
            this.selected.calculateXY(this);
        }
        int ox = this.x;
        this.x += x;
        this.y += y;
        ImageCard morph = this.selected.getMorphAt(this);
        if (morph != null) {
            this.selected.morph = morph;
            this.selected.pick(this.selected.morph, this.selected.category);
            this.scrollTo();
            return;
        }
        if (y < 0 && this.isFirstCategory(this.selected)) {
            return;
        }
        if (y > 0 && this.isLastCategory(this.selected)) {
            return;
        }
        if (y == 0) {
            y = 1;
        }
        GuiCardSection original = this.selected;
        GuiCardSection section = this.selected;
        CardCategory category = this.selected.category;
        do {
            int sectionIndex;
            int index;
            if ((index = section.section.categories.indexOf(category) + y) < 0) {
                sectionIndex = this.sections.indexOf((Object)section) - 1;
                if (sectionIndex < 0) {
                    return;
                }
                section = this.sections.get(sectionIndex);
                category = section.section.categories.isEmpty() ? EMPTY_CATEGORY : section.section.categories.get(section.section.categories.size() - 1);
                continue;
            }
            if (index >= section.section.categories.size()) {
                sectionIndex = this.sections.indexOf((Object)section) + 1;
                if (sectionIndex >= this.sections.size()) {
                    return;
                }
                section = this.sections.get(sectionIndex);
                category = section.section.categories.isEmpty() ? EMPTY_CATEGORY : section.section.categories.get(0);
                continue;
            }
            category = section.section.categories.get(index);
        } while (this.isCategoryEmpty(section, category));
        if (category.getMorphs().isEmpty()) {
            return;
        }
        original.reset();
        this.selected = section;
        this.selected.category = category;
        this.selected.morph = this.getFirstMorph(ox, y);
        this.selected.pick(this.selected.morph, this.selected.category);
        this.scrollTo();
    }

    private boolean isFirstCategory(GuiCardSection section) {
        return section == this.sections.get(0) && section.category == section.section.categories.get(0);
    }

    private boolean isLastCategory(GuiCardSection section) {
        return section == this.sections.get(this.sections.size() - 1) && section.category == section.section.categories.get(section.section.categories.size() - 1);
    }

    private boolean isCategoryEmpty(GuiCardSection section, CardCategory category) {
        if (category.getMorphs().isEmpty()) {
            return true;
        }
        return section.getMorphsSize(category) == 0;
    }

    private ImageCard getFirstMorph(int ox, int y) {
        List<ImageCard> list = this.selected.category.getMorphs();
        ImageCard first = null;
        int row = this.selected.getPerRow();
        int j = 0;
        int c = this.selected.getMorphsSize(this.selected.category);
        int firstIndex = y < 0 ? c - 1 : 0;
        int lastIndex = y < 0 ? (c - 1) / row * row + ox : ox;
        for (ImageCard morph : list) {
            if (!this.selected.isMatching(morph)) continue;
            if (j == firstIndex) {
                first = morph;
            }
            if (j == lastIndex) {
                return morph;
            }
            ++j;
        }
        return first;
    }

    public void setSelected(ImageCard morph) {
        this.resetSelected();
    }

    public void setSelectedDirect(GuiCardSection selected) {
        this.setSelectedDirect(selected, selected.morph, selected.category);
    }

    public void setSelectedDirect(GuiCardSection section, ImageCard morph, CardCategory category) {
        this.resetSelected();
        this.selected = section;
        this.selected.set(morph, category);
    }

    public void resetSelected() {
        if (this.selected != null) {
            this.selected.reset();
        }
    }

    public ImageCard getSelected() {
        return this.selected == null ? null : this.selected.morph;
    }

    public void setFilter(String filter) {
        if (filter.equals(this.filter)) {
            return;
        }
        String lcfilter = filter.toLowerCase().trim();
        for (GuiCardSection section : this.sections) {
            section.setFilter(lcfilter);
        }
        this.filter = lcfilter;
    }

    public void scrollTo() {
        if (this.area.w == 0) {
            this.scrollTo = true;
            return;
        }
        ImageCard morph = this.getSelected();
        if (morph == null) {
            return;
        }
        int y = 0;
        for (GuiCardSection section : this.sections) {
            if (section.morph == morph) {
                this.scroll.scrollIntoView(y + section.getY(section.morph), section.cellHeight + 30);
                break;
            }
            y += section.getFullHeight();
        }
    }

    @Override
    public void resize() {
        super.resize();
        for (GuiCardSection section : this.sections) {
            section.flex().h(section.getFullHeight());
        }
        super.resize();
        if (this.scrollTo) {
            this.scrollTo = false;
            this.scrollTo();
        }
    }
}

