/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.cards;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.client.api.ImageCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCard;
import kiraririria.arichatclassic.client.gui.cards.GuiCardSection;
import kiraririria.arichatclassic.client.gui.cards.GuiCreativeCards;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiDelegateElement;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IFocusedGuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;

public class GuiCardsList
extends GuiElement {
    public GuiDelegateElement<GuiCard> editor;
    private List<GuiCard> editors;
    public GuiElement bar;
    public GuiTextElement search;
    public GuiButtonElement edit;
    public GuiElement screen;
    public GuiCreativeCards morphs;
    protected Keybind exitKey;
    public Consumer<ImageCard> callback;

    public GuiCardsList(Minecraft mc, Consumer<ImageCard> callback) {
        super(mc);
        this.callback = callback;
        this.editor = new GuiDelegateElement(mc, null);
        this.editor.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.screen = new GuiElement(mc);
        this.screen.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
        this.morphs = new GuiCreativeCards(mc, this);
        this.morphs.flex().relative((GuiElement)this).wh(1.0f, 1.0f).column(0).vertical().stretch().scroll();
        this.bar = new GuiElement(mc);
        GuiCreativeCards var10004 = this.morphs;
        ((Object)((Object)var10004)).getClass();
        this.search = new GuiTextElement(mc, var10004::setFilter);
        this.edit = new GuiButtonElement(mc, IKey.lang((String)"metamorph.gui.edit"), b -> this.enterEditMorph());
        this.edit.setEnabled(false);
        this.edit.flex().w(60);
        this.bar.flex().relative((GuiElement)this.morphs).set(10.0f, 0.0f, 0.0f, 20.0f).y(1.0f, -30).w(1.0f, -20).row(5).preferred(0).height(20);
        this.bar.add(new IGuiElement[]{this.search, this.edit});
        this.screen.add(new IGuiElement[]{this.morphs, this.bar});
        this.add(new IGuiElement[]{this.screen, new GuiDrawable(this::drawOverlay), this.editor});
        IKey category = IKey.lang((String)"metamorph.gui.creative.keys.category");
        this.exitKey = this.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.exit"), 1, this::exit).category(category).active(this::updateExitKey);
        this.reload();
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.edit"), 18, this::enterEditMorph).category(category);
        this.morphs.keys().register(IKey.lang((String)"metamorph.gui.creative.keys.focus"), 33, () -> GuiBase.getCurrent().focus((IFocusedGuiElement)this.search, true)).held(new int[]{29}).category(category);
    }

    public void reload() {
        this.morphs.setupSections(this, this::pickMorph);
        this.search.setText("");
    }

    public void exit() {
        if (this.isEditMode()) {
            this.exitEditMorph(false);
        }
        GuiBase.getCurrent().setContextMenu(null);
    }

    protected boolean updateExitKey() {
        return this.editor.delegate != null;
    }

    public boolean isEditMode() {
        return this.editor.delegate != null;
    }

    public void enterEditMorph() {
        ImageCard morph = this.getSelected();
        if (morph != null) {
            if (!this.isSelectedMorphIsEditable()) {
                morph = morph.copy();
                this.pickMorph(morph);
            }
            this.enterEditMorph(morph);
        }
    }

    public void enterEditMorph(ImageCard morph) {
        GuiCard editor;
        if (morph != null && (editor = this.getMorphEditor(morph)) != null) {
            this.setEditor(editor);
        }
    }

    public void exitEditMorph(boolean ignore) {
        if (this.isEditMode()) {
            ((GuiCard)this.editor.delegate).finishEdit();
            Object edited = ((GuiCard)this.editor.delegate).card;
            if (!ignore) {
                this.pickMorph((ImageCard)edited);
            }
            this.morphs.syncSelected();
            if (edited != null && !this.isSelectedMorphIsEditable()) {
                this.setSelected((ImageCard)edited);
            }
            this.setEditor(null);
        }
    }

    protected void setEditor(GuiCard editor) {
        this.editor.setDelegate((GuiElement)editor);
        this.screen.setVisible(editor == null);
        this.updateExitKey();
    }

    public void finish() {
        while (this.isEditMode()) {
            this.exit();
        }
    }

    private GuiCard getMorphEditor(ImageCard morph) {
        if (this.editors == null) {
            this.editors = new ArrayList<GuiCard>();
            this.editors.add(new GuiCard<ImageCard>(this.mc, morph));
        }
        for (GuiCard editor : this.editors) {
            if (!editor.canEdit(morph)) continue;
            editor.setMorphs(this);
            editor.startEdit(morph);
            return editor;
        }
        return null;
    }

    public ImageCard getSelected() {
        Object morph;
        if (this.isEditMode() && (morph = ((GuiCard)this.editor.delegate).card) != null) {
            return morph;
        }
        return this.morphs.getSelected();
    }

    public void pickMorph(GuiCardSection selected) {
        this.morphs.setSelectedDirect(selected);
        this.pickMorph(selected.morph);
    }

    public void pickMorph(ImageCard morph) {
        this.edit.setEnabled(morph != null);
        if (this.callback != null && morph != null) {
            this.callback.accept(morph);
        }
    }

    public ImageCard setSelected(ImageCard morph) {
        this.morphs.setSelected(morph);
        morph = this.getSelected();
        this.edit.setEnabled(morph != null);
        return morph;
    }

    protected boolean isSelectedMorphIsEditable() {
        return this.morphs.isSelectedMorphIsEditable();
    }

    public void draw(GuiContext context) {
        super.draw(context);
    }

    private void drawOverlay(GuiContext context) {
        if (!this.isEditMode()) {
            boolean error;
            ImageCard morph = this.getSelected();
            String selected = morph != null ? morph.morph.texture.func_110623_a() : I18n.func_135052_a((String)"arichatclassic.gui.no_card", (Object[])new Object[0]);
            boolean bl = error = morph != null && morph.morph.errorRendering;
            if (error) {
                selected = I18n.func_135052_a((String)"metamorph.gui.morph_render_error", (Object[])new Object[0]);
            }
            Area area = this.search.area;
            int w = Math.max(this.font.func_78256_a(selected), morph != null ? this.font.func_78256_a(morph.morph.texture.func_110623_a()) : 0);
            if (morph != null && !morph.morph.errorRendering) {
                Gui.func_73734_a((int)area.x, (int)(area.y - 27), (int)(area.x + w + 8), (int)area.y, (int)-587202560);
                this.font.func_175063_a(selected, (float)(area.x + 4), (float)(area.y - 23), -1);
                this.font.func_175063_a(morph.card.tags.toString(), (float)(area.x + 4), (float)(area.y - 12), 0x888888);
            } else {
                Gui.func_73734_a((int)area.x, (int)(area.y - 16), (int)(area.x + w + 8), (int)area.y, (int)-587202560);
                this.font.func_175063_a(selected, (float)(area.x + 4), (float)(area.y - 12), error ? 16717875 : 0xFFFFFF);
            }
        }
        if (!this.isEditMode() && !this.search.field.func_146206_l() && this.search.field.func_146179_b().isEmpty()) {
            this.font.func_175063_a(I18n.func_135052_a((String)"metamorph.gui.search", (Object[])new Object[0]), (float)(this.search.area.x + 5), (float)(this.search.area.y + 6), 0x888888);
        }
    }
}

