/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.client.gui.config.GuiProfileOverlayPanel;
import kiraririria.arichatclassic.engine.InstructSettings;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;

public class GuiInstructEditorOverlayPanel
extends GuiProfileOverlayPanel<InstructSettingsEntry> {
    public GuiIconElement open;
    public GuiTextElement title;
    public GuiScrollElement scroll;
    public String filename;

    public GuiInstructEditorOverlayPanel(Minecraft mc) {
        super(mc, IKey.lang((String)"arichatclassic.gui.instruct.instruct_folder"));
        this.open = new GuiIconElement(mc, Icons.FOLDER, b -> InstructSettings.open());
        this.open.tooltip(IKey.lang((String)"arichatclassic.gui.presets.folder")).flex().wh(16, 16);
        this.title = new GuiTextElement(mc, 100, s -> {
            this.filename = s;
        });
        this.scroll = new GuiScrollElement(mc);
        this.scroll.scroll.opposite = false;
        this.scroll.cancelScrollEdge();
        this.scroll.flex().relative((IResizer)this.area).w(0.6f).h(0.95f).x(0.3f).column(5).stretch().vertical().scroll().height(20).padding(10);
        this.content.flex().h(0.5f);
        this.icons.add((IGuiElement)this.open);
        this.add(new IGuiElement[]{this.title, this.scroll});
        this.loadProfiles();
    }

    private void loadProfiles() {
        for (File file : InstructSettings.instructs()) {
            InstructSettings style = InstructSettings.loadFromFile(file);
            if (style == null) continue;
            InstructSettingsEntry entry = new InstructSettingsEntry(file, style);
            this.list.add((Object)entry);
        }
        for (InstructSettingsEntry entry : this.list.getList()) {
            if (!entry.file.getName().equals(ArichatClassic.valueInstruct.getFile())) continue;
            this.pickItem(entry, true);
            break;
        }
        if (this.list.isDeselected()) {
            this.list.setIndex(0);
            this.pickItem((InstructSettingsEntry)this.list.getCurrentFirst(), true);
        }
    }

    @Override
    protected GuiListElement<InstructSettingsEntry> createList(Minecraft mc) {
        return new GuiSyntaxStyleListElement(mc, l -> this.pickItem((InstructSettingsEntry)l.get(0), false));
    }

    @Override
    protected void pickItem(InstructSettingsEntry item, boolean select) {
        if (item == null) {
            return;
        }
        item.save();
        ArichatClassic.instructSettings = item.settings;
        ArichatClassic.valueInstruct.set(item.file.getName(), item.settings);
        this.fillScrollWithSettings(item.settings);
        super.pickItem(item, select);
    }

    @Override
    protected void fillData(InstructSettingsEntry item) {
        this.list.setCurrent((Object)item);
        this.title.setText(item.file.getName());
        this.fillScrollWithSettings(item.settings);
    }

    public void onClose() {
        InstructSettingsEntry item = (InstructSettingsEntry)this.list.getCurrentFirst();
        if (item == null) {
            super.onClose();
            return;
        }
        item.save();
        ArichatClassic.instructSettings = item.settings;
        super.onClose();
    }

    private void fillScrollWithSettings(InstructSettings settings) {
        this.scroll.removeAll();
        for (Field field : InstructSettings.class.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            try {
                Object value = field.get(settings);
                GuiElement element = this.createFieldElement(field, value, settings);
                if (element == null) continue;
                this.scroll.add((IGuiElement)Elements.label((IKey)IKey.str((String)fieldName)).marginBottom(2));
                this.scroll.add((IGuiElement)element.marginBottom(10));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.scroll.resize();
        this.scroll.repositionChildren();
        this.scroll.updateContentSize();
    }

    private GuiElement createFieldElement(Field field, Object value, InstructSettings settings) {
        Class<?> type = field.getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this.createToggleElement(field, (Boolean)value, settings);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.createTrackpadElement(field, ((Number)value).doubleValue(), settings).integer();
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.createTrackpadElement(field, (Double)value, settings);
        }
        if (type == String.class) {
            return this.createTextElement(field, (String)value, settings);
        }
        return null;
    }

    private GuiToggleElement createToggleElement(Field field, boolean value, InstructSettings settings) {
        return new GuiToggleElement(this.mc, IKey.EMPTY, value, b -> {
            try {
                field.set(settings, b.isToggled());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    private GuiTrackpadElement createTrackpadElement(Field field, double value, InstructSettings settings) {
        GuiTrackpadElement trackpad = new GuiTrackpadElement(this.mc, v -> {
            try {
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    field.set(settings, v.intValue());
                } else {
                    field.set(settings, (double)v);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        trackpad.setValue(value);
        return trackpad;
    }

    private GuiTextElement createTextElement(Field field, String value, InstructSettings settings) {
        GuiTextElement guiTextElement = new GuiTextElement(this.mc, 1000, s -> {
            try {
                field.set(settings, s);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        guiTextElement.setText(value);
        return guiTextElement;
    }

    public static class InstructSettingsEntry {
        public File file;
        public InstructSettings settings;

        public InstructSettingsEntry(File file, InstructSettings style) {
            this.file = file;
            this.settings = style;
        }

        public void save() {
            InstructSettings.saveToFile(this.settings, this.file);
        }
    }

    public static class GuiSyntaxStyleListElement
    extends GuiListElement<InstructSettingsEntry> {
        public GuiSyntaxStyleListElement(Minecraft mc, Consumer<List<InstructSettingsEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        protected String elementToString(InstructSettingsEntry element) {
            return element.file.getName();
        }
    }
}

