/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.engine.api.OpenRouterModel;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;

public class GuiModelEditorOverlayPanel
extends GuiOverlayPanel {
    public GuiListElement<ModelEntry> list;
    public GuiTextElement title;
    public GuiTextElement search;
    public String filename;
    private final List<ModelEntry> allModels = new ArrayList<ModelEntry>();
    protected ModelEntry item;

    public GuiModelEditorOverlayPanel(Minecraft mc) {
        super(mc, IKey.lang((String)"arichatclassic.gui.model.select_models"));
        this.list = this.createList(mc);
        this.list.flex().relative(this.content).w(1.0f).h(0.95f);
        this.search = new GuiTextElement(mc, 100, this::filterModels);
        this.search.flex().relative((IResizer)this.area).w(1.0f).h(0.05f);
        this.content.add(this.list);
        this.add((IGuiElement)this.search);
        this.title = new GuiTextElement(mc, 100, s -> {
            this.filename = s;
        });
        this.content.flex().h(0.95f);
        this.loadModelsWithDetails();
    }

    private void filterModels(String filter) {
        this.list.clear();
        if (filter == null || filter.isEmpty()) {
            for (ModelEntry entry : this.allModels) {
                this.list.add((Object)entry);
            }
        } else {
            String lowerFilter = filter.toLowerCase();
            for (ModelEntry entry : this.allModels) {
                if (!entry.model.toLowerCase().contains(lowerFilter) && (entry.pricingInfo == null || !entry.pricingInfo.toLowerCase().contains(lowerFilter)) && (entry.contextLength == null || !entry.contextLength.toLowerCase().contains(lowerFilter))) continue;
                this.list.add((Object)entry);
            }
        }
        this.list.update();
        this.list.setIndex(0);
        if (!this.list.getList().isEmpty()) {
            this.pickItem((ModelEntry)this.list.getCurrentFirst(), true);
        }
    }

    private void loadModelsWithDetails() {
        if (ArichatClassic.getMainConnection() instanceof OpenRouterModel) {
            OpenRouterModel openRouter = (OpenRouterModel)ArichatClassic.getMainConnection();
            openRouter.fetchModelsWithDetailsAsync(modelDetails -> Minecraft.func_71410_x().func_152344_a(() -> {
                this.allModels.clear();
                this.list.clear();
                for (OpenRouterModel.ModelDetail modelDetail : modelDetails) {
                    ModelEntry entry = new ModelEntry(modelDetail);
                    this.allModels.add(entry);
                    this.list.add((Object)entry);
                }
                String currentModel = ArichatClassic.openrouterModel.get();
                for (ModelEntry entry : this.list.getList()) {
                    if (!entry.model.equals(currentModel)) continue;
                    this.pickItem(entry, true);
                    break;
                }
                if (this.list.isDeselected() && !this.list.getList().isEmpty()) {
                    this.list.setIndex(0);
                    this.pickItem((ModelEntry)this.list.getCurrentFirst(), true);
                }
                this.list.update();
            }));
        }
    }

    protected GuiListElement<ModelEntry> createList(Minecraft mc) {
        return new GuiModelListElement(mc, l -> this.pickItem((ModelEntry)l.get(0), false));
    }

    protected void pickItem(ModelEntry item, boolean select) {
        this.item = item;
        if (item != null) {
            ArichatClassic.openrouterModel.set(item.model);
            this.fillData(item);
            if (select) {
                this.list.setCurrentScroll((Object)item);
            }
            this.resize();
        }
    }

    protected void fillData(ModelEntry item) {
        this.list.setCurrent((Object)item);
        this.title.setText(item.model);
    }

    public void onClose() {
        super.onClose();
    }

    public static class ModelEntry {
        public String model;
        public String pricingInfo;
        public String contextLength;

        public ModelEntry(OpenRouterModel.ModelDetail modelDetail) {
            this.model = modelDetail.id;
            this.pricingInfo = this.formatPricingInfo(modelDetail);
            this.contextLength = this.formatContextLength(modelDetail);
        }

        private String formatPricingInfo(OpenRouterModel.ModelDetail detail) {
            if (detail.promptPrice > 0.0 || detail.completionPrice > 0.0) {
                double promptPerThousand = detail.promptPrice * 1000.0;
                double completionPerThousand = detail.completionPrice * 1000.0;
                if (promptPerThousand < 0.01 && completionPerThousand < 0.01) {
                    return String.format("$%.5f/$%.5f per 1K", promptPerThousand, completionPerThousand);
                }
                return String.format("$%.3f/$%.3f per 1K", promptPerThousand, completionPerThousand);
            }
            return "Price not available";
        }

        private String formatContextLength(OpenRouterModel.ModelDetail detail) {
            if (detail.contextLength > 0) {
                if (detail.contextLength >= 1000000) {
                    return String.format("%.1fM tokens", (double)detail.contextLength / 1000000.0);
                }
                if (detail.contextLength >= 1000) {
                    return String.format("%.0fK tokens", (double)detail.contextLength / 1000.0);
                }
                return detail.contextLength + " tokens";
            }
            return "Context not available";
        }

        public String getDisplayString() {
            return this.model + "  |  \u00a77" + this.pricingInfo + " | " + this.contextLength;
        }
    }

    public static class GuiModelListElement
    extends GuiListElement<ModelEntry> {
        public GuiModelListElement(Minecraft mc, Consumer<List<ModelEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 32;
        }

        protected String elementToString(ModelEntry element) {
            return element.getDisplayString();
        }
    }
}

