/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.client.gui.config.GuiProfileOverlayPanel;
import kiraririria.arichatclassic.engine.SummarySettings;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;

public class GuiSummaryEditorOverlayPanel
extends GuiProfileOverlayPanel<SummarySettingsEntry> {
    public GuiIconElement open;
    public GuiTextElement title;
    public GuiScrollElement scroll;
    public String filename;

    public GuiSummaryEditorOverlayPanel(Minecraft mc) {
        super(mc, IKey.lang((String)"arichatclassic.gui.summary.summary"));
        this.open = new GuiIconElement(mc, Icons.FOLDER, b -> SummarySettings.open());
        this.open.tooltip(IKey.lang((String)"arichatclassic.gui.presets.folder")).flex().wh(16, 16);
        this.title = new GuiTextElement(mc, 100, s -> {
            this.filename = s;
        });
        this.scroll = new GuiScrollElement(mc);
        this.scroll.scroll.opposite = false;
        this.scroll.cancelScrollEdge();
        this.scroll.flex().relative((IResizer)this.area).w(0.6f).h(0.95f).x(0.3f).column(5).stretch().vertical().scroll().height(20).padding(10);
        this.content.flex().h(0.5f);
        this.icons.add((IGuiElement)this.open);
        this.add(new IGuiElement[]{this.title, this.scroll});
        this.loadProfiles();
    }

    private void loadProfiles() {
        for (File file : SummarySettings.fileList()) {
            SummarySettings style = SummarySettings.loadFromFile(file);
            if (style == null) continue;
            SummarySettingsEntry entry = new SummarySettingsEntry(file, style);
            this.list.add((Object)entry);
        }
        for (SummarySettingsEntry entry : this.list.getList()) {
            if (!entry.file.getName().equals(ArichatClassic.valueInstruct.getFile())) continue;
            this.pickItem(entry, true);
            break;
        }
        if (this.list.isDeselected()) {
            this.list.setIndex(0);
            this.pickItem((SummarySettingsEntry)this.list.getCurrentFirst(), true);
        }
    }

    @Override
    protected GuiListElement<SummarySettingsEntry> createList(Minecraft mc) {
        return new GuiSyntaxStyleListElement(mc, l -> this.pickItem((SummarySettingsEntry)l.get(0), false));
    }

    @Override
    protected void pickItem(SummarySettingsEntry item, boolean select) {
        if (item == null) {
            return;
        }
        item.save();
        ArichatClassic.summarySettings = item.settings;
        ArichatClassic.valueSummary.set(item.file.getName(), item.settings);
        this.fillScrollWithSettings(item.settings);
        super.pickItem(item, select);
    }

    @Override
    protected void fillData(SummarySettingsEntry item) {
        this.list.setCurrent((Object)item);
        this.title.setText(item.file.getName());
        this.fillScrollWithSettings(item.settings);
    }

    public void onClose() {
        SummarySettingsEntry item = (SummarySettingsEntry)this.list.getCurrentFirst();
        if (item == null) {
            super.onClose();
            return;
        }
        item.save();
        ArichatClassic.summarySettings = item.settings;
        super.onClose();
    }

    private void fillScrollWithSettings(SummarySettings settings) {
        this.scroll.removeAll();
        for (Field field : SummarySettings.class.getDeclaredFields()) {
            field.setAccessible(true);
            String fieldName = field.getName();
            try {
                Object value = field.get(settings);
                GuiElement element = this.createFieldElement(field, value, settings);
                if (element == null) continue;
                this.scroll.add((IGuiElement)Elements.label((IKey)IKey.str((String)fieldName)).marginBottom(2));
                this.scroll.add((IGuiElement)element.marginBottom(10));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.scroll.resize();
        this.scroll.repositionChildren();
        this.scroll.updateContentSize();
    }

    private GuiElement createFieldElement(Field field, Object value, SummarySettings settings) {
        Class<?> type = field.getType();
        if (type == Boolean.TYPE || type == Boolean.class) {
            return this.createToggleElement(field, (Boolean)value, settings);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return this.createTrackpadElement(field, ((Number)value).doubleValue(), settings).integer();
        }
        if (type == Double.TYPE || type == Double.class) {
            return this.createTrackpadElement(field, (Double)value, settings);
        }
        if (type == String.class) {
            return this.createTextElement(field, (String)value, settings);
        }
        return null;
    }

    private GuiToggleElement createToggleElement(Field field, boolean value, SummarySettings settings) {
        return new GuiToggleElement(this.mc, IKey.EMPTY, value, b -> {
            try {
                field.set(settings, b.isToggled());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }

    private GuiTrackpadElement createTrackpadElement(Field field, double value, SummarySettings settings) {
        GuiTrackpadElement trackpad = new GuiTrackpadElement(this.mc, v -> {
            try {
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    field.set(settings, v.intValue());
                } else {
                    field.set(settings, (double)v);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        trackpad.setValue(value);
        return trackpad;
    }

    private GuiTextElement createTextElement(Field field, String value, SummarySettings settings) {
        GuiTextElement guiTextElement = new GuiTextElement(this.mc, 1000, s -> {
            try {
                field.set(settings, s);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        guiTextElement.setText(value);
        return guiTextElement;
    }

    public static class SummarySettingsEntry {
        public File file;
        public SummarySettings settings;

        public SummarySettingsEntry(File file, SummarySettings style) {
            this.file = file;
            this.settings = style;
        }

        public void save() {
            SummarySettings.saveToFile(this.settings, this.file);
        }
    }

    public static class GuiSyntaxStyleListElement
    extends GuiListElement<SummarySettingsEntry> {
        public GuiSyntaxStyleListElement(Minecraft mc, Consumer<List<SummarySettingsEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        protected String elementToString(SummarySettingsEntry element) {
            return element.file.getName();
        }
    }
}

