/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.client.gui.config;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.client.gui.config.GuiProfileOverlayPanel;
import kiraririria.arichatclassic.engine.prompt.Sysprompt;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;

public class GuiSystempormptEditorOverlayPanel
extends GuiProfileOverlayPanel<PromptSettingsEntry> {
    public GuiIconElement open;
    public GuiTextElement title;
    public String filename;
    private final Sysprompt sysprompt;
    Consumer<Sysprompt> callback;

    public GuiSystempormptEditorOverlayPanel(Minecraft mc, Sysprompt value, Consumer<Sysprompt> callback) {
        super(mc, IKey.lang((String)"arichatclassic.gui.systemprompt.prompt"));
        this.sysprompt = value;
        this.callback = callback;
        this.open = new GuiIconElement(mc, Icons.FOLDER, b -> GuiSystempormptEditorOverlayPanel.open());
        this.open.tooltip(IKey.lang((String)"arichatclassic.gui.systemprompt.folder")).flex().wh(16, 16);
        this.title = new GuiTextElement(mc, 100, s -> {
            this.filename = s;
        });
        this.content.flex().h(1.0f);
        this.icons.add((IGuiElement)this.open);
        this.loadPrompts();
        this.add((IGuiElement)this.title);
    }

    public static void open() {
        GuiUtils.openFolder((String)ClientProxy.syspromptFolder.getAbsolutePath());
    }

    private void loadPrompts() {
        for (File file : Sysprompt.sysprompts()) {
            Sysprompt style = Sysprompt.load(file);
            if (style == null) continue;
            PromptSettingsEntry entry = new PromptSettingsEntry(file, style);
            this.list.add((Object)entry);
        }
        for (PromptSettingsEntry entry : this.list.getList()) {
            if (!entry.sysprompt.serializeNBT().equals((Object)this.sysprompt.serializeNBT())) continue;
            this.pickItem(entry, true);
            break;
        }
        if (this.list.isDeselected()) {
            this.list.setIndex(0);
            this.pickItem((PromptSettingsEntry)this.list.getCurrentFirst(), true);
        }
    }

    @Override
    protected GuiListElement<PromptSettingsEntry> createList(Minecraft mc) {
        return new GuiPromptListElement(mc, l -> this.pickItem((PromptSettingsEntry)l.get(0), false));
    }

    @Override
    protected void pickItem(PromptSettingsEntry item, boolean select) {
        item.save();
        this.callback.accept(item.sysprompt);
        super.pickItem(item, select);
    }

    @Override
    protected void fillData(PromptSettingsEntry item) {
        this.list.setCurrent((Object)item);
        this.title.setText(item.file.getName());
    }

    public void onClose() {
        PromptSettingsEntry item = (PromptSettingsEntry)this.list.getCurrentFirst();
        item.save();
        this.callback.accept(item.sysprompt);
        super.onClose();
    }

    public static class PromptSettingsEntry {
        public File file;
        public Sysprompt sysprompt;

        public PromptSettingsEntry(File file, Sysprompt style) {
            this.file = file;
            this.sysprompt = style;
        }

        public void save() {
        }
    }

    public static class GuiPromptListElement
    extends GuiListElement<PromptSettingsEntry> {
        public GuiPromptListElement(Minecraft mc, Consumer<List<PromptSettingsEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        protected String elementToString(PromptSettingsEntry element) {
            return element.file.getName();
        }
    }
}

