/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class Emotion
implements INBTSerializable<NBTTagCompound> {
    public AbstractMorph morph = this.getDefaultMorph();
    public String name = "calm";
    public String description = "calm";
    public Trigger trigger = new Trigger();

    public AbstractMorph getDefaultMorph() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", "blockbuster.fred");
        return MorphManager.INSTANCE.morphFromNBT(tag);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound morph = new NBTTagCompound();
        if (this.morph != null) {
            this.morph.toNBT(morph);
            tag.func_74782_a("Morph", (NBTBase)morph);
        }
        tag.func_74778_a("Name", this.name);
        tag.func_74778_a("Description", this.description);
        if (!this.trigger.isEmpty()) {
            tag.func_74782_a("Trigger", (NBTBase)this.trigger.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.morph = MorphManager.INSTANCE.morphFromNBT(nbt.func_74775_l("Morph"));
        this.name = nbt.func_74779_i("Name");
        this.description = nbt.func_74779_i("Description");
        if (nbt.func_74764_b("Trigger")) {
            this.trigger.deserializeNBT(nbt.func_74775_l("Trigger"));
        }
    }

    public static List<String> getUniqueEmotionNames(List<Emotion> emotions) {
        if (emotions == null) {
            return new ArrayList<String>();
        }
        return emotions.stream().map(emotion -> emotion.name).distinct().collect(Collectors.toList());
    }

    public static Optional<Emotion> getEmotionByName(List<Emotion> emotions, String name) {
        if (emotions == null || name == null) {
            return Optional.empty();
        }
        return emotions.stream().filter(emotion -> name.equals(emotion.name)).findFirst();
    }

    public static Map<String, String> getEmotionMap(List<Emotion> emotions) {
        if (emotions == null) {
            return new HashMap<String, String>();
        }
        return emotions.stream().collect(Collectors.toMap(emotion -> emotion.name, emotion -> emotion.description, (existing, replacement) -> existing));
    }
}

