/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.client.api.ImageCard;
import kiraririria.arichatclassic.engine.PngMetadataHandler;
import kiraririria.arichatclassic.utils.ImageUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.io.FileUtils;

public class CharacterCard
implements INBTSerializable<NBTTagCompound> {
    public String spec = "chara_card_v2";
    public String specVersion = "2.0";
    public String name = "";
    public String description = "";
    public String personality = "";
    public String scenario = "";
    public String firstMes = "";
    public String mesExample = "";
    public String creatorNotes = "";
    public String systemPrompt = "";
    public String postHistoryInstructions = "";
    public List<String> alternateGreetings = new ArrayList<String>();
    public List<String> tags = new ArrayList<String>();
    public String creator = "";
    public String characterVersion = "";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private CharacterCard() {
    }

    public NBTTagCompound serializeNBT() {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("spec", this.spec);
            tag.func_74778_a("specVersion", this.specVersion);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("name", this.name);
            data.func_74778_a("description", this.description);
            data.func_74778_a("personality", this.personality);
            data.func_74778_a("scenario", this.scenario);
            data.func_74778_a("firstMes", this.firstMes);
            data.func_74778_a("mesExample", this.mesExample);
            data.func_74778_a("creatorNotes", this.creatorNotes);
            data.func_74778_a("systemPrompt", this.systemPrompt);
            data.func_74778_a("postHistoryInstructions", this.postHistoryInstructions);
            NBTTagList data_tags = new NBTTagList();
            for (String s : this.tags) {
                data_tags.func_74742_a((NBTBase)new NBTTagString(s));
            }
            data.func_74782_a("tags", (NBTBase)data_tags);
            NBTTagList data_alternateGreetings = new NBTTagList();
            for (String s : this.alternateGreetings) {
                data_alternateGreetings.func_74742_a((NBTBase)new NBTTagString(s));
            }
            data.func_74782_a("alternateGreetings", (NBTBase)data_alternateGreetings);
            data.func_74778_a("creator", this.creator);
            data.func_74778_a("characterVersion", this.characterVersion);
            tag.func_74782_a("data", (NBTBase)data);
            return tag;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize character card to NBT", e);
        }
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int i;
        NBTTagList list;
        if (nbt.func_74764_b("specVersion")) {
            this.specVersion = nbt.func_74779_i("specVersion");
        }
        if (nbt.func_74764_b("spec")) {
            this.spec = nbt.func_74779_i("spec");
        }
        if (!nbt.func_74764_b("data")) {
            return;
        }
        NBTTagCompound data = nbt.func_74775_l("data");
        if (data.func_74764_b("creator")) {
            this.creator = data.func_74779_i("creator");
        }
        if (data.func_74764_b("creatorNotes")) {
            this.creatorNotes = data.func_74779_i("creatorNotes");
        }
        if (data.func_74764_b("mesExample")) {
            this.mesExample = data.func_74779_i("mesExample");
        }
        if (data.func_74764_b("characterVersion")) {
            this.characterVersion = data.func_74779_i("characterVersion");
        }
        if (data.func_74764_b("description")) {
            this.description = data.func_74779_i("description");
        }
        if (data.func_74764_b("systemPrompt")) {
            this.systemPrompt = data.func_74779_i("systemPrompt");
        }
        if (data.func_74764_b("firstMes")) {
            this.firstMes = data.func_74779_i("firstMes");
        }
        if (data.func_74764_b("personality")) {
            this.personality = data.func_74779_i("personality");
        }
        if (data.func_74764_b("scenario")) {
            this.scenario = data.func_74779_i("scenario");
        }
        if (data.func_74764_b("name")) {
            this.name = data.func_74779_i("name");
        }
        if (data.func_74764_b("postHistoryInstructions")) {
            this.postHistoryInstructions = data.func_74779_i("postHistoryInstructions");
        }
        if (data.func_74764_b("tags")) {
            list = data.func_150295_c("tags", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.tags.add(list.func_150307_f(i));
            }
        }
        if (data.func_74764_b("alternateGreetings")) {
            list = data.func_150295_c("alternateGreetings", 8);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.alternateGreetings.add(list.func_150307_f(i));
            }
        }
    }

    public void copy(CharacterCard other) {
        this.spec = other.spec;
        this.specVersion = other.specVersion;
        this.name = other.name;
        this.description = other.description;
        this.personality = other.personality;
        this.scenario = other.scenario;
        this.firstMes = other.firstMes;
        this.mesExample = other.mesExample;
        this.creatorNotes = other.creatorNotes;
        this.systemPrompt = other.systemPrompt;
        this.postHistoryInstructions = other.postHistoryInstructions;
        this.alternateGreetings = other.alternateGreetings;
        this.tags = other.tags;
        this.creator = other.creator;
        this.characterVersion = other.characterVersion;
    }

    public NBTTagCompound toNBT() {
        return this.serializeNBT();
    }

    public static String clearWhaterMark(String string) {
        return string.split("\n")[0];
    }

    public static CharacterCard empty() {
        return new CharacterCard();
    }

    public String toJson() {
        JsonObject root = new JsonObject();
        root.addProperty("spec", this.spec);
        root.addProperty("spec_version", this.specVersion);
        JsonObject data = new JsonObject();
        data.addProperty("name", this.name);
        data.addProperty("description", this.description);
        data.addProperty("personality", this.personality);
        data.addProperty("scenario", this.scenario);
        data.addProperty("first_mes", this.firstMes);
        data.addProperty("mes_example", this.mesExample);
        data.addProperty("creator_notes", this.creatorNotes);
        data.addProperty("system_prompt", this.systemPrompt);
        data.addProperty("post_history_instructions", this.postHistoryInstructions);
        JsonArray greetingsArray = new JsonArray();
        this.alternateGreetings.forEach(arg_0 -> ((JsonArray)greetingsArray).add(arg_0));
        data.add("alternate_greetings", (JsonElement)greetingsArray);
        JsonArray tagsArray = new JsonArray();
        this.tags.forEach(arg_0 -> ((JsonArray)tagsArray).add(arg_0));
        data.add("tags", (JsonElement)tagsArray);
        data.addProperty("creator", this.creator);
        data.addProperty("character_version", this.characterVersion);
        root.add("data", (JsonElement)data);
        return GSON.toJson((JsonElement)root);
    }

    public void fromJson(String json) {
        JsonObject root = new JsonParser().parse(json).getAsJsonObject();
        JsonObject data = root.getAsJsonObject("data");
        this.spec = this.getStringSafe(root, "spec", "chara_card_v2");
        this.specVersion = this.getStringSafe(root, "spec_version", "2.0");
        this.name = this.getStringSafe(data, "name");
        this.description = this.getStringSafe(data, "description");
        this.personality = this.getStringSafe(data, "personality");
        this.scenario = this.getStringSafe(data, "scenario");
        this.firstMes = this.getStringSafe(data, "first_mes");
        this.mesExample = this.getStringSafe(data, "mes_example");
        this.creatorNotes = this.getStringSafe(data, "creator_notes");
        this.systemPrompt = this.getStringSafe(data, "system_prompt", "");
        this.postHistoryInstructions = this.getStringSafe(data, "post_history_instructions", "");
        this.creator = this.getStringSafe(data, "creator", "");
        this.characterVersion = this.getStringSafe(data, "character_version", "");
        this.alternateGreetings = this.getStringListSafe(data, "alternate_greetings");
        this.tags = this.getStringListSafe(data, "tags");
    }

    private String getStringSafe(JsonObject obj, String key) {
        return this.getStringSafe(obj, key, "");
    }

    private String getStringSafe(JsonObject obj, String key, String defaultValue) {
        if (obj.has(key) && !obj.get(key).isJsonNull()) {
            return obj.get(key).getAsString();
        }
        return defaultValue;
    }

    private List<String> getStringListSafe(JsonObject obj, String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (obj.has(key) && obj.get(key).isJsonArray()) {
            JsonArray array = obj.getAsJsonArray(key);
            array.forEach(e -> result.add(e.getAsString()));
        }
        return result;
    }

    public String toString() {
        return this.toJson();
    }

    public boolean hasTag(String tag) {
        return this.tags.stream().anyMatch(t -> t.equalsIgnoreCase(tag));
    }

    public static CharacterCard fromPng(String cardName) {
        CharacterCard characterCard = new CharacterCard();
        try {
            ImageUtil.handleImage(cardName + ".png");
            String jsonData = PngMetadataHandler.readPngTextChunk(ImageUtil.getResourceImageInputStream(cardName + ".png"));
            if (jsonData == null) {
                ArichatClassic.log("[Card] Load empty char " + cardName + ".png");
                return characterCard;
            }
            characterCard.fromJson(jsonData);
            characterCard.creatorNotes = CharacterCard.clearWhaterMark(characterCard.creatorNotes);
            return characterCard;
        }
        catch (IOException e) {
            ArichatClassic.log(e.getMessage());
            return characterCard;
        }
    }

    public static void savePng(ImageCard imageCard, String cardName) {
        File file = new File(ClientProxy.cardsFolder, cardName);
        if (!file.exists()) {
            try {
                File file2 = new File(ClientProxy.cardsFolder, imageCard.morph.texture.func_110623_a());
                FileUtils.copyFile((File)file2, (File)file);
                file.mkdirs();
            }
            catch (IOException e) {
                ArichatClassic.log(e.getMessage());
            }
        }
        CharacterCard.savePng(imageCard.card, cardName.split(".png")[0]);
    }

    public static void savePng(CharacterCard characterCard, String cardName) {
        try {
            byte[] newImage = PngMetadataHandler.writePngMetadata(ImageUtil.getResourceImageInputStream(cardName + ".png"), characterCard.toJson());
            try (FileOutputStream fos = new FileOutputStream(new File(ClientProxy.cardsFolder, cardName + ".png"));){
                fos.write(newImage);
                fos.flush();
            }
            ImageUtil.handleImage(cardName + ".png");
        }
        catch (IOException e) {
            ArichatClassic.log(e.getMessage());
        }
    }
}

