/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kiraririria.arichatclassic.ClientProxy;
import mchorse.mclib.client.gui.utils.GuiUtils;

public class InstructSettings {
    public String input_sequence = "";
    public String output_sequence = "";
    public String last_output_sequence = "";
    public String system_sequence = "";
    public String stop_sequence = "";
    public boolean wrap = true;
    public boolean macro = true;
    public String names_behavior = "none";
    public String activation_regex = "";
    public String system_sequence_prefix = "";
    public String system_sequence_suffix = "";
    public String first_output_sequence = "";
    public boolean skip_examples = false;
    public String output_suffix = "";
    public String input_suffix = "";
    public String system_suffix = "";
    public String user_alignment_message = "";
    public boolean system_same_as_user = true;
    public String last_system_sequence = "";
    public String name = "Custom";

    public InstructSettings() {
    }

    public InstructSettings(String name) {
        this.name = name;
    }

    public static InstructSettings fromJson(JsonObject json) {
        InstructSettings settings = new InstructSettings();
        try {
            if (json.has("input_sequence")) {
                settings.input_sequence = json.get("input_sequence").getAsString();
            }
            if (json.has("output_sequence")) {
                settings.output_sequence = json.get("output_sequence").getAsString();
            }
            if (json.has("last_output_sequence")) {
                settings.last_output_sequence = json.get("last_output_sequence").getAsString();
            }
            if (json.has("system_sequence")) {
                settings.system_sequence = json.get("system_sequence").getAsString();
            }
            if (json.has("stop_sequence")) {
                settings.stop_sequence = json.get("stop_sequence").getAsString();
            }
            if (json.has("wrap")) {
                settings.wrap = json.get("wrap").getAsBoolean();
            }
            if (json.has("macro")) {
                settings.macro = json.get("macro").getAsBoolean();
            }
            if (json.has("names_behavior")) {
                settings.names_behavior = json.get("names_behavior").getAsString();
            }
            if (json.has("activation_regex")) {
                settings.activation_regex = json.get("activation_regex").getAsString();
            }
            if (json.has("system_sequence_prefix")) {
                settings.system_sequence_prefix = json.get("system_sequence_prefix").getAsString();
            }
            if (json.has("system_sequence_suffix")) {
                settings.system_sequence_suffix = json.get("system_sequence_suffix").getAsString();
            }
            if (json.has("first_output_sequence")) {
                settings.first_output_sequence = json.get("first_output_sequence").getAsString();
            }
            if (json.has("skip_examples")) {
                settings.skip_examples = json.get("skip_examples").getAsBoolean();
            }
            if (json.has("output_suffix")) {
                settings.output_suffix = json.get("output_suffix").getAsString();
            }
            if (json.has("input_suffix")) {
                settings.input_suffix = json.get("input_suffix").getAsString();
            }
            if (json.has("system_suffix")) {
                settings.system_suffix = json.get("system_suffix").getAsString();
            }
            if (json.has("user_alignment_message")) {
                settings.user_alignment_message = json.get("user_alignment_message").getAsString();
            }
            if (json.has("system_same_as_user")) {
                settings.system_same_as_user = json.get("system_same_as_user").getAsBoolean();
            }
            if (json.has("last_system_sequence")) {
                settings.last_system_sequence = json.get("last_system_sequence").getAsString();
            }
            if (json.has("name")) {
                settings.name = json.get("name").getAsString();
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing instruct settings: " + e.getMessage());
        }
        return settings;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("input_sequence", this.input_sequence);
        json.addProperty("output_sequence", this.output_sequence);
        json.addProperty("last_output_sequence", this.last_output_sequence);
        json.addProperty("system_sequence", this.system_sequence);
        json.addProperty("stop_sequence", this.stop_sequence);
        json.addProperty("wrap", Boolean.valueOf(this.wrap));
        json.addProperty("macro", Boolean.valueOf(this.macro));
        json.addProperty("names_behavior", this.names_behavior);
        json.addProperty("activation_regex", this.activation_regex);
        json.addProperty("system_sequence_prefix", this.system_sequence_prefix);
        json.addProperty("system_sequence_suffix", this.system_sequence_suffix);
        json.addProperty("first_output_sequence", this.first_output_sequence);
        json.addProperty("skip_examples", Boolean.valueOf(this.skip_examples));
        json.addProperty("output_suffix", this.output_suffix);
        json.addProperty("input_suffix", this.input_suffix);
        json.addProperty("system_suffix", this.system_suffix);
        json.addProperty("user_alignment_message", this.user_alignment_message);
        json.addProperty("system_same_as_user", Boolean.valueOf(this.system_same_as_user));
        json.addProperty("last_system_sequence", this.last_system_sequence);
        json.addProperty("name", this.name);
        return json;
    }

    public static void saveToFile(InstructSettings settings, File file) {
        try (FileWriter writer = new FileWriter(file);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)settings.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InstructSettings loadFromFile(File file) {
        if (!file.exists()) {
            return new InstructSettings(file.getName().replace(".json", ""));
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            InstructSettings instructSettings = InstructSettings.fromJson(json);
            return instructSettings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new InstructSettings(file.getName().replace(".json", ""));
        }
    }

    public static List<File> instructs() {
        ArrayList<File> settings = new ArrayList<File>();
        File[] files = ClientProxy.instructFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                settings.add(file);
            }
        }
        return settings;
    }

    public static void open() {
        GuiUtils.openFolder((String)ClientProxy.instructFolder.getAbsolutePath());
    }
}

