/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kiraririria.arichatclassic.ClientProxy;
import mchorse.mclib.client.gui.utils.GuiUtils;

public class SummarySettings {
    public String sumprompt = "Summarize the following conversation in a concise manner";
    public String name = "Custom";

    public SummarySettings() {
    }

    public SummarySettings(String name) {
        this.name = name;
    }

    public static SummarySettings fromJson(JsonObject json) {
        SummarySettings settings = new SummarySettings();
        try {
            if (json.has("sumprompt")) {
                settings.sumprompt = json.get("sumprompt").getAsString();
            }
            if (json.has("name")) {
                settings.name = json.get("name").getAsString();
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing instruct settings: " + e.getMessage());
        }
        return settings;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("sumprompt", this.sumprompt);
        json.addProperty("name", this.name);
        return json;
    }

    public static void saveToFile(SummarySettings settings, File file) {
        try (FileWriter writer = new FileWriter(file);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)settings.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SummarySettings loadFromFile(File file) {
        if (!file.exists()) {
            return new SummarySettings(file.getName().replace(".json", ""));
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject json = new JsonParser().parse((Reader)reader).getAsJsonObject();
            SummarySettings summarySettings = SummarySettings.fromJson(json);
            return summarySettings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new SummarySettings(file.getName().replace(".json", ""));
        }
    }

    public static List<File> fileList() {
        ArrayList<File> settings = new ArrayList<File>();
        File[] files = ClientProxy.summaryFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                settings.add(file);
            }
        }
        return settings;
    }

    public static void open() {
        GuiUtils.openFolder((String)ClientProxy.summaryFolder.getAbsolutePath());
    }
}

