/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.engine.api.IModel;
import kiraririria.arichatclassic.engine.prompt.RequestBuilder;

public class KoboldAI
implements IModel {
    private static final int TIMEOUT = 30000;

    public String getModels() throws IOException {
        HttpURLConnection conn = this.createConnection((String)ArichatClassic.koboldUrl.get() + "/v1/models", "GET", false);
        return this.readFullResponseWithRetry(conn);
    }

    public String getVersion() throws IOException {
        HttpURLConnection conn = this.createConnection((String)ArichatClassic.koboldUrl.get() + "/v1/info/version", "GET", false);
        return this.readFullResponseWithRetry(conn);
    }

    @Override
    public void generateTextStream(String prompt, JsonObject object, Consumer<String> onChunk) throws IOException {
        this.generateTextStream(object, onChunk, (Boolean)ArichatClassic.streamResponse.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextStream(JsonObject request, Consumer<String> onChunk, boolean useStreaming) throws IOException {
        block32: {
            HttpURLConnection conn = this.createConnection((String)ArichatClassic.koboldUrl.get() + "/v1/completions", "POST", useStreaming);
            try (OutputStream os = conn.getOutputStream();){
                os.write(request.toString().getBytes(StandardCharsets.UTF_8));
            }
            try {
                if (useStreaming) {
                    var6_7 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String text;
                            String json;
                            if (!line.startsWith("data: ") || (json = line.substring(6).trim()).isEmpty() || json.equals("[DONE]") || (text = this.extractTextFromJson(json)) == null || text.isEmpty()) continue;
                            onChunk.accept(text);
                        }
                        break block32;
                    }
                    catch (Throwable throwable) {
                        var6_7 = throwable;
                        throw throwable;
                    }
                }
                String response = this.readFullResponseWithRetry(conn);
                String text = this.extractTextFromJson(response);
                onChunk.accept(text);
            }
            catch (SocketException e) {
                System.out.println("Connection aborted by user");
            }
            finally {
                conn.disconnect();
            }
        }
    }

    public static CompletableFuture<Void> abortGenerationAsync() {
        return CompletableFuture.runAsync(() -> {
            try {
                KoboldAI.abortGeneration();
            }
            catch (IOException e) {
                System.err.println("Error aborting generation: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public static void abortGeneration() throws IOException {
        String abortUrl = (String)ArichatClassic.koboldUrl.get() + "/api/extra/abort";
        System.out.println("Sending abort request to: " + abortUrl);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(abortUrl).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int responseCode = conn.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                System.out.println("Generation aborted successfully");
            } else {
                System.err.println("Abort request failed. Response code: " + responseCode);
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public int countTokens(String prompt) {
        String tokenCountUrl = (String)ArichatClassic.koboldUrl.get() + "/api/extra/tokencount";
        try {
            HttpURLConnection conn = this.createConnection(tokenCountUrl, "POST", false);
            conn.setRequestProperty("Accept", "application/json");
            JsonObject request = new JsonObject();
            request.addProperty("prompt", prompt);
            try (OutputStream os = conn.getOutputStream();){
                os.write(request.toString().getBytes(StandardCharsets.UTF_8));
            }
            String response = this.readFullResponseWithRetry(conn);
            JsonObject jsonResponse = new JsonParser().parse(response).getAsJsonObject();
            if (jsonResponse.has("value")) {
                return jsonResponse.get("value").getAsInt();
            }
            System.err.println("Invalid token count response: missing 'value' field");
            return -1;
        }
        catch (Exception e) {
            System.err.println("Token count error: " + e.getMessage());
            e.printStackTrace();
            return -1;
        }
    }

    private String extractTextFromJson(String json) {
        try {
            JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
            return jsonObject.getAsJsonArray("choices").get(0).getAsJsonObject().get("text").getAsString();
        }
        catch (Exception e) {
            System.err.println("Failed to parse JSON: " + e.getMessage());
            return null;
        }
    }

    private HttpURLConnection createConnection(String url, String method, boolean isStream) throws IOException {
        System.out.println("Creating connection to: " + url);
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/json");
        if (isStream) {
            conn.setRequestProperty("Accept", "text/event-stream");
        }
        conn.setDoOutput(true);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(isStream ? 0 : 30000);
        return conn;
    }

    private String readFullResponseWithRetry(HttpURLConnection conn) throws IOException {
        int retries = 3;
        int delay = 2000;
        for (int i = 0; i < retries; ++i) {
            try {
                return this.readFullResponse(conn);
            }
            catch (SocketTimeoutException e) {
                if (i == retries - 1) {
                    throw e;
                }
                System.out.println("Timeout, retrying... (" + (i + 1) + "/" + retries + ")");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        return "";
    }

    private String readFullResponse(HttpURLConnection conn) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }

    @Override
    public void checkConnectionAsync(Consumer<Boolean> callback) {
        CompletableFuture.runAsync(() -> {
            try {
                String modelId;
                JsonObject jsonResponse;
                JsonArray dataArray;
                String result = this.getModels();
                if (!result.isEmpty() && (dataArray = (jsonResponse = new JsonParser().parse(result).getAsJsonObject()).getAsJsonArray("data")).size() > 0 && !(modelId = dataArray.get(0).getAsJsonObject().get("id").getAsString()).isEmpty()) {
                    ArichatClassic.model = modelId;
                    ArichatClassic.connected = true;
                    callback.accept(true);
                    return;
                }
                ArichatClassic.connected = false;
                callback.accept(false);
            }
            catch (Exception e) {
                ArichatClassic.connected = false;
                callback.accept(false);
            }
        });
    }

    @Override
    public JsonObject buildHeaders(String prompt, String userName) {
        return RequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, userName, (Boolean)ArichatClassic.streamResponse.get());
    }
}

