/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.engine.api.IModel;
import kiraririria.arichatclassic.engine.prompt.OpenRouterRequestBuilder;

public class OpenRouterModel
implements IModel {
    private static final String BASE_URL = "/api/v1";
    private static final int TIMEOUT = 30000;

    @Override
    public void generateTextStream(String prompt, JsonObject object, Consumer<String> onChunk) throws IOException {
        this.generateTextStream(object, onChunk, (Boolean)ArichatClassic.streamResponse.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextStream(JsonObject request, Consumer<String> onChunk, boolean useStreaming) throws IOException {
        HttpURLConnection conn = this.createConnection((String)ArichatClassic.openrouterUrl.get() + BASE_URL + "/chat/completions", "POST", useStreaming);
        try (OutputStream os = conn.getOutputStream();){
            os.write(request.toString().getBytes(StandardCharsets.UTF_8));
        }
        try {
            if (useStreaming) {
                this.processStreamingResponse(conn, onChunk);
            } else {
                this.processNonStreamingResponse(conn, onChunk);
            }
        }
        catch (SocketException e) {
            System.out.println("Connection aborted by user");
        }
        finally {
            conn.disconnect();
        }
    }

    @Override
    public JsonObject buildHeaders(String prompt, String userName) {
        return OpenRouterRequestBuilder.buildBaseRequest(prompt, ArichatClassic.settings, (Boolean)ArichatClassic.streamResponse.get(), userName);
    }

    private void processNonStreamingResponse(HttpURLConnection conn, Consumer<String> onChunk) throws IOException {
        String response = this.readFullResponseWithRetry(conn);
        String content = this.extractContentFromJson(response);
        if (content != null && !content.isEmpty()) {
            onChunk.accept(content);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processStreamingResponse(HttpURLConnection conn, Consumer<String> onChunk) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                String content;
                if (Thread.currentThread().isInterrupted()) return;
                if (!line.startsWith("data: ")) continue;
                String json = line.substring(6).trim();
                if (json.equals("[DONE]")) {
                    return;
                }
                if (json.isEmpty()) continue;
                try {
                    JsonObject choice;
                    JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
                    if (jsonObject.has("choices") && (choice = jsonObject.getAsJsonArray("choices").get(0).getAsJsonObject()).has("delta")) {
                        JsonObject delta = choice.getAsJsonObject("delta");
                        if (delta.has("reasoning")) {
                            // empty if block
                        }
                        if (!delta.has("content")) {
                            // empty if block
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println("Debug parsing error: " + e.getMessage());
                }
                if ((content = this.extractContentFromStreamingJson(json, onChunk)) == null || content.isEmpty()) continue;
                onChunk.accept(content);
            }
            return;
        }
    }

    private String extractContentFromStreamingJson(String json, Consumer<String> onChunk) {
        try {
            JsonArray choices;
            JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
            if (jsonObject.has("choices") && (choices = jsonObject.getAsJsonArray("choices")).size() > 0) {
                JsonObject choice = choices.get(0).getAsJsonObject();
                StringBuilder contentBuilder = new StringBuilder();
                if (choice.has("delta")) {
                    String regularContent;
                    String reasoning;
                    JsonObject delta = choice.getAsJsonObject("delta");
                    if (delta.has("reasoning") && !delta.get("reasoning").isJsonNull() && (reasoning = delta.get("reasoning").getAsString()) != null && !reasoning.isEmpty()) {
                        ArichatClassic.log("[Reasoning] " + reasoning);
                    }
                    if (delta.has("content") && !delta.get("content").isJsonNull() && (regularContent = delta.get("content").getAsString()) != null && !regularContent.isEmpty()) {
                        contentBuilder.append(regularContent);
                    }
                }
                return contentBuilder.length() > 0 ? contentBuilder.toString() : null;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse streaming JSON: " + e.getMessage());
            System.err.println("Problematic JSON: " + json);
        }
        return null;
    }

    private String extractContentFromJson(String json) {
        try {
            JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
            return jsonObject.getAsJsonArray("choices").get(0).getAsJsonObject().getAsJsonObject("message").get("content").getAsString();
        }
        catch (Exception e) {
            System.err.println("Failed to parse JSON: " + e.getMessage());
            return null;
        }
    }

    private HttpURLConnection createConnection(String url, String method, boolean isStream) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Authorization", "Bearer " + (String)ArichatClassic.openrouterKey.get());
        conn.setRequestProperty("HTTP-Referer", "arichat");
        conn.setRequestProperty("X-Title", "Arichat Classic");
        if (isStream) {
            conn.setRequestProperty("Accept", "text/event-stream");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Connection", "keep-alive");
        }
        conn.setDoOutput(true);
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(isStream ? 60000 : 30000);
        return conn;
    }

    private String readFullResponseWithRetry(HttpURLConnection conn) throws IOException {
        int retries = 3;
        int delay = 2000;
        for (int i = 0; i < retries; ++i) {
            try {
                return this.readFullResponse(conn);
            }
            catch (SocketTimeoutException e) {
                if (i == retries - 1) {
                    throw e;
                }
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        return "";
    }

    private String readFullResponse(HttpURLConnection conn) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }

    public static void abortGeneration() throws IOException {
        System.out.println("Abort generation not supported by OpenRouter");
    }

    public int countTokens(String prompt) {
        System.out.println("Token count endpoint not available for OpenRouter");
        return -1;
    }

    public void fetchModelsAsync(Consumer<List<String>> callback) {
        new Thread(() -> {
            try {
                ArrayList<String> models = new ArrayList<String>();
                HttpURLConnection connection = (HttpURLConnection)new URL((String)ArichatClassic.openrouterUrl.get() + BASE_URL + "/models").openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + (String)ArichatClassic.openrouterKey.get());
                connection.setRequestProperty("HTTP-Referer", "arichat");
                connection.setRequestProperty("X-Title", "Arichat");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonObject jsonResponse = new JsonParser().parse(response.toString()).getAsJsonObject();
                    JsonArray dataArray = jsonResponse.getAsJsonArray("data");
                    for (int i = 0; i < dataArray.size(); ++i) {
                        JsonObject model = dataArray.get(i).getAsJsonObject();
                        String modelId = model.get("id").getAsString();
                        models.add(modelId);
                    }
                }
                callback.accept(models);
            }
            catch (Exception e) {
                e.printStackTrace();
                callback.accept(new ArrayList());
            }
        }).start();
    }

    public String getModels() {
        List[] result = new List[]{new ArrayList()};
        this.fetchModelsAsync(models -> {
            result[0] = models;
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return String.join((CharSequence)",", result[0]);
    }

    public List<String> getAllModels() {
        List[] result = new List[]{new ArrayList()};
        this.fetchModelsAsync(models -> {
            result[0] = models;
        });
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result[0];
    }

    @Override
    public void checkConnectionAsync(Consumer<Boolean> callback) {
    }

    public void fetchModelsWithDetailsAsync(Consumer<List<ModelDetail>> callback) {
        new Thread(() -> {
            try {
                ArrayList<ModelDetail> models = new ArrayList<ModelDetail>();
                HttpURLConnection connection = (HttpURLConnection)new URL((String)ArichatClassic.openrouterUrl.get() + BASE_URL + "/models").openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Authorization", "Bearer " + (String)ArichatClassic.openrouterKey.get());
                connection.setRequestProperty("HTTP-Referer", "arichat");
                connection.setRequestProperty("X-Title", "Arichat");
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    JsonObject jsonResponse = new JsonParser().parse(response.toString()).getAsJsonObject();
                    JsonArray dataArray = jsonResponse.getAsJsonArray("data");
                    for (int i = 0; i < dataArray.size(); ++i) {
                        JsonObject model = dataArray.get(i).getAsJsonObject();
                        ModelDetail detail = new ModelDetail();
                        detail.id = model.get("id").getAsString();
                        if (model.has("pricing")) {
                            JsonObject pricing = model.getAsJsonObject("pricing");
                            if (pricing.has("prompt") && !pricing.get("prompt").isJsonNull()) {
                                detail.promptPrice = pricing.get("prompt").getAsDouble();
                            }
                            if (pricing.has("completion") && !pricing.get("completion").isJsonNull()) {
                                detail.completionPrice = pricing.get("completion").getAsDouble();
                            }
                        }
                        if (model.has("context_length") && !model.get("context_length").isJsonNull()) {
                            detail.contextLength = model.get("context_length").getAsInt();
                        }
                        models.add(detail);
                    }
                }
                callback.accept(models);
            }
            catch (Exception e) {
                e.printStackTrace();
                callback.accept(new ArrayList());
            }
        }).start();
    }

    public static class ModelDetail {
        public String id;
        public double promptPrice;
        public double completionPrice;
        public int contextLength;
    }
}

