/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.common.Emotion;
import kiraririria.arichatclassic.network.Dispatcher;
import kiraririria.arichatclassic.network.client.ClientHandlerUpdateDialogueMorph;
import kiraririria.arichatclassic.network.common.PacketTrigger;
import mchorse.mappet.api.dialogues.nodes.ArichatActionReactionNode;
import mchorse.mappet.api.dialogues.nodes.ICardHandler;
import mchorse.mappet.client.gui.GuiInteractionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EmoMacroPostProcessor {
    private static final Pattern JS_MACRO_PATTERN = Pattern.compile("\\{\\{emo:([^}]+)\\}\\}");

    public static String process(String text, EntityPlayer player) {
        if (text == null || text.isEmpty() || player == null) {
            return text;
        }
        Matcher matcher = JS_MACRO_PATTERN.matcher(text);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String emoValue = matcher.group(1);
            String replacement = "";
            if (player.func_130014_f_().field_72995_K && emoValue != null && !emoValue.trim().isEmpty()) {
                EmoMacroPostProcessor.executeTest(emoValue, player);
                replacement = "";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static void executeTest(String emo, EntityPlayer player) {
        Optional<Emotion> emotion = Emotion.getEmotionByName(ArichatClassic.lastemo, emo);
        if (emotion.isPresent()) {
            EmoMacroPostProcessor.executeExpression(player, emotion.get());
            ArichatClassic.log("Execute emotion: " + emo);
        } else {
            ArichatClassic.log("Error get emotion: " + emo);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void execute(String emo, EntityPlayer player) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiInteractionScreen) {
            ICardHandler node;
            GuiInteractionScreen gui = (GuiInteractionScreen)screen;
            if (gui.fragment.reaction.ai && (node = gui.fragment.reaction.node) instanceof ArichatActionReactionNode) {
                Optional<Emotion> emotion = Emotion.getEmotionByName(((ArichatActionReactionNode)node).emotions, emo);
                if (emotion.isPresent()) {
                    ArichatClassic.log("Execute emotion: " + emo);
                    EmoMacroPostProcessor.executeExpression(player, emotion.get());
                } else {
                    ArichatClassic.log("Error get emotion: " + emo);
                }
            }
        }
    }

    public static void executeExpression(EntityPlayer player, Emotion emotion) {
        if (player instanceof EntityPlayerSP) {
            ClientHandlerUpdateDialogueMorph.setMorph(emotion.morph);
        }
        if (emotion.trigger != null & !emotion.trigger.isEmpty()) {
            if (player.field_70170_p.field_72995_K) {
                Dispatcher.sendToServer(new PacketTrigger(emotion.trigger.serializeNBT(), player.func_145782_y()));
            } else {
                emotion.trigger.trigger((EntityLivingBase)player);
            }
        }
    }
}

