/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import kiraririria.arichatclassic.engine.InstructSettings;
import kiraririria.arichatclassic.engine.prompt.MacroContext;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;

public class InstructFormatter {
    public static String formatMessage(String name, String message, boolean isUser, boolean isNarrator, String forceAvatar, String name1, String name2, InstructSettings instruct) {
        String separator;
        boolean includeNames;
        if (instruct == null || instruct.input_sequence.isEmpty() && instruct.output_sequence.isEmpty() && instruct.system_sequence.isEmpty()) {
            return name + ": " + message;
        }
        boolean bl = includeNames = !isNarrator && instruct.names_behavior.equals("always");
        if (!isNarrator && instruct.names_behavior.equals("force") && name != null && !name.equals(name1)) {
            includeNames = true;
        }
        String prefix = InstructFormatter.getPrefix(instruct, isUser, isNarrator, false, false);
        String suffix = InstructFormatter.getSuffix(instruct, isUser, isNarrator);
        if (instruct.macro) {
            MacroContext context = new MacroContext(null, null, null);
            context.setVar("name1", name1);
            context.setVar("name2", name2);
            context.setVar("user", name1);
            context.setVar("char", name2);
            if (name != null) {
                context.setVar("name", name);
            }
            prefix = MacroProcessor.process(prefix, context);
            suffix = MacroProcessor.process(suffix, context);
        }
        if (suffix.isEmpty() && instruct.wrap) {
            suffix = "\n";
        }
        String string = separator = instruct.wrap ? "\n" : "";
        if (includeNames && name != null && !name.isEmpty()) {
            return prefix + separator + name + ": " + message + suffix;
        }
        return prefix + separator + message + suffix;
    }

    private static String getPrefix(InstructSettings instruct, boolean isUser, boolean isNarrator, boolean isFirst, boolean isLast) {
        if (isNarrator) {
            return instruct.system_same_as_user ? instruct.input_sequence : instruct.system_sequence;
        }
        if (isUser) {
            return instruct.input_sequence;
        }
        if (isFirst && !instruct.first_output_sequence.isEmpty()) {
            return instruct.first_output_sequence;
        }
        if (isLast && !instruct.last_output_sequence.isEmpty()) {
            return instruct.last_output_sequence;
        }
        return instruct.output_sequence;
    }

    private static String getSuffix(InstructSettings instruct, boolean isUser, boolean isNarrator) {
        if (isNarrator) {
            return instruct.system_same_as_user ? instruct.input_suffix : instruct.system_suffix;
        }
        if (isUser) {
            return instruct.input_suffix;
        }
        return instruct.output_suffix;
    }

    public static String substituteParams(String text, String name1, String name2) {
        if (text == null) {
            return "";
        }
        return text.replace("{{name1}}", name1).replace("{{name2}}", name2).replace("{{user}}", name1).replace("{{char}}", name2);
    }

    public static String formatSystemPrompt(String systemPrompt, String name1, String name2, InstructSettings instruct) {
        if (instruct == null || instruct.system_sequence.isEmpty()) {
            return systemPrompt;
        }
        String prefix = instruct.system_sequence;
        String suffix = instruct.system_suffix;
        if (instruct.macro) {
            MacroContext context = new MacroContext(null, null, null);
            context.setVar("name1", name1);
            context.setVar("name2", name2);
            context.setVar("user", name1);
            context.setVar("char", name2);
            prefix = MacroProcessor.process(prefix, context);
            suffix = MacroProcessor.process(suffix, context);
        }
        if (suffix.isEmpty() && instruct.wrap) {
            suffix = "\n";
        }
        String separator = instruct.wrap ? "\n" : "";
        return prefix + separator + systemPrompt + suffix;
    }
}

