/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.script.ScriptEngine;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.api.SummaryGenerator;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;
import kiraririria.arichatclassic.engine.prompt.MappetPrompt;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.utils.ScriptUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class MacroContext {
    public final Conversation conversation;
    public final EntityPlayer player;
    public final List<String> history;
    public final World world;
    public final int currentSwipeId;
    private final Map<String, String> valueCache = new HashMap<String, String>();
    private final Map<String, String> pickCache = new HashMap<String, String>();
    private final Map<String, String> localVars = new HashMap<String, String>();

    public MacroContext(Conversation conversation, EntityPlayer player, List<String> history, int currentSwipeId) {
        this.conversation = conversation;
        this.player = player;
        this.history = history;
        this.currentSwipeId = currentSwipeId;
        this.world = player != null ? player.field_70170_p : null;
    }

    public MacroContext(Conversation conversation, EntityPlayer player, List<String> history) {
        this(conversation, player, history, 0);
    }

    public String getValue(String macroName) {
        if (this.valueCache.containsKey(macroName)) {
            return this.valueCache.get(macroName);
        }
        String value = this.computeValue(macroName);
        this.valueCache.put(macroName, value);
        return value;
    }

    private String computeValue(String macroName) {
        if (macroName.equals("newline")) {
            return "\n";
        }
        if (macroName.equals("noop") || macroName.equals("trim")) {
            return "";
        }
        if (macroName.equals("pipe")) {
            return "";
        }
        if (this.conversation == null) {
            if (macroName.equals("char") || macroName.equals("user") || macroName.equals("description") || macroName.equals("personality") || macroName.equals("scenario") || macroName.equals("mesExamples") || macroName.equals("mesExamplesRaw") || macroName.equals("charPrompt") || macroName.equals("charInstruction") || macroName.equals("charDepthPrompt") || macroName.equals("version") || macroName.equals("systemPrompt") || macroName.equals("defaultSystemPrompt")) {
                return "";
            }
        } else {
            switch (macroName) {
                case "char": {
                    return this.conversation.characterCard.name;
                }
                case "user": {
                    return this.conversation.userName;
                }
                case "description": {
                    return this.conversation.characterCard.description;
                }
                case "personality": {
                    return this.conversation.characterCard.personality;
                }
                case "scenario": {
                    return "Scenario: " + this.conversation.characterCard.scenario;
                }
                case "mesExamples": {
                    return this.conversation.characterCard.mesExample;
                }
                case "mesExamplesRaw": {
                    return this.conversation.characterCard.mesExample;
                }
                case "charPrompt": {
                    return "";
                }
                case "charInstruction": {
                    return "";
                }
                case "charDepthPrompt": {
                    return "";
                }
                case "version": {
                    return "";
                }
                case "systemPrompt": {
                    return this.conversation.sysprompt != null ? this.conversation.sysprompt.content : "";
                }
                case "defaultSystemPrompt": {
                    return "";
                }
            }
        }
        if (macroName.equals("persona")) {
            if (this.player != null && ((Boolean)ArichatClassic.usePerson.get()).booleanValue() && this.conversation != null) {
                return "[" + MappetPrompt.buildPerson(this.player, this.conversation) + "]\n";
            }
            return "";
        }
        if (macroName.startsWith("mps:")) {
            String key = macroName.substring(4).trim();
            if (key.isEmpty()) {
                return "";
            }
            if (key.contains("{{")) {
                key = MacroProcessor.process(key, this);
            }
            if (this.player != null) {
                return MappetPrompt.getMappetState(this.player, key);
            }
            return "";
        }
        if (macroName.equals("summary")) {
            String summary;
            if (this.player != null && SummaryGenerator.shouldSummary(this.player) && !(summary = SummaryGenerator.getSummary(this.player)).isEmpty()) {
                return "[Summary: " + summary + "]\n";
            }
            return "";
        }
        if (this.world != null) {
            switch (macroName) {
                case "time": {
                    long worldTime = this.world.func_72820_D();
                    int hours = (int)((worldTime / 1000L + 6L) % 24L);
                    int minutes = (int)(60L * (worldTime % 1000L) / 1000L);
                    return String.format("%02d:%02d", hours, minutes);
                }
                case "date": {
                    long worldTime = this.world.func_72820_D();
                    long day = worldTime / 24000L;
                    return "Day " + day;
                }
                case "weekday": {
                    String[] weekdays = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
                    long currentDay = this.world.func_72820_D() / 24000L;
                    return weekdays[(int)(currentDay % 7L)];
                }
                case "isotime": {
                    SimpleDateFormat isoTime = new SimpleDateFormat("HH:mm:ss");
                    return isoTime.format(new Date());
                }
                case "isodate": {
                    SimpleDateFormat isoDate = new SimpleDateFormat("yyyy-MM-dd");
                    return isoDate.format(new Date());
                }
                case "idle_duration": {
                    return "0";
                }
            }
        }
        if (this.history != null && !this.history.isEmpty()) {
            switch (macroName) {
                case "lastMessage": {
                    return this.history.get(this.history.size() - 1);
                }
                case "lastUserMessage": {
                    for (int i = this.history.size() - 1; i >= 0; --i) {
                        if (i % 2 != 1) continue;
                        return this.history.get(i);
                    }
                    return "";
                }
                case "lastCharMessage": {
                    for (int i = this.history.size() - 1; i >= 0; --i) {
                        if (i % 2 != 0) continue;
                        return this.history.get(i);
                    }
                    return "";
                }
                case "lastMessageId": {
                    return String.valueOf(this.history.size() - 1);
                }
                case "firstIncludedMessageId": 
                case "firstDisplayedMessageId": {
                    return "0";
                }
                case "currentSwipeId": {
                    return this.currentSwipeId > 0 ? String.valueOf(this.currentSwipeId) : "";
                }
                case "lastSwipeId": {
                    return "";
                }
                case "history": {
                    return this.buildHistory();
                }
            }
        }
        switch (macroName) {
            case "group": 
            case "charIfNotGroup": 
            case "groupNotMuted": {
                return this.conversation != null ? this.conversation.characterCard.name : "";
            }
            case "notChar": {
                return this.conversation != null ? this.conversation.userName : "";
            }
            case "model": {
                return "";
            }
        }
        if (macroName.startsWith("getvar::")) {
            String varName = macroName.substring(8);
            return this.localVars.getOrDefault(varName, "");
        }
        if (macroName.startsWith("getglobalvar::")) {
            return "";
        }
        switch (macroName) {
            case "isMobile": {
                return "false";
            }
            case "maxPrompt": {
                return "4096";
            }
        }
        return "";
    }

    private String buildHistory() {
        if (this.history == null || this.history.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.history.size(); ++i) {
            String speaker = i % 2 == 0 ? (this.conversation != null ? this.conversation.characterCard.name : "Char") : (this.conversation != null ? this.conversation.userName : "User");
            sb.append(speaker).append(": ").append(this.history.get(i)).append("\n");
        }
        return sb.toString();
    }

    public String evaluateMacro(String fullMacro) {
        if (fullMacro.startsWith("{{") && fullMacro.endsWith("}}")) {
            String content = fullMacro.substring(2, fullMacro.length() - 2).trim();
            if (content.startsWith("roll:")) {
                return this.evaluateRoll(content.substring(5));
            }
            if (content.startsWith("random:")) {
                return this.evaluateRandom(content.substring(7));
            }
            if (content.startsWith("pick:")) {
                return this.evaluatePick(content.substring(5));
            }
            if (content.startsWith("sc:")) {
                return this.executeJs(content.substring(3));
            }
            if (content.startsWith("js:")) {
                return fullMacro;
            }
            if (content.startsWith("emo:")) {
                return fullMacro;
            }
            if (content.startsWith("time_UTC")) {
                return this.evaluateUTCTime(content.substring(8));
            }
            if (content.startsWith("reverse:")) {
                return new StringBuilder(content.substring(8)).reverse().toString();
            }
            if (content.startsWith("// ")) {
                return "";
            }
            if (content.startsWith("bias ") || content.startsWith("banned ")) {
                return "";
            }
            return this.getValue(content);
        }
        return fullMacro;
    }

    private String evaluateRoll(String formula) {
        try {
            if (formula.matches("\\d+d\\d+")) {
                String[] parts = formula.split("d");
                int diceCount = Integer.parseInt(parts[0]);
                int diceSides = Integer.parseInt(parts[1]);
                int total = 0;
                Random rand = new Random();
                for (int i = 0; i < diceCount; ++i) {
                    total += rand.nextInt(diceSides) + 1;
                }
                return String.valueOf(total);
            }
            return "0";
        }
        catch (Exception e) {
            return "0";
        }
    }

    private String evaluateRandom(String items) {
        try {
            String[] choices = items.split(",");
            if (choices.length == 0) {
                return "";
            }
            Random rand = new Random();
            return choices[rand.nextInt(choices.length)].trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    private String evaluatePick(String items) {
        try {
            String[] choices = items.split(",");
            if (choices.length == 0) {
                return "";
            }
            String key = "pick:" + items;
            if (!this.pickCache.containsKey(key)) {
                Random rand = new Random();
                this.pickCache.put(key, choices[rand.nextInt(choices.length)].trim());
            }
            return this.pickCache.get(key);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String executeJs(String code) {
        try {
            if (this.player == null) {
                return "";
            }
            DataContext context = new DataContext((Entity)this.player);
            if (code.endsWith(".js") && code.split(" ").length == 1) {
                Object result = Mappet.scripts.execute(code, "", context);
                return result != null ? result.toString() : "";
            }
            Object result = Mappet.scripts.eval(ScriptUtils.sanitize((ScriptEngine)ScriptUtils.getEngineByExtension((String)"js")), code, context);
            return result != null ? result.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    private String evaluateUTCTime(String offsetStr) {
        try {
            int offset = Integer.parseInt(offsetStr);
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            cal.add(10, offset);
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.format(cal.getTime());
        }
        catch (Exception e) {
            return "00:00:00";
        }
    }

    public void clearCache() {
        this.valueCache.clear();
    }

    public void setVar(String name, String value) {
        this.localVars.put(name, value);
    }

    public String getVar(String name) {
        return this.localVars.getOrDefault(name, "");
    }
}

