/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kiraririria.arichatclassic.engine.prompt.MacroContext;

public class MacroProcessor {
    private static final Pattern MACRO_PATTERN = Pattern.compile("\\{\\{[^}]+\\}\\}");
    private static final int MAX_ITERATIONS = 5;

    public static String process(String template, MacroContext context) {
        if (template == null || template.isEmpty()) {
            return template;
        }
        String result = template;
        for (int iterations = 0; iterations < 5 && MacroProcessor.containsMacros(result); ++iterations) {
            result = MacroProcessor.replaceMacros(result, context);
        }
        return result;
    }

    private static boolean containsMacros(String text) {
        return text.contains("{{");
    }

    private static String replaceMacros(String input, MacroContext context) {
        if (!MacroProcessor.containsMacros(input)) {
            return input;
        }
        Matcher matcher = MACRO_PATTERN.matcher(input);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String macro = matcher.group(0);
            String replacement = context.evaluateMacro(macro);
            matcher.appendReplacement(output, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(output);
        return output.toString();
    }

    public static String processBasic(String text, String charName, String userName) {
        if (text == null) {
            return "";
        }
        String result = text;
        if (charName != null) {
            result = result.replace("{{char}}", charName);
        }
        if (userName != null) {
            result = result.replace("{{user}}", userName);
        }
        return result;
    }
}

