/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.EmotionPrompt;
import kiraririria.arichatclassic.engine.prompt.MacroContext;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;
import mchorse.mappet.api.states.States;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.client.gui.GuiInteractionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MappetPrompt {
    public static String buildPerson(EntityPlayer player, Conversation conversation) {
        Character c = Character.get(player);
        if (c == null) {
            return "";
        }
        States states = c.getStates();
        if (states == null) {
            return "";
        }
        String person = states.getString("Person");
        if (person.isEmpty()) {
            return "";
        }
        MacroContext context = new MacroContext(conversation, player, null);
        person = MacroProcessor.process(person, context);
        Pattern pattern = Pattern.compile("\\{\\{(.+?)\\}\\}");
        Matcher matcher = pattern.matcher(person);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement;
            String placeholder = matcher.group(1).trim();
            if (states.values.containsKey(placeholder)) {
                Object value = states.values.get(placeholder);
                replacement = value.toString();
            } else {
                replacement = "?";
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        String rs = result.toString();
        if (rs.isEmpty()) {
            return MappetPrompt.getLastPerson();
        }
        MappetPrompt.saveLastPerson(rs);
        return rs;
    }

    public static String getMappetState(EntityPlayer player, String key) {
        if (player == null || key == null || key.isEmpty()) {
            return "";
        }
        Character c = Character.get(player);
        if (c == null) {
            return "";
        }
        States states = c.getStates();
        if (states == null) {
            return "";
        }
        if (states.values.containsKey(key)) {
            Object value = states.values.get(key);
            return value != null ? value.toString() : "";
        }
        return "";
    }

    @SideOnly(value=Side.CLIENT)
    public static void saveLastPerson(String person) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiInteractionScreen) {
            GuiInteractionScreen dialogue = (GuiInteractionScreen)screen;
            dialogue.lastPerson = person;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String getLastPerson() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiInteractionScreen) {
            GuiInteractionScreen dialogue = (GuiInteractionScreen)screen;
            return dialogue.lastPerson;
        }
        return "";
    }

    public static String buildEmotionPrompt(String message, List<String> availableOptions, EmotionPrompt emotionPrompt) {
        StringJoiner optionsJoiner = new StringJoiner("\", \"", "\"", "\"");
        for (String option : availableOptions) {
            optionsJoiner.add(option);
        }
        String prompt = emotionPrompt.simple;
        prompt = prompt.replace("{{labels}}", optionsJoiner.toString());
        prompt = prompt.replace("{{message}}", message);
        return prompt;
    }

    public static String buildActionPrompt(String message, Map<String, String> availableOptions, Conversation conversation, EmotionPrompt emotionPrompt) {
        StringJoiner optionsJoiner = new StringJoiner("\n");
        for (Map.Entry<String, String> entry : availableOptions.entrySet()) {
            String processedDescription = MappetPrompt.replacePlaceholders(entry.getValue(), conversation);
            optionsJoiner.add("- " + entry.getKey() + ": " + processedDescription);
        }
        String prompt = emotionPrompt.complex;
        prompt = prompt.replace("{{labels}}", optionsJoiner.toString());
        prompt = prompt.replace("{{message}}", message);
        prompt = MappetPrompt.replacePlaceholders(prompt, conversation);
        return prompt;
    }

    private static String replacePlaceholders(String text, Conversation conversation) {
        if (text == null) {
            return "";
        }
        text = text.replace("{{user}}", conversation.userName != null ? conversation.userName : "Player");
        if (conversation.characterCard != null) {
            text = text.replace("{{char}}", conversation.characterCard.name);
        }
        return text;
    }
}

