/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.engine.GenerationSettings;

public class OpenRouterRequestBuilder {
    public static JsonObject buildBaseRequest(String prompt, GenerationSettings settings, boolean streaming, String username) {
        JsonObject request = new JsonObject();
        request.addProperty("model", ArichatClassic.openrouterModel.get());
        JsonArray messages = OpenRouterRequestBuilder.parseLegacyPromptToMessages(prompt, username);
        request.add("messages", (JsonElement)messages);
        request.addProperty("max_tokens", (Number)1000);
        request.addProperty("temperature", (Number)settings.temp);
        request.addProperty("top_p", (Number)settings.top_p);
        request.addProperty("top_a", (Number)settings.top_a);
        request.addProperty("frequency_penalty", (Number)settings.freq_pen);
        request.addProperty("presence_penalty", (Number)settings.presence_pen);
        request.addProperty("repetition_penalty", (Number)settings.rep_pen);
        request.addProperty("stream", Boolean.valueOf(streaming));
        if (((Boolean)ArichatClassic.useReasoning.get()).booleanValue()) {
            request.addProperty("include_reasoning", Boolean.valueOf(true));
        }
        request.addProperty("min_p", (Number)settings.min_p);
        request.addProperty("route", "fallback");
        JsonArray stopSequences = new JsonArray();
        for (String stop : settings.stopping_strings) {
            if (stop.contains("reasoning") || stop.contains("Reasoning")) continue;
            stopSequences.add(stop);
        }
        stopSequences.add("\n" + username + ":");
        request.add("stop", (JsonElement)stopSequences);
        return request;
    }

    public static JsonObject buildBaseRequest(String prompt, GenerationSettings settings, boolean streaming) {
        JsonObject request = new JsonObject();
        request.addProperty("model", ArichatClassic.openrouterModel.get());
        JsonArray messages = OpenRouterRequestBuilder.parseLegacyPromptToMessages(prompt, null);
        request.add("messages", (JsonElement)messages);
        request.addProperty("max_tokens", (Number)1000);
        request.addProperty("temperature", (Number)settings.temp);
        request.addProperty("top_p", (Number)settings.top_p);
        request.addProperty("top_a", (Number)settings.top_a);
        request.addProperty("frequency_penalty", (Number)settings.freq_pen);
        request.addProperty("presence_penalty", (Number)settings.presence_pen);
        request.addProperty("repetition_penalty", (Number)settings.rep_pen);
        request.addProperty("stream", Boolean.valueOf(streaming));
        request.addProperty("include_reasoning", (Boolean)ArichatClassic.useReasoning.get());
        if (!((Boolean)ArichatClassic.useReasoning.get()).booleanValue()) {
            JsonObject re = new JsonObject();
            re.addProperty("effort", "none");
            request.add("reasoning", (JsonElement)re);
        }
        request.addProperty("min_p", (Number)settings.min_p);
        request.addProperty("route", "fallback");
        JsonArray stopSequences = new JsonArray();
        for (String stop : settings.stopping_strings) {
            if (stop.contains("reasoning") || stop.contains("Reasoning")) continue;
            stopSequences.add(stop);
        }
        request.add("stop", (JsonElement)stopSequences);
        return request;
    }

    private static JsonArray parseLegacyPromptToMessages(String fullPrompt, String username) {
        JsonArray messages = new JsonArray();
        String[] parts = fullPrompt.split("\\*\\*\\*\\n");
        String charName = OpenRouterRequestBuilder.extractCharName(parts[0]);
        StringBuilder systemBuilder = new StringBuilder();
        if (parts.length >= 1) {
            systemBuilder.append(parts[0].trim());
        }
        if (parts.length > 1) {
            systemBuilder.append("\n***\n").append(parts[1].trim());
        }
        if (parts.length > 3) {
            if (!parts[parts.length - 1].isEmpty()) {
                String lastText = parts[parts.length - 1];
                int lastNewLine = lastText.lastIndexOf("\n");
                String string = parts[parts.length - 1] = lastNewLine != -1 ? lastText.substring(0, lastNewLine) : "";
            }
            if (!parts[parts.length - 1].isEmpty()) {
                systemBuilder.append("\n***\n").append(parts[parts.length - 1].trim());
            }
        }
        if (systemBuilder.length() > 0) {
            JsonObject systemMessage = new JsonObject();
            systemMessage.addProperty("role", "system");
            systemMessage.addProperty("content", systemBuilder.toString());
            messages.add((JsonElement)systemMessage);
        }
        if (parts.length > 2) {
            String dialoguePart = parts[2].trim();
            OpenRouterRequestBuilder.parseDialogueHistory(dialoguePart, messages, charName, username);
        }
        return messages;
    }

    private static void parseDialogueHistory(String dialogue, JsonArray messages, String charName, String username) {
        String[] lines;
        for (String line : lines = dialogue.split("\n")) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) continue;
            int colonIndex = trimmedLine.indexOf(58);
            if (colonIndex == -1) {
                if (messages.size() <= 0) continue;
                JsonObject lastMessage = messages.get(messages.size() - 1).getAsJsonObject();
                String existingContent = lastMessage.get("content").getAsString();
                lastMessage.addProperty("content", existingContent + "\n" + trimmedLine);
                continue;
            }
            String speaker = trimmedLine.substring(0, colonIndex).trim();
            String content = trimmedLine.substring(colonIndex + 1).trim();
            if (content.isEmpty()) continue;
            String role = null;
            if (speaker.equals(charName)) {
                role = "assistant";
            } else if (username != null && speaker.equals(username)) {
                role = "user";
            }
            if (role != null) {
                JsonObject message = new JsonObject();
                message.addProperty("role", role);
                message.addProperty("content", content);
                messages.add((JsonElement)message);
                continue;
            }
            if (messages.size() <= 0) continue;
            JsonObject lastMessage = messages.get(messages.size() - 1).getAsJsonObject();
            String existingContent = lastMessage.get("content").getAsString();
            lastMessage.addProperty("content", existingContent + "\n" + trimmedLine);
        }
    }

    private static String extractCharName(String text) {
        Pattern pattern = Pattern.compile("Write\\s+([^']+)'s\\s+next\\s+reply");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "Character";
    }

    public static JsonObject buildExpressionRequest(String prompt, GenerationSettings settings, String username) {
        JsonObject request = OpenRouterRequestBuilder.buildEBaseRequest(prompt, settings, true, username);
        request.addProperty("temperature", (Number)0.1);
        return request;
    }

    public static JsonObject buildEBaseRequest(String prompt, GenerationSettings settings, boolean streaming, String username) {
        JsonObject request = new JsonObject();
        request.addProperty("model", ArichatClassic.openrouterModel.get());
        JsonArray messages = new JsonArray();
        JsonObject systemMessage = new JsonObject();
        systemMessage.addProperty("role", "system");
        systemMessage.addProperty("content", prompt);
        messages.add((JsonElement)systemMessage);
        request.add("messages", (JsonElement)messages);
        request.addProperty("max_tokens", (Number)1000);
        request.addProperty("temperature", (Number)settings.temp);
        request.addProperty("top_p", (Number)settings.top_p);
        request.addProperty("top_a", (Number)settings.top_a);
        request.addProperty("frequency_penalty", (Number)settings.freq_pen);
        request.addProperty("presence_penalty", (Number)settings.presence_pen);
        request.addProperty("repetition_penalty", (Number)settings.rep_pen);
        request.addProperty("stream", Boolean.valueOf(streaming));
        request.addProperty("include_reasoning", (Boolean)ArichatClassic.useReasoning.get());
        request.addProperty("min_p", (Number)settings.min_p);
        request.addProperty("route", "fallback");
        JsonArray stopSequences = new JsonArray();
        for (String stop : settings.stopping_strings) {
            if (stop.contains("reasoning") || stop.contains("Reasoning")) continue;
            stopSequences.add(stop);
        }
        stopSequences.add("\n" + username + ":");
        request.add("stop", (JsonElement)stopSequences);
        return request;
    }
}

