/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import java.util.List;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.common.Emotion;
import kiraririria.arichatclassic.engine.InstructSettings;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.EmotionPrompt;
import kiraririria.arichatclassic.engine.prompt.InstructFormatter;
import kiraririria.arichatclassic.engine.prompt.MacroContext;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;
import kiraririria.arichatclassic.engine.prompt.MappetPrompt;
import net.minecraft.entity.player.EntityPlayer;

public class PromptBuilder {
    private static final String DEFAULT_TEMPLATE = "{{systemPrompt}}\n{{description}}{{personality}}\n{{scenario}}\n{{persona}}{{summary}}***\n{{mesExamples}}";

    public static String buildPrompt(Conversation conversation, EntityPlayer player) {
        return PromptBuilder.buildPrompt(conversation, player, ArichatClassic.instructSettings);
    }

    public static String buildPrompt(Conversation conversation, EntityPlayer player, InstructSettings instruct) {
        MacroContext context = new MacroContext(conversation, player, null);
        String template = DEFAULT_TEMPLATE;
        if (conversation != null && conversation.sysprompt != null && conversation.sysprompt.content.contains("{{patern}}")) {
            template = conversation.sysprompt.content;
            template = template.replace("{{patern}}", "");
        }
        String result = MacroProcessor.process(template, context);
        if (instruct != null && !instruct.system_sequence.isEmpty() && conversation != null) {
            result = InstructFormatter.formatSystemPrompt(result, conversation.userName, conversation.characterCard.name, instruct);
        }
        return result;
    }

    public static String buildReactionPrompt(List<Emotion> emotions, Conversation conversation, String lastMessage, boolean complex, EmotionPrompt emotionPrompt) {
        String prompt = complex ? MappetPrompt.buildActionPrompt(lastMessage, Emotion.getEmotionMap(emotions), conversation, emotionPrompt) : MappetPrompt.buildEmotionPrompt(lastMessage, Emotion.getUniqueEmotionNames(emotions), emotionPrompt);
        if (conversation != null) {
            MacroContext context = new MacroContext(conversation, null, null);
            prompt = MacroProcessor.process(prompt, context);
        }
        return prompt;
    }
}

