/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.engine.prompt;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.engine.GenerationSettings;

public class RequestBuilder {
    public static JsonObject buildExpressionRequest(String prompt, GenerationSettings settings, String username) {
        JsonObject request = new JsonObject();
        request.addProperty("prompt", prompt);
        request.addProperty("max_new_tokens", (Number)settings.genamt);
        request.addProperty("max_tokens", (Number)settings.genamt);
        request.addProperty("temperature", (Number)settings.temp);
        request.addProperty("top_p", (Number)settings.top_p);
        request.addProperty("typical_p", (Number)settings.typical_p);
        request.addProperty("typical", (Number)1);
        request.addProperty("min_p", (Number)settings.min_p);
        request.addProperty("repetition_penalty", (Number)settings.rep_pen);
        request.addProperty("frequency_penalty", (Number)settings.freq_pen);
        request.addProperty("presence_penalty", (Number)settings.presence_pen);
        request.addProperty("top_k", (Number)settings.top_k);
        request.addProperty("skew", (Number)settings.skew);
        request.addProperty("min_tokens", (Number)0);
        request.addProperty("add_bos_token", Boolean.valueOf(settings.add_bos_token));
        request.addProperty("smoothing_factor", (Number)settings.smoothing_factor);
        request.addProperty("smoothing_curve", (Number)settings.smoothing_curve);
        request.addProperty("dry_allowed_length", (Number)settings.dry_allowed_length);
        request.addProperty("dry_multiplier", (Number)settings.dry_multiplier);
        request.addProperty("dry_base", (Number)settings.dry_base);
        request.addProperty("dry_sequence_breakers", settings.dry_sequence_breakers);
        request.addProperty("dry_penalty_last_n", (Number)settings.dry_penalty_last_n);
        request.addProperty("max_tokens_second", (Number)0);
        JsonArray stoppingStrings = new JsonArray();
        for (String stop : settings.stopping_strings) {
            stoppingStrings.add(stop);
        }
        request.add("stopping_strings", (JsonElement)stoppingStrings);
        request.add("stop", (JsonElement)stoppingStrings);
        request.addProperty("truncation_length", (Number)settings.max_length);
        request.addProperty("ban_eos_token", Boolean.valueOf(false));
        request.addProperty("skip_special_tokens", Boolean.valueOf(settings.skip_special_tokens));
        request.addProperty("include_reasoning", Boolean.valueOf(true));
        request.addProperty("top_a", (Number)settings.top_a);
        request.addProperty("tfs", (Number)settings.tfs);
        request.addProperty("mirostat_mode", (Number)settings.mirostat_mode);
        request.addProperty("mirostat_tau", (Number)settings.mirostat_tau);
        request.addProperty("mirostat_eta", (Number)settings.mirostat_eta);
        request.addProperty("custom_token_bans", settings.banned_tokens);
        JsonArray bannedStrings = new JsonArray();
        request.add("banned_strings", (JsonElement)bannedStrings);
        JsonArray samplerOrder = new JsonArray();
        for (int num : settings.sampler_order) {
            samplerOrder.add((Number)num);
        }
        request.add("sampler_order", (JsonElement)samplerOrder);
        request.addProperty("xtc_threshold", (Number)settings.xtc_threshold);
        request.addProperty("xtc_probability", (Number)settings.xtc_probability);
        request.addProperty("nsigma", (Number)settings.nsigma);
        request.addProperty("min_keep", (Number)settings.min_keep);
        request.addProperty("grammar", settings.grammar_string);
        request.addProperty("trim_stop", Boolean.valueOf(true));
        request.addProperty("rep_pen", (Number)settings.rep_pen);
        request.addProperty("rep_pen_range", (Number)settings.rep_pen_range);
        request.addProperty("repetition_penalty_range", (Number)settings.rep_pen_range);
        request.addProperty("guidance_scale", (Number)settings.guidance_scale);
        request.addProperty("negative_prompt", settings.negative_prompt);
        request.addProperty("grammar_string", settings.grammar_string);
        request.addProperty("repeat_penalty", (Number)settings.rep_pen);
        request.addProperty("repeat_last_n", (Number)0);
        request.addProperty("n_predict", (Number)settings.genamt);
        request.addProperty("num_predict", (Number)settings.genamt);
        request.addProperty("num_ctx", (Number)settings.max_length);
        request.addProperty("mirostat", (Number)settings.mirostat_mode);
        request.addProperty("ignore_eos", Boolean.valueOf(settings.ignore_eos_token));
        request.addProperty("rep_pen_slope", (Number)settings.rep_pen_slope);
        return request;
    }

    public static JsonObject buildBaseRequest(String prompt, GenerationSettings settings, String username, boolean streaming) {
        JsonObject o = RequestBuilder.buildBaseRequest(prompt, settings, streaming);
        JsonArray stoppingStrings = new JsonArray();
        for (String stop : settings.stopping_strings) {
            stoppingStrings.add(stop);
        }
        if (ArichatClassic.instructSettings != null && !ArichatClassic.instructSettings.stop_sequence.isEmpty()) {
            stoppingStrings.add(ArichatClassic.instructSettings.stop_sequence);
        }
        stoppingStrings.add("\n*\n");
        stoppingStrings.add("\nNotes: ");
        stoppingStrings.add("\n\n");
        stoppingStrings.add("\n" + username + ":");
        o.add("stopping_strings", (JsonElement)stoppingStrings);
        o.add("stop", (JsonElement)stoppingStrings);
        return o;
    }

    public static JsonObject buildBaseRequest(String prompt, GenerationSettings settings, boolean streaming) {
        JsonObject request = new JsonObject();
        request.addProperty("prompt", prompt);
        request.addProperty("max_new_tokens", (Number)settings.genamt);
        request.addProperty("max_tokens", (Number)settings.genamt);
        request.addProperty("temperature", (Number)settings.temp);
        request.addProperty("top_p", (Number)settings.top_p);
        request.addProperty("typical_p", (Number)settings.typical_p);
        request.addProperty("typical", (Number)1);
        request.addProperty("min_p", (Number)settings.min_p);
        request.addProperty("repetition_penalty", (Number)settings.rep_pen);
        request.addProperty("frequency_penalty", (Number)settings.freq_pen);
        request.addProperty("presence_penalty", (Number)settings.presence_pen);
        request.addProperty("top_k", (Number)settings.top_k);
        request.addProperty("skew", (Number)settings.skew);
        request.addProperty("min_tokens", (Number)0);
        request.addProperty("add_bos_token", Boolean.valueOf(settings.add_bos_token));
        request.addProperty("smoothing_factor", (Number)settings.smoothing_factor);
        request.addProperty("smoothing_curve", (Number)settings.smoothing_curve);
        request.addProperty("dry_allowed_length", (Number)settings.dry_allowed_length);
        request.addProperty("dry_multiplier", (Number)settings.dry_multiplier);
        request.addProperty("dry_base", (Number)settings.dry_base);
        request.addProperty("dry_sequence_breakers", settings.dry_sequence_breakers);
        request.addProperty("dry_penalty_last_n", (Number)settings.dry_penalty_last_n);
        request.addProperty("max_tokens_second", (Number)0);
        JsonArray stoppingStrings = new JsonArray();
        for (String stop : settings.stopping_strings) {
            stoppingStrings.add(stop);
        }
        request.add("stopping_strings", (JsonElement)stoppingStrings);
        request.add("stop", (JsonElement)stoppingStrings);
        request.addProperty("truncation_length", (Number)settings.max_length);
        request.addProperty("ban_eos_token", Boolean.valueOf(false));
        request.addProperty("skip_special_tokens", Boolean.valueOf(settings.skip_special_tokens));
        request.addProperty("include_reasoning", Boolean.valueOf(true));
        request.addProperty("top_a", (Number)settings.top_a);
        request.addProperty("tfs", (Number)settings.tfs);
        request.addProperty("mirostat_mode", (Number)settings.mirostat_mode);
        request.addProperty("mirostat_tau", (Number)settings.mirostat_tau);
        request.addProperty("mirostat_eta", (Number)settings.mirostat_eta);
        request.addProperty("custom_token_bans", settings.banned_tokens);
        JsonArray bannedStrings = new JsonArray();
        request.add("banned_strings", (JsonElement)bannedStrings);
        JsonArray samplerOrder = new JsonArray();
        for (int num : settings.sampler_order) {
            samplerOrder.add((Number)num);
        }
        request.add("sampler_order", (JsonElement)samplerOrder);
        request.addProperty("xtc_threshold", (Number)settings.xtc_threshold);
        request.addProperty("xtc_probability", (Number)settings.xtc_probability);
        request.addProperty("nsigma", (Number)settings.nsigma);
        request.addProperty("min_keep", (Number)settings.min_keep);
        request.addProperty("grammar", settings.grammar_string);
        request.addProperty("trim_stop", Boolean.valueOf(true));
        request.addProperty("rep_pen", (Number)settings.rep_pen);
        request.addProperty("rep_pen_range", (Number)settings.rep_pen_range);
        request.addProperty("repetition_penalty_range", (Number)settings.rep_pen_range);
        request.addProperty("guidance_scale", (Number)settings.guidance_scale);
        request.addProperty("negative_prompt", settings.negative_prompt);
        request.addProperty("grammar_string", settings.grammar_string);
        request.addProperty("repeat_penalty", (Number)settings.rep_pen);
        request.addProperty("repeat_last_n", (Number)0);
        request.addProperty("n_predict", (Number)settings.genamt);
        request.addProperty("num_predict", (Number)settings.genamt);
        request.addProperty("num_ctx", (Number)settings.max_length);
        request.addProperty("mirostat", (Number)settings.mirostat_mode);
        request.addProperty("ignore_eos", Boolean.valueOf(settings.ignore_eos_token));
        request.addProperty("rep_pen_slope", (Number)settings.rep_pen_slope);
        request.addProperty("stream", Boolean.valueOf(streaming));
        return request;
    }
}

