/*
 * Decompiled with CFR 0.152.
 */
package kiraririria.arichatclassic.utils;

public class EmojiUtil {
    public static String removeEmojis(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        StringBuilder cleaned = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isHighSurrogate(c) && i + 1 < length && Character.isLowSurrogate(text.charAt(i + 1))) {
                ++i;
                continue;
            }
            int codePoint = text.codePointAt(i);
            if (EmojiUtil.isEmoji(codePoint)) {
                i += Character.charCount(codePoint) - 1;
                continue;
            }
            cleaned.append(c);
        }
        return cleaned.toString();
    }

    private static boolean isEmoji(int codePoint) {
        return codePoint >= 128512 && codePoint <= 128591 || codePoint >= 127744 && codePoint <= 128511 || codePoint >= 128640 && codePoint <= 128767 || codePoint >= 9728 && codePoint <= 9983 || codePoint >= 9984 && codePoint <= 10175 || codePoint >= 65024 && codePoint <= 65039 || codePoint >= 129280 && codePoint <= 129535 || codePoint >= 127462 && codePoint <= 127487;
    }

    public static String removeEmojisWithSpaceCleanup(String text) {
        String cleaned = EmojiUtil.removeEmojis(text);
        return cleaned != null ? cleaned.replaceAll("\\s{2,}", " ").trim() : null;
    }
}

