/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.dialogues;

import java.util.UUID;
import mchorse.mappet.api.dialogues.nodes.ArichatReactionNode;
import mchorse.mappet.api.dialogues.nodes.ICardHandler;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class DialogueFragment
implements INBTSerializable<NBTTagCompound> {
    public String text = "";
    public int color = 0xFFFFFF;
    public boolean ai = false;
    public UUID dialogueIDAI = null;
    public String ltPrompt = "";
    public ICardHandler node;
    public String charName = "";
    public String activeSummary = "";
    public String dialogueID = "";

    public static String process(String text) {
        return TextUtils.processColoredText((String)text.replace("\\n", "\n"));
    }

    public String getProcessedText() {
        return DialogueFragment.process(this.text);
    }

    public DialogueFragment copy() {
        DialogueFragment fragment = new DialogueFragment();
        fragment.text = this.text;
        fragment.color = this.color;
        fragment.ai = this.ai;
        fragment.dialogueIDAI = this.dialogueIDAI;
        fragment.dialogueID = this.dialogueID;
        fragment.node = this.node;
        fragment.charName = this.charName;
        fragment.activeSummary = this.activeSummary;
        fragment.ltPrompt = this.ltPrompt;
        return fragment;
    }

    public DialogueFragment process(DataContext context) {
        this.text = context.process(this.text);
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Text", this.text);
        tag.func_74768_a("Color", this.color);
        tag.func_74757_a("Ai", this.ai);
        if (this.dialogueIDAI != null) {
            tag.func_186854_a("dialogueIDAI", this.dialogueIDAI);
        }
        tag.func_74778_a("DialogueID", this.dialogueID);
        if (this.node != null) {
            tag.func_74782_a("Node", this.node.serializeNBT());
        }
        if (!this.charName.isEmpty()) {
            tag.func_74778_a("CharName", this.charName);
        }
        if (!this.activeSummary.isEmpty()) {
            tag.func_74778_a("activeSummary", this.activeSummary);
        }
        if (!this.ltPrompt.isEmpty()) {
            tag.func_74778_a("ltPrompt", this.ltPrompt);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Text")) {
            this.text = tag.func_74779_i("Text");
        }
        if (tag.func_74764_b("Color")) {
            this.color = tag.func_74762_e("Color");
        }
        if (tag.func_74764_b("Ai")) {
            this.ai = tag.func_74767_n("Ai");
        }
        if (tag.func_186855_b("dialogueIDAI")) {
            this.dialogueIDAI = tag.func_186857_a("dialogueIDAI");
        }
        if (tag.func_74764_b("DialogueID")) {
            this.dialogueID = tag.func_74779_i("DialogueID");
        }
        if (tag.func_74764_b("Node")) {
            this.node = new ArichatReactionNode();
            this.node.deserializeNBT(tag.func_74775_l("Node"));
        }
        if (tag.func_74764_b("CharName")) {
            this.charName = tag.func_74779_i("CharName");
        }
        if (tag.func_74764_b("activeSummary")) {
            this.activeSummary = tag.func_74779_i("activeSummary");
        }
        if (tag.func_74764_b("ltPrompt")) {
            this.ltPrompt = tag.func_74779_i("ltPrompt");
        }
    }
}

