/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.dialogues;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.api.DialogueGenerator;
import kiraririria.arichatclassic.api.SummaryGenerator;
import kiraririria.arichatclassic.engine.CharacterCard;
import kiraririria.arichatclassic.engine.prompt.Conversation;
import kiraririria.arichatclassic.engine.prompt.MacroContext;
import kiraririria.arichatclassic.engine.prompt.MacroProcessor;
import kiraririria.arichatclassic.engine.prompt.Sysprompt;
import kiraririria.arichatclassic.network.Dispatcher;
import kiraririria.arichatclassic.network.common.PacketDialogueHistory;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.dialogues.Dialogue;
import mchorse.mappet.api.dialogues.DialogueContext;
import mchorse.mappet.api.dialogues.DialogueFragment;
import mchorse.mappet.api.dialogues.nodes.ArichatFirstReactionNode;
import mchorse.mappet.api.dialogues.nodes.ArichatPromptReactionNode;
import mchorse.mappet.api.dialogues.nodes.ArichatReactionNode;
import mchorse.mappet.api.dialogues.nodes.HistoryNode;
import mchorse.mappet.api.dialogues.nodes.ICardHandler;
import mchorse.mappet.api.dialogues.nodes.ReactionNode;
import mchorse.mappet.api.events.EventContext;
import mchorse.mappet.api.events.nodes.EventBaseNode;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.chains.QuestInfo;
import mchorse.mappet.api.quests.chains.QuestStatus;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.factory.IFactory;
import mchorse.mappet.api.utils.manager.BaseManager;
import mchorse.mappet.api.utils.nodes.Node;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.network.common.dialogue.PacketDialogueFragment;
import mchorse.mappet.utils.WorldUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DialogueManager
extends BaseManager<Dialogue> {
    public DialogueManager(File folder) {
        super(folder);
    }

    protected Dialogue createData(String id, NBTTagCompound tag) {
        Dialogue dialogue = new Dialogue((IFactory<EventBaseNode>)CommonProxy.getDialogues());
        if (tag != null) {
            dialogue.deserializeNBT(tag);
        }
        return dialogue;
    }

    public void open(EntityPlayerMP player, Dialogue dialogue, DialogueContext context) {
        Character character = Character.get((EntityPlayer)player);
        if (character != null) {
            character.setDialogue(dialogue, context);
            Mappet.dialogues.execute(dialogue, context);
            if (context.reactionNode != null) {
                this.handleContext(player, dialogue, context, null);
            }
        }
    }

    public void handleContext(EntityPlayerMP player, Dialogue dialogue, DialogueContext context, ReactionNode last) {
        ReactionNode arichatNode;
        if (last != null && !last.sound.isEmpty()) {
            WorldUtils.stopSound((EntityPlayerMP)player, (String)last.sound);
        }
        List<DialogueFragment> replies = context.replyNodes.stream().map(r -> r.message.copy().process(context.data)).collect(Collectors.toList());
        DialogueFragment reaction = context.reactionNode == null ? new DialogueFragment() : context.reactionNode.message.copy();
        reaction.process(context.data);
        reaction.dialogueID = dialogue.getId();
        if (context.reactionNode instanceof ArichatFirstReactionNode) {
            CharacterCard characterCard = ClientProxy.cardList.getImageCardByFilename((String)((ArichatFirstReactionNode)context.reactionNode).card).card;
            reaction.charName = characterCard.name;
            reaction.node = (ICardHandler)context.reactionNode;
            String first = characterCard.firstMes;
            if (!characterCard.alternateGreetings.isEmpty()) {
                ArrayList<String> allGreetings = new ArrayList<String>();
                allGreetings.add(characterCard.firstMes);
                allGreetings.addAll(characterCard.alternateGreetings);
                Random random = new Random();
                int randomIndex = random.nextInt(allGreetings.size());
                first = (String)allGreetings.get(randomIndex);
            }
            MacroContext macroContext = new MacroContext(new Conversation(player.getDisplayNameString(), characterCard, Sysprompt.base()), (EntityPlayer)player, Collections.emptyList());
            reaction.text = MacroProcessor.process(first, macroContext);
        }
        if (context.reactionNode instanceof ArichatReactionNode) {
            UUID dialogueId;
            arichatNode = (ArichatReactionNode)context.reactionNode;
            reaction.node = arichatNode;
            CharacterCard characterCard = ClientProxy.cardList.getImageCardByFilename((String)arichatNode.card).card;
            reaction.charName = characterCard.name;
            reaction.dialogueIDAI = dialogueId = UUID.randomUUID();
            reaction.activeSummary = SummaryGenerator.getSummary((EntityPlayer)player);
            DialogueGenerator.generateResponse(dialogueId, (ArichatReactionNode)arichatNode, dialogue, player, reaction, () -> {});
        } else if (context.reactionNode instanceof ArichatPromptReactionNode) {
            UUID dialogueId;
            arichatNode = (ArichatPromptReactionNode)context.reactionNode;
            reaction.dialogueIDAI = dialogueId = UUID.randomUUID();
            reaction.ltPrompt = arichatNode.fullPrompt;
            DialogueGenerator.generatePromptResponse(dialogueId, arichatNode.fullPrompt, dialogue, player, reaction, () -> {});
        } else {
            dialogue.history.add(reaction.text);
        }
        this.sendDialoguePacket(player, dialogue, context, reaction, replies);
    }

    private void sendDialoguePacket(EntityPlayerMP player, Dialogue dialogue, DialogueContext context, DialogueFragment reaction, List<DialogueFragment> replies) {
        PacketDialogueFragment packet = new PacketDialogueFragment(dialogue.closable, reaction, replies);
        Character character = Character.get((EntityPlayer)player);
        if (context.reactionNode instanceof ArichatReactionNode) {
            packet.showReplies(false);
        }
        if (context.reactionNode != null) {
            packet.addMorph(context.reactionNode.morph);
        }
        if (context.quest != null) {
            Quest quest = (Quest)Mappet.quests.load(context.quest.quest);
            if (quest != null) {
                QuestStatus status = QuestStatus.AVAILABLE;
                if (character.getQuests().has(quest.getId())) {
                    Quest playerQuest = character.getQuests().getByName(quest.getId());
                    status = playerQuest.isComplete((EntityPlayer)player) ? QuestStatus.COMPLETED : QuestStatus.UNAVAILABLE;
                }
                packet.addQuest(new QuestInfo(quest, status));
            }
        } else if (context.questChain != null) {
            packet.addQuests(Mappet.chains.evaluate(context.questChain.chain, (EntityPlayer)player, context.data.process(context.questChain.subject)));
        } else if (context.crafting != null) {
            CraftingTable table = (CraftingTable)Mappet.crafting.load(context.crafting.table);
            if (table != null) {
                table.filter(player);
                character.setCraftingTable(table);
                packet.addCraftingTable(table);
            }
        } else {
            character.setCraftingTable(null);
        }
        if (context.reactionNode != null) {
            if (context.reactionNode.read) {
                character.getStates().readDialogue(dialogue.getId(), context.reactionNode.marker);
            }
            WorldUtils.playSound((EntityPlayerMP)player, (String)context.reactionNode.sound);
        }
        mchorse.mappet.network.Dispatcher.sendTo((IMessage)packet, (EntityPlayerMP)player);
        if (context.reactionNode instanceof HistoryNode) {
            assert (character != null);
            States states = character.getStates();
            String summary = states.getStory(dialogue.getId());
            Dispatcher.sendTo(new PacketDialogueHistory(summary), player);
        }
    }

    public DialogueContext execute(Dialogue event, DialogueContext context) {
        if (event.main != null) {
            this.recursiveExecute(event, (EventBaseNode)event.main, context, false);
        }
        return context;
    }

    public void recursiveExecute(Dialogue system, EventBaseNode node, DialogueContext context, boolean skipFirst) {
        int result;
        if (context.executions >= (Integer)Mappet.eventMaxExecutions.get()) {
            return;
        }
        int n = result = skipFirst ? 0 : node.execute((EventContext)context);
        if (result >= 0) {
            ++context.nesting;
            List children = system.getChildren((Node)node);
            if (result == 0) {
                for (EventBaseNode child : children) {
                    this.recursiveExecute(system, child, context, false);
                }
            } else if (result <= children.size()) {
                this.recursiveExecute(system, (EventBaseNode)children.get(result - 1), context, false);
            }
            --context.nesting;
        }
        ++context.executions;
    }
}

