/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui;

import java.util.ArrayList;
import java.util.List;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.api.SummaryGenerator;
import kiraririria.arichatclassic.network.Dispatcher;
import kiraririria.arichatclassic.network.common.PacketStoreDialogue;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.dialogues.Dialogue;
import mchorse.mappet.api.dialogues.DialogueFragment;
import mchorse.mappet.api.dialogues.DialogueInputFragment;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.api.quests.chains.QuestInfo;
import mchorse.mappet.api.quests.chains.QuestStatus;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.client.gui.crafting.GuiCrafting;
import mchorse.mappet.client.gui.crafting.ICraftingScreen;
import mchorse.mappet.client.gui.mclib.GuiDialogTextElement;
import mchorse.mappet.client.gui.mclib.GuiReplyTextElement;
import mchorse.mappet.client.gui.mclib.GuiScrollElement;
import mchorse.mappet.client.gui.quests.GuiQuestCard;
import mchorse.mappet.client.gui.quests.GuiQuestInfoListElement;
import mchorse.mappet.client.gui.utils.GuiMorphRenderer;
import mchorse.mappet.client.gui.utils.text.GuiClickableText;
import mchorse.mappet.client.gui.utils.text.TextLine;
import mchorse.mappet.network.common.dialogue.PacketDialogueFragment;
import mchorse.mappet.network.common.dialogue.PacketFinishDialogue;
import mchorse.mappet.network.common.dialogue.PacketPickReply;
import mchorse.mappet.network.common.quests.PacketQuestAction;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiInteractionScreen
extends GuiBase
implements ICraftingScreen {
    public String currentSummary = "";
    public GuiElement area;
    public GuiMorphRenderer morph;
    public GuiButtonElement back;
    public mchorse.mclib.client.gui.framework.elements.GuiScrollElement reaction;
    public GuiDialogTextElement<TextLine> reactionText;
    public boolean AIInProgress = false;
    public GuiScrollElement replies;
    public boolean hasUserInputNode;
    public PacketDialogueFragment fragment;
    public GuiCrafting crafting;
    private CraftingTable table;
    public int summaredCount = 0;
    public boolean summaryInProgress = false;
    public GuiElement quest;
    public GuiQuestInfoListElement quests;
    public mchorse.mclib.client.gui.framework.elements.GuiScrollElement questArea;
    public GuiButtonElement actionQuest;
    private List<QuestInfo> questInfos;
    private DialogueInputFragment inputReply;
    private GuiClickableText lastReply;
    public String lastPerson = "";

    public GuiInteractionScreen(PacketDialogueFragment fragment) {
        ClientProxy.haveAIInDialog = false;
        if (fragment.reaction != null && fragment.reaction.dialogueIDAI != null) {
            ClientProxy.haveAIInDialog = true;
        }
        Minecraft mc = Minecraft.func_71410_x();
        this.morph = new GuiMorphRenderer(mc);
        this.morph.flex().relative((IResizer)this.viewport).x(0.4f).w(0.6f).h(1.0f);
        this.back = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.interaction.back"), b -> mchorse.mappet.network.Dispatcher.sendToServer((IMessage)new PacketPickReply(-1)));
        this.morph.fov = 40.0f;
        this.morph.setScale(2.1f);
        this.morph.setRotation(-27.0f, 5.0f);
        this.morph.setPosition(-0.1313307f, 1.3154614f, 0.0359409f);
        this.morph.setEnabled(false);
        this.area = new GuiElement(mc);
        this.area.flex().relative((IResizer)this.viewport).x(0.2f).y(20).w(0.4f).h(1.0f, -20);
        this.reaction = new mchorse.mclib.client.gui.framework.elements.GuiScrollElement(mc);
        this.replies = new GuiScrollElement(mc);
        this.reaction.flex().relative(this.area).w(1.0f).hTo((IResizer)this.replies.area).column(0).vertical().stretch().scroll().padding(10);
        this.reaction.cancelScrollEdge();
        this.replies.flex().relative(this.area).y(0.75f).w(1.0f).hTo((IResizer)this.area.area, 1.0f).column(10).vertical().stretch().scroll().padding(10);
        this.replies.cancelScrollEdge();
        this.crafting = new GuiCrafting(mc);
        this.crafting.flex().relative(this.area).y(0.45f).w(1.0f).hTo((IResizer)this.area.area, 1.0f);
        this.crafting.setVisible(false);
        this.quest = new GuiElement(mc);
        this.quest.setVisible(false);
        this.quests = new GuiQuestInfoListElement(mc, l -> this.pickQuest((QuestInfo)l.get(0)));
        this.questArea = new mchorse.mclib.client.gui.framework.elements.GuiScrollElement(mc);
        this.actionQuest = new GuiButtonElement(mc, IKey.lang((String)"mappet.gui.interaction.accept"), b -> this.actionQuest());
        this.quest.flex().relative(this.area).y(0.25f).w(1.0f).hTo((IResizer)this.area.area, 1.0f);
        this.quests.background().flex().relative(this.quest).y(10).w(1.0f).h(56);
        this.questArea.flex().relative(this.quest).y(66).w(1.0f).hTo((IResizer)this.actionQuest.area, -5).column(5).vertical().stretch().scroll().padding(10);
        this.actionQuest.flex().relative(this.quest).x(1.0f, -10).y(1.0f, -10).wh(80, 20).anchor(1.0f, 1.0f);
        this.quest.add(new IGuiElement[]{this.actionQuest, this.questArea, this.quests});
        GuiDrawable drawable = new GuiDrawable(context -> {
            Gui.func_73734_a((int)0, (int)0, (int)this.area.area.x(0.65f), (int)this.area.area.ey(), (int)-1442840576);
            GuiDraw.drawHorizontalGradientRect((int)this.area.area.x(0.65f), (int)0, (int)this.area.area.x(1.125f), (int)this.area.area.ey(), (int)-1442840576, (int)0);
        });
        this.area.add(new IGuiElement[]{this.quest, this.crafting, this.replies, this.reaction});
        this.root.add(new IGuiElement[]{this.morph, drawable, this.area});
        if (this.reactionText == null) {
            this.reactionText = new GuiDialogTextElement(Minecraft.func_71410_x());
        }
        this.reaction.add((IGuiElement)this.reactionText);
        this.reaction.resize();
        this.pickReply(fragment);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void updateVisibility() {
        this.back.removeFromParent();
        if (this.questInfos != null) {
            this.quests.setVisible(!this.fragment.singleQuest);
            if (this.fragment.singleQuest) {
                this.questArea.flex().relative(this.quest).y(0);
            } else {
                this.questArea.flex().relative(this.quest).y(66);
            }
            this.reaction.flex().hTo((IResizer)this.quest.area);
            this.back.flex().reset().relative(this.quest).x(10).y(1.0f, -10).wh(80, 20).anchorY(1.0f);
            this.quest.add((IGuiElement)this.back);
        } else if (this.table != null) {
            this.reaction.flex().hTo((IResizer)this.crafting.area);
            this.back.flex().reset().relative((GuiElement)this.crafting).x(10).y(1.0f, -10).wh(80, 20).anchorY(1.0f);
            this.crafting.add((IGuiElement)this.back);
        } else {
            this.reaction.flex().hTo((IResizer)this.replies.area);
        }
        this.quest.setVisible(this.questInfos != null);
        this.crafting.setVisible(this.table != null);
        this.replies.setVisible(this.questInfos == null && this.table == null);
    }

    public void PostFragmentEvent() {
        Dialogue dialogue = (Dialogue)Mappet.dialogues.load(this.fragment.reaction.dialogueID);
        if (dialogue.summarise) {
            List<String> history = this.collect();
            int newMessagesCount = history.size() - this.summaredCount;
            boolean e = false;
            if (newMessagesCount % 2 == 0) {
                e = true;
                --newMessagesCount;
            }
            if (newMessagesCount >= (Integer)ArichatClassic.summaryMessageCount.get()) {
                int startIndex = history.size() - newMessagesCount;
                int endIndex = startIndex + (Integer)ArichatClassic.summaryMessageCount.get();
                List<String> newMessages = history.subList(startIndex, endIndex);
                this.summaredCount += ((Integer)ArichatClassic.summaryMessageCount.get()).intValue();
                if (e) {
                    ++this.summaredCount;
                }
                this.summaryInProgress = true;
                this.replies.setVisible(false);
                SummaryGenerator.generateSummary(dialogue.getId(), this.fragment.reaction.node, newMessages, this.currentSummary, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, () -> {
                    this.summaryInProgress = false;
                    this.replies.setVisible(true);
                });
            }
        }
    }

    private void setFragment(PacketDialogueFragment fragment) {
        Dialogue dialogue = (Dialogue)Mappet.dialogues.load(fragment.reaction.dialogueID);
        if (dialogue.summarise) {
            Character character;
            if (this.currentSummary.isEmpty() && (character = Character.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) != null) {
                this.currentSummary = character.getStates().getSummary(fragment.reaction.dialogueID);
            }
            if (this.currentSummary.isEmpty()) {
                this.currentSummary = fragment.reaction.activeSummary;
            }
        }
        if (fragment.morph != null) {
            this.morph.morph.set(fragment.morph);
        }
        if (fragment.reaction.dialogueIDAI != null) {
            ClientProxy.haveAIInDialog = true;
        }
        if (this.fragment != null && !this.reactionText.getText().isEmpty()) {
            this.saveToHistory();
        }
        this.fragment = fragment;
        this.table = null;
        this.questInfos = null;
        this.reactionText.callback(string -> {});
        this.reactionText.wrap(true);
        this.reactionText.flex().relative((GuiElement)this.reaction).w(1.0f);
        if (this.reactionText.hasAlternatives()) {
            this.reactionText.clearAlternatives();
        }
        this.reactionText.setText(fragment.reaction.getProcessedText());
        this.reactionText.setColor(fragment.reaction.color, true);
        this.reactionText.unfocus();
        if (fragment.reaction.ai) {
            this.reactionText.setElementType(GuiDialogTextElement.ElementType.AI_REACTION);
        } else {
            this.reactionText.setElementType(GuiDialogTextElement.ElementType.REACTION);
        }
        this.updateReplies(fragment);
        this.updateVisibility();
        this.root.resize();
        this.replies.setVisible(fragment.replyShow);
        this.reaction.resize();
        this.replies.resize();
        this.root.resize();
    }

    public void enableRegenAnswer() {
        this.reactionText.enableRegenAnswer();
    }

    private void saveToHistory() {
        GuiDialogTextElement<TextLine> historyReaction = this.createHistoryElement(this.reactionText.getText(), this.reactionText.getColor());
        historyReaction.flex().w(1.0f);
        historyReaction.setElementType(GuiDialogTextElement.ElementType.REACTION);
        if (this.lastReply != null) {
            GuiDialogTextElement<TextLine> historyReply = this.createHistoryElement(this.lastReply.getText().get().replace("> ", ""), this.lastReply.color);
            historyReply.setElementType(GuiDialogTextElement.ElementType.ANSWER);
            historyReply.flex().w(1.0f);
            this.reaction.addBefore((IGuiElement)this.reactionText, (IGuiElement)historyReaction);
            this.reaction.addBefore((IGuiElement)this.reactionText, (IGuiElement)historyReply);
        } else {
            this.reaction.addBefore((IGuiElement)this.reactionText, (IGuiElement)historyReaction);
        }
        this.reaction.updateContentSize();
        this.reaction.resize();
    }

    private GuiDialogTextElement<TextLine> createHistoryElement(String text, int color) {
        GuiDialogTextElement<TextLine> element = new GuiDialogTextElement<TextLine>(Minecraft.func_71410_x());
        element.wrap(true);
        element.setText(text);
        element.setColor(color, true);
        element.background(false);
        element.flex().w(1.0f).h(0);
        element.setEnabled(true);
        element.alwaysCursor(false);
        return element;
    }

    private void updateReplies(PacketDialogueFragment fragment) {
        this.replies.removeAll();
        this.hasUserInputNode = false;
        this.inputReply = null;
        for (DialogueFragment reply : fragment.replies) {
            if (reply instanceof DialogueInputFragment) {
                this.hasUserInputNode = true;
                this.inputReply = (DialogueInputFragment)reply;
                continue;
            }
            GuiClickableText replyElement = new GuiClickableText(Minecraft.func_71410_x());
            replyElement.callback(this::pickReply);
            replyElement.color(reply.color, true);
            replyElement.hoverColor(ColorUtils.multiplyColor((int)reply.color, (float)0.7f));
            replyElement.text("> " + reply.getProcessedText());
            replyElement.flex().w(1.0f).h(20);
            replyElement.area.h = 20;
            this.replies.add((IGuiElement)replyElement);
        }
        if (this.hasUserInputNode) {
            GuiReplyTextElement userTextInput = new GuiReplyTextElement(Minecraft.func_71410_x());
            userTextInput.callback(this::pickUserInputReply);
            userTextInput.setColor(this.inputReply.color, true);
            userTextInput.hoverColor(ColorUtils.multiplyColor((int)this.inputReply.color, (float)0.7f));
            userTextInput.arrow(true);
            userTextInput.enterCallback(true);
            userTextInput.alwaysCursor(true);
            userTextInput.wrap(true);
            userTextInput.setShif(16);
            userTextInput.flex().relative((GuiElement)this.replies).w(1.0f).h(30);
            userTextInput.area.h = 30;
            this.replies.add((IGuiElement)userTextInput);
        }
        this.replies.resize();
    }

    private void pickReply(GuiClickableText text) {
        if (this.summaryInProgress) {
            return;
        }
        this.lastReply = text;
        mchorse.mappet.network.Dispatcher.sendToServer((IMessage)new PacketPickReply(this.replies.getChildren().indexOf(text), text.getText().get()));
    }

    private void pickUserInputReply(String text) {
        if (this.summaryInProgress) {
            return;
        }
        GuiClickableText t = new GuiClickableText(Minecraft.func_71410_x());
        t.text(text);
        t.color(this.inputReply.color, true);
        this.lastReply = t;
        mchorse.mappet.network.Dispatcher.sendToServer((IMessage)new PacketPickReply(this.fragment.replies.indexOf(this.inputReply), text));
    }

    public void pickReply(PacketDialogueFragment fragment) {
        this.setFragment(fragment);
        if (fragment.reaction.text.isEmpty() && fragment.isEmpty()) {
            this.closeScreen();
            return;
        }
        if (fragment.hasQuests) {
            this.setQuests(fragment.quests);
        } else if (fragment.table != null) {
            this.setCraftingTable(fragment.table);
        }
    }

    public void setCraftingTable(CraftingTable table) {
        this.table = table;
        this.crafting.set(table);
        this.updateVisibility();
        this.root.resize();
    }

    public void refresh() {
        this.crafting.refresh();
    }

    public void setQuests(List<QuestInfo> quests) {
        this.questInfos = quests;
        this.quests.clear();
        this.quests.setList(quests);
        this.quests.sort();
        this.quests.setVisible(!quests.isEmpty());
        this.quests.setIndex(0);
        this.pickQuest((QuestInfo)this.quests.getCurrentFirst());
        this.updateVisibility();
        this.root.resize();
    }

    public void pickQuest(QuestInfo info) {
        this.questArea.removeAll();
        this.actionQuest.label.set(info != null && info.status == QuestStatus.COMPLETED ? "mappet.gui.interaction.complete" : "mappet.gui.interaction.accept");
        if (info != null) {
            GuiQuestCard.fillQuest((GuiElement)this.questArea, (Quest)info.quest, (boolean)true, (boolean)false);
        }
        this.questArea.resize();
        this.actionQuest.setEnabled(info != null && info.status != QuestStatus.UNAVAILABLE);
    }

    public void actionQuest() {
        QuestInfo info = (QuestInfo)this.quests.getCurrentFirst();
        mchorse.mappet.network.Dispatcher.sendToServer((IMessage)new PacketQuestAction(info.quest.getId(), info.status));
        if (this.fragment.singleQuest && info.status == QuestStatus.COMPLETED) {
            this.back.clickItself(GuiBase.getCurrent());
            return;
        }
        if (info.status == QuestStatus.AVAILABLE) {
            info.status = QuestStatus.UNAVAILABLE;
            this.actionQuest.setEnabled(false);
        } else if (info.status == QuestStatus.COMPLETED) {
            this.quests.setIndex(0);
            info = (QuestInfo)this.quests.getCurrentFirst();
            this.pickQuest(info);
        }
    }

    protected void closeScreen() {
        if ((this.fragment.closable || this.fragment.isEmpty()) && !this.AIInProgress) {
            String story;
            super.closeScreen();
            Dialogue dialogue = (Dialogue)Mappet.dialogues.load(this.fragment.reaction.dialogueID);
            if (dialogue.store && !(story = this.collectColored()).isEmpty()) {
                Dispatcher.sendToServer(new PacketStoreDialogue(story));
            }
            if (dialogue.summarise) {
                int maxMessagesToTake;
                int actualMessagesToTake;
                int endIndex;
                int startIndex;
                List<String> history = this.collect();
                int historySize = history.size();
                int newMessagesCount = historySize - this.summaredCount;
                if (newMessagesCount > 0 && newMessagesCount % 2 == 0) {
                    --newMessagesCount;
                }
                if (newMessagesCount > 0 && historySize > 2 && (startIndex = Math.max(0, historySize - newMessagesCount)) < (endIndex = Math.min(historySize, startIndex + (actualMessagesToTake = Math.min(newMessagesCount, maxMessagesToTake = ((Integer)ArichatClassic.summaryMessageCount.get()).intValue()))))) {
                    List<String> newMessages = history.subList(startIndex, endIndex);
                    SummaryGenerator.generateSummary(dialogue.getId(), this.fragment.reaction.node, newMessages, this.currentSummary, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, () -> {});
                    this.summaredCount = historySize;
                }
            }
            mchorse.mappet.network.Dispatcher.sendToServer((IMessage)new PacketFinishDialogue());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setLocalSummary(String summary) {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiInteractionScreen) {
            GuiInteractionScreen dialogue = (GuiInteractionScreen)screen;
            dialogue.currentSummary = summary;
        }
    }

    private List<String> collect() {
        ArrayList<String> history = new ArrayList<String>();
        this.reaction.getChildren().forEach(iGuiElement -> {
            GuiDialogTextElement textElement = (GuiDialogTextElement)((Object)iGuiElement);
            history.add(textElement.getText());
        });
        return history;
    }

    private String collectColored() {
        StringBuilder builder = new StringBuilder();
        ArrayList<NBTTagCompound> history = new ArrayList<NBTTagCompound>();
        int index = 0;
        for (IGuiElement element : this.reaction.getChildren()) {
            String speaker;
            GuiDialogTextElement textElement = (GuiDialogTextElement)element;
            String text = textElement.getText();
            int color = textElement.getColor();
            if (index % 2 == 0) {
                speaker = this.fragment.reaction.charName;
                if (speaker.isEmpty()) {
                    speaker = "NPC";
                }
            } else {
                speaker = Minecraft.func_71410_x().field_71439_g.getDisplayNameString();
            }
            String formattedLine = String.format("%s: %s", speaker, text);
            builder.append(formattedLine).append("\\n");
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("text", formattedLine);
            compound.func_74768_a("color", color);
            history.add(compound);
            ++index;
        }
        return this.serializeNBTList(history);
    }

    private String serializeNBTList(List<NBTTagCompound> history) {
        NBTTagList nbtList = new NBTTagList();
        for (NBTTagCompound compound : history) {
            nbtList.func_74742_a((NBTBase)compound);
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a("history", (NBTBase)nbtList);
        return root.toString();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.reactionText.setVisible(true);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.fragment.isEmpty()) {
            int y = this.table != null ? this.crafting.area.y - 1 : (this.questInfos != null ? this.quest.area.y - 1 : this.replies.area.y - 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.drawHorizontalGradientRect((int)(this.replies.area.x - 20), (int)y, (int)this.replies.area.mx(), (int)(y + 1), (int)0, (int)-1996488705);
            GuiDraw.drawHorizontalGradientRect((int)this.replies.area.mx(), (int)y, (int)(this.replies.area.ex() + 20), (int)(y + 1), (int)-1996488705, (int)0);
        } else {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"mappet.gui.interaction.info.no_replies", (Object[])new Object[0]), this.replies.area.mx(), this.replies.area.my(), 0x333333);
        }
        if (this.questInfos != null && this.quests.getList().isEmpty()) {
            int w = (int)((float)this.questArea.area.w / 1.5f);
            GuiDraw.drawMultiText((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"mappet.gui.interaction.info.no_quests", (Object[])new Object[0]), (int)(this.questArea.area.mx() - w / 2), (int)((this.quest.area.y + this.actionQuest.area.y - 10) / 2), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
        if (this.fragment != null) {
            this.func_73732_a(this.field_146289_q, this.fragment.title, this.reaction.area.mx(), 10, 0xFFFFFF);
        }
    }

    public void restoreHistory(String history) {
        if (history == null || history.trim().isEmpty()) {
            return;
        }
        List children = this.reaction.getChildren();
        int currentIndex = children.indexOf(this.reactionText);
        if (currentIndex > 0) {
            for (int i = 0; i < currentIndex; ++i) {
                children.remove(0);
            }
        }
        try {
            int i;
            NBTTagCompound root = JsonToNBT.func_180713_a((String)history);
            NBTTagList nbtHistory = root.func_150295_c("history", 10);
            ArrayList<String> cleanedLines = new ArrayList<String>();
            ArrayList<Integer> colors = new ArrayList<Integer>();
            for (int i2 = 0; i2 < nbtHistory.func_74745_c(); ++i2) {
                NBTTagCompound compound = nbtHistory.func_150305_b(i2);
                String textWithSpeaker = compound.func_74779_i("text");
                int color = compound.func_74762_e("color");
                int colonIndex = textWithSpeaker.indexOf(58);
                String cleanedText = colonIndex != -1 ? textWithSpeaker.substring(colonIndex + 1).trim() : textWithSpeaker;
                cleanedLines.add(cleanedText);
                colors.add(color);
            }
            this.summaredCount += cleanedLines.size();
            if (cleanedLines.isEmpty()) {
                this.resetReactionText();
                return;
            }
            int lastNPCIndex = -1;
            for (i = cleanedLines.size() - 1; i >= 0; --i) {
                if (i % 2 != 0) continue;
                lastNPCIndex = i;
                break;
            }
            this.resetReactionText();
            if (lastNPCIndex != -1) {
                String lastNPCText = (String)cleanedLines.get(lastNPCIndex);
                int lastNPCColor = (Integer)colors.get(lastNPCIndex);
                this.reactionText.setText(lastNPCText);
                this.reactionText.setColor(lastNPCColor, true);
                this.reactionText.setElementType(GuiDialogTextElement.ElementType.REACTION);
                for (int i3 = 0; i3 < lastNPCIndex; ++i3) {
                    this.addToHistory((String)cleanedLines.get(i3), (Integer)colors.get(i3), i3);
                }
            } else {
                for (i = 0; i < cleanedLines.size(); ++i) {
                    this.addToHistory((String)cleanedLines.get(i), (Integer)colors.get(i), i);
                }
            }
            this.reaction.updateContentSize();
            this.reaction.resize();
        }
        catch (NBTException e) {
            this.restoreOldFormat(history);
        }
    }

    private void addToHistory(String text, int color, int index) {
        GuiDialogTextElement<TextLine> element = this.createHistoryElement(text, color);
        if (index % 2 == 0) {
            element.setElementType(GuiDialogTextElement.ElementType.REACTION);
        } else {
            element.setElementType(GuiDialogTextElement.ElementType.ANSWER);
        }
        this.reaction.addBefore((IGuiElement)this.reactionText, (IGuiElement)element);
    }

    private void restoreOldFormat(String history) {
        int i;
        String[] lines = history.split("\\\\n");
        ArrayList<String> cleanedLines = new ArrayList<String>();
        for (String line : lines) {
            String cleanedLine = line.trim();
            if (cleanedLine.isEmpty()) continue;
            int colonIndex = cleanedLine.indexOf(58);
            if (colonIndex != -1) {
                cleanedLine = cleanedLine.substring(colonIndex + 1).trim();
            }
            cleanedLines.add(cleanedLine);
        }
        this.summaredCount += cleanedLines.size();
        if (cleanedLines.isEmpty()) {
            this.resetReactionText();
            return;
        }
        int lastNPCIndex = -1;
        for (i = cleanedLines.size() - 1; i >= 0; --i) {
            if (i % 2 != 0) continue;
            lastNPCIndex = i;
            break;
        }
        this.resetReactionText();
        if (lastNPCIndex != -1) {
            String lastNPCText = (String)cleanedLines.get(lastNPCIndex);
            this.reactionText.setText(lastNPCText);
            this.reactionText.setColor(0xFFFFFF, true);
            this.reactionText.setElementType(GuiDialogTextElement.ElementType.REACTION);
            for (int i2 = 0; i2 < lastNPCIndex; ++i2) {
                this.addToHistory((String)cleanedLines.get(i2), i2);
            }
        } else {
            for (i = 0; i < cleanedLines.size(); ++i) {
                this.addToHistory((String)cleanedLines.get(i), i);
            }
        }
        this.reaction.updateContentSize();
        this.reaction.resize();
    }

    private void resetReactionText() {
        this.reactionText.callback(string -> {});
        this.reactionText.wrap(true);
        this.reactionText.flex().relative((GuiElement)this.reaction).w(1.0f);
        this.reactionText.setText("");
        this.reactionText.setColor(0xFFFFFF, true);
        this.reactionText.setElementType(GuiDialogTextElement.ElementType.REACTION);
        this.reactionText.unfocus();
        if (this.reactionText.hasAlternatives()) {
            this.reactionText.clearAlternatives();
        }
    }

    private void addToHistory(String text, int index) {
        GuiDialogTextElement<TextLine> element = this.createHistoryElement(text, 0xFFFFFF);
        if (index % 2 == 0) {
            element.setElementType(GuiDialogTextElement.ElementType.REACTION);
        } else {
            element.setElementType(GuiDialogTextElement.ElementType.ANSWER);
        }
        this.reaction.addBefore((IGuiElement)this.reactionText, (IGuiElement)element);
    }
}

