/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.mclib;

import com.google.common.collect.ImmutableList;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.vecmath.Vector2d;
import kiraririria.arichatclassic.ArichatClassic;
import kiraririria.arichatclassic.ClientProxy;
import kiraririria.arichatclassic.api.DialogueGenerator;
import kiraririria.arichatclassic.utils.mclib.ACIcons;
import mchorse.mappet.client.gui.utils.GuiMappetUtils;
import mchorse.mappet.client.gui.utils.text.TextLine;
import mchorse.mappet.client.gui.utils.text.utils.Cursor;
import mchorse.mappet.client.gui.utils.text.utils.StringGroup;
import mchorse.mclib.McLib;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IFocusedGuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.framework.elements.utils.ITextColoring;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.lwjgl.input.Keyboard;

public class GuiDialogTextElement<T extends TextLine>
extends GuiElement
implements IFocusedGuiElement,
ITextColoring {
    public Consumer<String> callback;
    private boolean background;
    protected int padding = 0;
    protected int lineHeight = 12;
    protected int textColor = 0xFFFFFF;
    protected int color = 0xFFFFFF;
    protected int hover = 0xFFFFFF;
    protected boolean textShadow;
    protected boolean wrapping;
    private boolean focused;
    private boolean editable;
    private int dragging;
    protected List<T> text = new ArrayList<T>();
    protected List<String> alternatives = new ArrayList<String>();
    private int currentAlternativeIndex = -1;
    public final Cursor cursor = new Cursor();
    public final Cursor selection = new Cursor(-1, 0);
    private int lastMX;
    private int lastMY;
    private long lastClick;
    private long update;
    private long lastUpdate;
    private StringGroup lastGroup;
    private boolean arrow = false;
    private boolean alwaysCursor = false;
    private boolean enterCallback = false;
    public int totalHeight = 1;
    public float underPadding = 1.0f;
    boolean editingChatMod = false;
    GuiIconElement EDIT_ICON;
    GuiIconElement REGEN_ICON;
    GuiIconElement DEL_ICON;
    GuiIconElement RROMPT_ICON;
    GuiIconElement SWIPE_ICON;
    public ElementType elementType = ElementType.REACTION;
    GuiElement editPanel;
    public boolean needsSizeUpdate;
    private boolean[] asteriskFormatState = new boolean[0];
    private boolean[] parenthesisFormatState = new boolean[0];

    public void enableRegenAnswer() {
        this.REGEN_ICON.setVisible(true);
        this.SWIPE_ICON.setVisible(true);
        this.editPanel.resize();
    }

    public void setElementType(ElementType type) {
        this.elementType = type;
        this.focused = false;
        this.editable = false;
        if (((Boolean)ArichatClassic.enableChatEditing.get()).booleanValue()) {
            this.editingChatMod = true;
            this.initEditingPanel();
        } else {
            this.editingChatMod = false;
        }
    }

    public static List<String> splitNewlineString(String string) {
        ArrayList<String> splits = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int c = string.length();
        for (int i = 0; i < c; ++i) {
            char character = string.charAt(i);
            if (character == '\n') {
                splits.add(builder.toString());
                builder = new StringBuilder();
                continue;
            }
            builder.append(character);
        }
        splits.add(builder.toString());
        return splits;
    }

    public GuiDialogTextElement(Minecraft mc) {
        super(mc);
        this.flex().h(() -> Float.valueOf(this.totalHeight));
        this.background(false);
        this.focused = false;
        this.editable = false;
        this.textShadow = true;
        this.clear();
        this.recalculateSizes();
    }

    private void initEditingPanel() {
        this.EDIT_ICON = new GuiIconElement(this.mc, ACIcons.EL_EDIT, this::switchEditMod);
        this.REGEN_ICON = new GuiIconElement(this.mc, ACIcons.EL_RELOAD, this::regenDialog);
        this.DEL_ICON = new GuiIconElement(this.mc, ACIcons.EL_DEL, this::deleteDialog);
        this.RROMPT_ICON = new GuiIconElement(this.mc, ACIcons.EL_PROMPT, this::copyPrompt);
        this.SWIPE_ICON = new GuiIconElement(this.mc, ACIcons.EL_SWIPE, this::swipeDialog);
        this.editPanel = Elements.row((Minecraft)this.mc, (int)1, (int)0, (int)10, (GuiElement[])new GuiElement[0]);
        this.editPanel.setVisible(false);
        this.editPanel.flex().relative((IResizer)this.area).x(0.8f);
        this.REGEN_ICON.setVisible(false);
        this.SWIPE_ICON.setVisible(false);
        switch (this.elementType) {
            case REACTION: 
            case ANSWER: {
                this.editPanel.add(new IGuiElement[]{this.EDIT_ICON, this.DEL_ICON, this.RROMPT_ICON});
                break;
            }
            case AI_REACTION: {
                this.editPanel.add(new IGuiElement[]{this.EDIT_ICON, this.REGEN_ICON, this.SWIPE_ICON, this.DEL_ICON, this.RROMPT_ICON});
            }
        }
        this.add((IGuiElement)this.editPanel);
    }

    private void swipeDialog(GuiIconElement guiIconElement) {
        if (this.alternatives.isEmpty()) {
            return;
        }
        this.alternatives.add(this.getText());
        this.currentAlternativeIndex = (this.currentAlternativeIndex + 1) % this.alternatives.size();
        String alt = this.alternatives.get(this.currentAlternativeIndex);
        this.setText(alt);
        this.alternatives.remove(0);
    }

    private void copyPrompt(GuiIconElement guiIconElement) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.getText()), null);
    }

    private void deleteDialog(GuiIconElement guiIconElement) {
        GuiElement parent = this.getParent();
        this.removeFromParent();
        if (parent != null && parent instanceof GuiScrollElement) {
            ((GuiScrollElement)parent).updateContentSize();
            parent.resize();
        }
    }

    private void _parentResize() {
        GuiElement parent = this.getParent();
        if (parent != null && parent instanceof GuiScrollElement) {
            ((GuiScrollElement)parent).updateContentSize();
            parent.resize();
        }
    }

    private void regenDialog(GuiIconElement guiIconElement) {
        guiIconElement.setVisible(false);
        this.SWIPE_ICON.setVisible(false);
        this.alternatives.add(this.getText());
        DialogueGenerator.regenerateResponse(UUID.randomUUID(), () -> {
            guiIconElement.setVisible(true);
            this.SWIPE_ICON.setVisible(true);
            this.alternatives.add(this.getText());
        });
    }

    private void switchEditMod(GuiIconElement guiIconElement) {
        this.focused = !this.focused;
        this.editable = !this.editable;
    }

    public GuiDialogTextElement<T> background() {
        return this.background(true);
    }

    public GuiDialogTextElement<T> background(boolean background) {
        this.background = background;
        return this;
    }

    public GuiDialogTextElement<T> padding(int padding) {
        this.padding = padding;
        return this;
    }

    public GuiDialogTextElement<T> lineHeight(int lineHeight) {
        this.lineHeight = lineHeight;
        return this;
    }

    public GuiDialogTextElement<T> wrap() {
        return this.wrap(!this.wrapping);
    }

    public GuiDialogTextElement<T> wrap(boolean wrapping) {
        this.wrapping = wrapping;
        return this;
    }

    public void setColor(int textColor, boolean textShadow) {
        this.color = textColor;
        this.hover = textColor;
        this.textShadow = textShadow;
    }

    public void hoverColor(int hoverColor) {
        this.hover = hoverColor;
    }

    public void arrow(boolean arrow) {
        this.arrow = arrow;
    }

    public void enterCallback(boolean enterCallback) {
        this.enterCallback = enterCallback;
    }

    public void alwaysCursor(boolean alwaysCursor) {
        this.alwaysCursor = alwaysCursor;
    }

    protected T createTextLine(String line) {
        return (T)new TextLine(line);
    }

    public String getText() {
        return this.text.stream().map(t -> t.text).collect(Collectors.joining("\n"));
    }

    public int getColor() {
        return this.color;
    }

    public List<T> getLines() {
        return this.text;
    }

    public int getWrappedWidth() {
        if (this.area.w <= 0) {
            return 355;
        }
        return this.area.w - 10;
    }

    public boolean isSelected() {
        return !this.selection.isEmpty();
    }

    public void startSelecting() {
        this.selection.copy(this.cursor);
    }

    public void deselect() {
        this.selection.set(-1, 0);
    }

    public void swapSelection() {
        if (this.isSelected()) {
            Cursor temp = new Cursor();
            temp.copy(this.selection);
            this.selection.copy(this.cursor);
            this.cursor.copy(temp);
        }
    }

    public void clearAlternatives() {
        this.alternatives.clear();
    }

    public boolean hasAlternatives() {
        return !this.alternatives.isEmpty();
    }

    public void selectAll() {
        this.cursor.set(0, 0);
        this.startSelecting();
        this.cursor.line = this.text.size() - 1;
        this.moveCursorToLineEnd();
    }

    public String getSelectedText() {
        if (!this.isSelected()) {
            return "";
        }
        return this.getText(this.cursor, this.selection);
    }

    protected void drawTextLine(String line, int i, int j, int nx, int ny) {
        int HIGHLIGHT_COLOR = (Integer)ArichatClassic.highlightColor.get();
        int PARENTHESIS_COLOR = (Integer)ArichatClassic.parenthesisColor.get();
        boolean PROCESS_PARENTHESES = (Boolean)ArichatClassic.parenthesisMod.get();
        if (((Boolean)ArichatClassic.hideMacros.get()).booleanValue()) {
            line = this.hideMacrosInLine(line);
        }
        if ((Integer)ArichatClassic.asteriskMod.get() == 0 && !PROCESS_PARENTHESES) {
            int width = this.font.func_78256_a(line);
            this.font.func_175065_a(line, (float)nx, (float)ny, this.textColor, this.textShadow);
            return;
        }
        int currentX = nx;
        StringBuilder segment = new StringBuilder();
        boolean escaped = false;
        boolean inAsteriskFormat = i > 0 && this.isLineContinuingAsteriskFormat(i);
        boolean inParenthesisFormat = PROCESS_PARENTHESES && i > 0 && this.isLineContinuingParenthesisFormat(i);
        for (int idx = 0; idx < line.length(); ++idx) {
            int highlightWidth;
            char c = line.charAt(idx);
            if (escaped) {
                segment.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '*' && (Integer)ArichatClassic.asteriskMod.get() != 0) {
                int nextStar;
                if (segment.length() > 0) {
                    String preText = segment.toString();
                    int preWidth = this.font.func_78256_a(preText);
                    this.font.func_175065_a(inAsteriskFormat ? this.makeColoredTextItalic(preText) : preText, (float)currentX, (float)ny, inAsteriskFormat ? HIGHLIGHT_COLOR : this.textColor, this.textShadow);
                    currentX += preWidth;
                    segment.setLength(0);
                }
                if ((nextStar = this.findNextUnescapedStar(line, idx + 1)) != -1) {
                    String highlighted = line.substring(idx + 1, nextStar);
                    if ((Integer)ArichatClassic.asteriskMod.get() == 2) {
                        String fullText = "*" + highlighted + "*";
                        highlightWidth = this.font.func_78256_a(fullText);
                        this.font.func_175065_a(this.makeColoredTextItalic(fullText), (float)currentX, (float)ny, HIGHLIGHT_COLOR, this.textShadow);
                    } else {
                        highlightWidth = this.font.func_78256_a(highlighted);
                        this.font.func_175065_a(this.makeColoredTextItalic(highlighted), (float)currentX, (float)ny, HIGHLIGHT_COLOR, this.textShadow);
                    }
                    currentX += highlightWidth;
                    idx = nextStar;
                    continue;
                }
                boolean bl = inAsteriskFormat = !inAsteriskFormat;
                if ((Integer)ArichatClassic.asteriskMod.get() != 2) continue;
                segment.append(c);
                continue;
            }
            if (PROCESS_PARENTHESES && c == '(') {
                int closingParen;
                if (segment.length() > 0) {
                    String preText = segment.toString();
                    int preWidth = this.font.func_78256_a(preText);
                    this.font.func_175065_a(preText, (float)currentX, (float)ny, inParenthesisFormat ? PARENTHESIS_COLOR : this.textColor, this.textShadow);
                    currentX += preWidth;
                    segment.setLength(0);
                }
                if ((closingParen = this.findNextUnescapedParenthesis(line, idx + 1, ')')) != -1) {
                    String highlighted = line.substring(idx + 1, closingParen);
                    highlightWidth = this.font.func_78256_a(highlighted);
                    this.font.func_175065_a(this.makeColoredTextItalic(highlighted), (float)currentX, (float)ny, PARENTHESIS_COLOR, this.textShadow);
                    currentX += highlightWidth;
                    idx = closingParen;
                    continue;
                }
                inParenthesisFormat = true;
                continue;
            }
            if (PROCESS_PARENTHESES && c == ')' && inParenthesisFormat) {
                if (segment.length() > 0) {
                    String preText = segment.toString();
                    int preWidth = this.font.func_78256_a(preText);
                    this.font.func_175065_a(this.makeColoredTextItalic(preText), (float)currentX, (float)ny, PARENTHESIS_COLOR, this.textShadow);
                    currentX += preWidth;
                    segment.setLength(0);
                }
                inParenthesisFormat = false;
                continue;
            }
            segment.append(c);
        }
        if (segment.length() > 0) {
            String remaining = segment.toString();
            int remainingWidth = this.font.func_78256_a(remaining);
            int color = this.textColor;
            if (inAsteriskFormat) {
                color = HIGHLIGHT_COLOR;
            } else if (inParenthesisFormat) {
                color = PARENTHESIS_COLOR;
            }
            this.font.func_175065_a(remaining, (float)currentX, (float)ny, color, this.textShadow);
        }
        this.setLineFormattingState(i, inAsteriskFormat, inParenthesisFormat);
    }

    private String hideMacrosInLine(String line) {
        if (line == null || line.isEmpty()) {
            return line;
        }
        StringBuilder result = new StringBuilder();
        int braceDepth = 0;
        boolean inMacro = false;
        boolean skipMode = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (!inMacro) {
                if (c == '{' && i + 1 < line.length() && line.charAt(i + 1) == '{') {
                    inMacro = true;
                    braceDepth = 2;
                    skipMode = true;
                    ++i;
                    continue;
                }
                result.append(c);
                continue;
            }
            if (c == '}') {
                if (--braceDepth != 0) continue;
                inMacro = false;
                skipMode = false;
                continue;
            }
            if (c == '{') {
                ++braceDepth;
                continue;
            }
            if (skipMode) continue;
            result.append(c);
        }
        return result.toString();
    }

    public String makeColoredTextItalic(String text) {
        if (((Boolean)ArichatClassic.asteriskItalic.get()).booleanValue() && text != null) {
            return "\u00a7o" + text;
        }
        return text;
    }

    private int findNextUnescapedParenthesis(String str, int start, char parenthesis) {
        boolean escaped = false;
        for (int i = start; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != parenthesis) continue;
            return i;
        }
        return -1;
    }

    private boolean isLineContinuingAsteriskFormat(int lineIndex) {
        if (lineIndex < this.asteriskFormatState.length) {
            return this.asteriskFormatState[lineIndex];
        }
        return false;
    }

    private boolean isLineContinuingParenthesisFormat(int lineIndex) {
        if (lineIndex < this.parenthesisFormatState.length) {
            return this.parenthesisFormatState[lineIndex];
        }
        return false;
    }

    private void setLineFormattingState(int lineIndex, boolean asteriskState, boolean parenthesisState) {
        if (lineIndex >= this.asteriskFormatState.length) {
            boolean[] newAsteriskState = new boolean[lineIndex + 1];
            boolean[] newParenthesisState = new boolean[lineIndex + 1];
            System.arraycopy(this.asteriskFormatState, 0, newAsteriskState, 0, this.asteriskFormatState.length);
            System.arraycopy(this.parenthesisFormatState, 0, newParenthesisState, 0, this.parenthesisFormatState.length);
            this.asteriskFormatState = newAsteriskState;
            this.parenthesisFormatState = newParenthesisState;
        }
        this.asteriskFormatState[lineIndex] = asteriskState;
        this.parenthesisFormatState[lineIndex] = parenthesisState;
    }

    public void setText(String text) {
        this.text.clear();
        this.asteriskFormatState = new boolean[0];
        this.parenthesisFormatState = new boolean[0];
        for (String line : text.split("\n")) {
            String processedLine = line.replaceAll("^\\s+", "");
            if (!processedLine.isEmpty()) {
                int firstLetterIndex = -1;
                for (int i = 0; i < processedLine.length(); ++i) {
                    if (!Character.isLetter(processedLine.charAt(i))) continue;
                    firstLetterIndex = i;
                    break;
                }
                if (firstLetterIndex != -1) {
                    String beforeFirstLetter = processedLine.substring(0, firstLetterIndex);
                    String firstLetter = String.valueOf(processedLine.charAt(firstLetterIndex));
                    String afterFirstLetter = processedLine.substring(firstLetterIndex + 1);
                    processedLine = beforeFirstLetter + firstLetter.toUpperCase() + afterFirstLetter;
                }
            }
            this.text.add(this.createTextLine(processedLine));
        }
        this.cursor.set(0, 0);
        this.selection.set(-1, 0);
        this.recalculate();
        this.recalculateSizes();
        if (this.alternatives.isEmpty()) {
            this.alternatives.add(text);
        }
        this.currentAlternativeIndex = 0;
    }

    public String getText(Cursor a, Cursor b) {
        StringJoiner joiner = new StringJoiner("\n");
        Cursor min = a.isThisLessTo(b) ? a : b;
        Cursor max = a.isThisLessTo(b) ? b : a;
        for (int i = min.line; i <= Math.min(max.line, this.text.size() - 1); ++i) {
            String line = ((TextLine)this.text.get((int)i)).text;
            if (i == min.line && i == max.line) {
                joiner.add(line.substring(min.getOffset(line), max.getOffset(line)));
                continue;
            }
            if (i == min.line) {
                joiner.add(min.end(line));
                continue;
            }
            if (i == max.line) {
                joiner.add(max.start(line));
                continue;
            }
            joiner.add(line);
        }
        return joiner.toString();
    }

    public boolean selectGroup(int direction, boolean select) {
        List<Cursor> groups = this.findGroup(direction, this.cursor);
        if (groups.isEmpty()) {
            return false;
        }
        Cursor min = groups.get(0);
        Cursor max = groups.get(1);
        if (select) {
            if (direction == 0) {
                this.cursor.offset = max.offset;
                this.selection.set(this.cursor.line, min.offset);
            } else {
                if (!this.isSelected()) {
                    this.selection.copy(this.cursor);
                }
                this.cursor.offset = direction < 0 ? min.offset : max.offset;
            }
        } else {
            this.deselect();
            this.cursor.offset = direction < 0 ? min.offset : max.offset;
        }
        return true;
    }

    public int measureGroup(int direction, Cursor cursor) {
        if (direction == 0) {
            return 0;
        }
        List<Cursor> group = this.findGroup(direction, cursor);
        if (group.isEmpty()) {
            return 0;
        }
        Cursor other = group.get(direction < 0 ? 0 : 1);
        return other.offset - cursor.offset;
    }

    public List<Cursor> findGroup(int direction, Cursor cursor) {
        int min;
        String line = ((TextLine)this.text.get((int)cursor.line)).text;
        if (line.isEmpty() || this.cursor.offset >= line.length() - 1) {
            return Collections.emptyList();
        }
        int offset = cursor.offset;
        int first = direction < 0 && offset > 0 ? offset - 1 : offset;
        String character = String.valueOf(line.charAt(first));
        StringGroup group = StringGroup.get((String)character);
        int max = offset;
        this.lastGroup = null;
        if (direction <= 0) {
            for (min = offset; min > 0 && this.matchSelectGroup(group, String.valueOf(line.charAt(min - 1))); --min) {
            }
        }
        this.lastGroup = null;
        if (direction >= 0) {
            while (max < line.length() && this.matchSelectGroup(group, String.valueOf(line.charAt(max)))) {
                ++max;
            }
        }
        return ImmutableList.of((Object)new Cursor(cursor.line, min), (Object)new Cursor(cursor.line, max));
    }

    private boolean matchSelectGroup(StringGroup group, String character) {
        if (group.match(character)) {
            return this.lastGroup == null;
        }
        if (group == StringGroup.SPACE) {
            if (this.lastGroup == null) {
                this.lastGroup = StringGroup.get((String)character);
            }
            return StringGroup.get((String)character) == this.lastGroup;
        }
        return false;
    }

    public void checkSelection(boolean selecting) {
        if (selecting && !this.isSelected()) {
            this.startSelecting();
        } else if (!selecting && this.isSelected()) {
            this.deselect();
        }
    }

    public void clear() {
        if (!this.text.isEmpty()) {
            this.setText("");
        }
    }

    protected void changedLine(int i) {
        this.calculateWrappedLine((TextLine)this.text.get(i));
        this.recalculateSizes();
        this._parentResize();
    }

    protected void changedLineAfter(int i) {
        while (i < this.text.size()) {
            this.calculateWrappedLine((TextLine)this.text.get(i));
            ++i;
        }
        this.recalculateSizes();
        this._parentResize();
    }

    public void writeNewLine() {
        if (!this.hasLine(this.cursor.line)) {
            return;
        }
        String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
        if (this.cursor.offset == 0 || line.isEmpty()) {
            this.text.add(this.cursor.line, this.createTextLine(""));
        } else if (this.cursor.offset >= line.length()) {
            this.text.add(this.cursor.line + 1, this.createTextLine(""));
        } else {
            ((TextLine)this.text.get(this.cursor.line)).set(this.cursor.start(line));
            this.text.add(this.cursor.line + 1, this.createTextLine(this.cursor.end(line)));
            this.moveCursorToLineStart();
        }
        this.changedLineAfter(this.cursor.line);
        ++this.cursor.line;
        this.cursor.offset = 0;
    }

    public void writeCharacter(String character) {
        if (this.hasLine(this.cursor.line)) {
            int index = this.cursor.offset;
            String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
            line = index >= line.length() ? line + character : (index == 0 ? character + line : this.cursor.start(line) + character + this.cursor.end(line));
            ((TextLine)this.text.get(this.cursor.line)).set(line);
            this.changedLine(this.cursor.line);
        }
    }

    public void writeString(String string) {
        List<String> splits = GuiDialogTextElement.splitNewlineString(string);
        int size = splits.size();
        if (size == 1) {
            this.writeCharacter(string);
            this.cursor.offset += string.length();
        } else {
            int line = this.cursor.line;
            String remainder = this.cursor.end(((TextLine)this.text.get((int)line)).text);
            ((TextLine)this.text.get(line)).set(this.cursor.start(((TextLine)this.text.get((int)line)).text));
            for (int i = 0; i < size; ++i) {
                if (i != 0 && i <= size - 1) {
                    ++this.cursor.line;
                    this.moveCursorToLineStart();
                    this.text.add(this.cursor.line, this.createTextLine(""));
                }
                this.writeCharacter(splits.get(i));
            }
            this.cursor.offset = splits.get(size - 1).length();
            this.writeCharacter(remainder);
            this.changedLineAfter(line);
        }
    }

    public void deleteSelection() {
        if (!this.isSelected()) {
            return;
        }
        Cursor min = this.getMin();
        Cursor max = this.getMax();
        if (min.line == max.line) {
            String line = ((TextLine)this.text.get((int)min.line)).text;
            if (min.offset <= 0 && max.offset >= line.length()) {
                ((TextLine)this.text.get(min.line)).set("");
            } else {
                ((TextLine)this.text.get(min.line)).set(min.start(line) + max.end(line));
            }
        } else {
            String end = "";
            for (int i = max.line; i >= min.line; --i) {
                String line = ((TextLine)this.text.get((int)i)).text;
                if (i == max.line) {
                    end = max.end(line);
                    this.text.remove(i);
                    continue;
                }
                if (i == min.line) {
                    ((TextLine)this.text.get(i)).set(min.start(line) + end);
                    continue;
                }
                this.text.remove(i);
            }
        }
        this.changedLineAfter(min.line);
        this.cursor.copy(min);
        this.deselect();
    }

    public boolean hasLine(int line) {
        return line >= 0 && line < this.text.size();
    }

    public Cursor getMin() {
        return this.selection.isThisLessTo(this.cursor) ? this.selection : this.cursor;
    }

    public Cursor getMax() {
        return this.selection.isThisLessTo(this.cursor) ? this.cursor : this.selection;
    }

    public void moveCursor(int x, int y) {
        this.moveCursor(x, y, true);
    }

    public void moveCursor(int x, int y, boolean jumpLine) {
        int ny;
        if (!this.hasLine(this.cursor.line)) {
            return;
        }
        String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
        if (x != 0) {
            int nx = this.cursor.offset + (x > 0 ? 1 : -1);
            if (nx < 0) {
                if (jumpLine) {
                    if (this.hasLine(this.cursor.line - 1)) {
                        --this.cursor.line;
                        this.moveCursorToLineEnd();
                    }
                } else {
                    this.moveCursorToLineStart();
                }
            } else if (nx > line.length()) {
                if (jumpLine) {
                    if (this.hasLine(this.cursor.line + 1)) {
                        ++this.cursor.line;
                        this.moveCursorToLineStart();
                    }
                } else {
                    this.moveCursorToLineEnd();
                }
            } else {
                this.cursor.offset = nx;
            }
        }
        if (y != 0 && this.hasLine(ny = this.cursor.line + (y > 0 ? 1 : -1))) {
            this.cursor.line = ny;
            this.cursor.offset = MathUtils.clamp((int)this.cursor.offset, (int)0, (int)((TextLine)this.text.get((int)this.cursor.line)).text.length());
        }
    }

    public void moveCursorToLineStart() {
        this.cursor.offset = 0;
    }

    public void moveCursorToLineEnd() {
        if (this.hasLine(this.cursor.line)) {
            this.cursor.offset = ((TextLine)this.text.get((int)this.cursor.line)).text.length();
        }
    }

    public void moveCursorTo(Cursor cursor, int x, int y) {
        x -= this.area.x + this.padding;
        y -= this.area.y + this.padding;
        if (this.wrapping) {
            this.moveToCursorWrapped(cursor, x, y);
        } else {
            this.moveCursorToUnwrapped(cursor, x, y);
        }
    }

    private void moveToCursorWrapped(Cursor cursor, int x, int y) {
        if (this.text.isEmpty()) {
            return;
        }
        TextLine current = null;
        int line = y < 0 ? 0 : y / this.lineHeight;
        int l = 0;
        int s = 0;
        int c = this.text.size();
        for (int i = 0; i < c; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            if (line >= l && line < l + textLine.getLines()) {
                current = textLine;
                cursor.line = i;
                s = line - l;
                break;
            }
            l += textLine.getLines();
        }
        if (current == null) {
            current = (TextLine)this.text.get(this.text.size() - 1);
            cursor.line = this.text.size() - 1;
            s = current.getLines() - 1;
        }
        cursor.offset = 0;
        String lineText = current.text;
        if (current.wrappedLines != null) {
            for (int i = 0; i < s; ++i) {
                cursor.offset += current.wrappedLines.get(i).length();
            }
            lineText = current.wrappedLines.get(s);
        }
        int w = 0;
        if (x > this.font.func_78256_a(lineText)) {
            cursor.offset += lineText.length();
            return;
        }
        if (x < 0) {
            return;
        }
        int i = 0;
        while (x > w) {
            w = this.font.func_78256_a(lineText.substring(0, i));
            ++cursor.offset;
            ++i;
        }
        if (cursor.offset > 0) {
            cursor.offset -= 2;
        }
    }

    private void moveCursorToUnwrapped(Cursor cursor, int x, int y) {
        cursor.line = MathUtils.clamp((int)(y / this.lineHeight), (int)0, (int)(this.text.size() - 1));
        String line = ((TextLine)this.text.get((int)cursor.line)).text;
        int w = this.font.func_78256_a(line);
        if (x <= 0) {
            this.moveCursorToLineStart();
        } else if (x > w) {
            this.moveCursorToLineEnd();
        } else {
            cursor.offset = 0;
            w = this.font.func_78256_a(cursor.start(line));
            while (x > w) {
                w = this.font.func_78256_a(cursor.start(line, 1));
                ++cursor.offset;
            }
            if (cursor.offset > 0) {
                --cursor.offset;
            }
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void focus(GuiContext context) {
        this.focused = true;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void unfocus(GuiContext context) {
        this.focused = false;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void unfocus() {
        this.focused = false;
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void selectAll(GuiContext context) {
        this.selectAll();
    }

    public void unselect(GuiContext context) {
        this.deselect();
    }

    public void resize() {
        int oldHeight = this.area.h;
        this.recalculateSizes();
        super.resize();
        if (oldHeight != this.area.h && this.parent != null && this.parent instanceof GuiScrollElement) {
            ((GuiScrollElement)this.parent).updateContentSize();
        }
    }

    public void recalculate() {
        for (TextLine textLine : this.text) {
            this.calculateWrappedLine(textLine);
        }
        this.recalculateSizes();
    }

    protected void recalculateWrapping() {
        if (this.wrapping) {
            for (TextLine textLine : this.text) {
                this.calculateWrappedLine(textLine);
            }
        }
    }

    protected void calculateWrappedLine(T textLine) {
        if (this.wrapping) {
            ((TextLine)textLine).calculateWrappedLines(this.font, this.getWrappedWidth());
        } else {
            ((TextLine)textLine).resetWrapping();
        }
    }

    protected void recalculateSizes() {
        int h = 0;
        for (TextLine textLine : this.text) {
            h += textLine.getLines() * this.lineHeight;
        }
        int oldHeight = this.area.h;
        this.area.h = this.totalHeight = h + this.padding * 3 + Math.round((float)this.lineHeight * this.underPadding);
        if (oldHeight != this.totalHeight) {
            this.needsSizeUpdate = true;
        }
    }

    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        if (!this.editable) {
            return false;
        }
        boolean wasFocused = this.focused;
        boolean shift = GuiScreen.func_146272_n();
        this.focused = this.area.isInside(context);
        if (this.focused) {
            if (context.mouseButton == 0) {
                if (System.currentTimeMillis() < this.lastClick) {
                    this.selectGroup(0, true);
                    this.lastClick -= 500L;
                } else {
                    if (!shift) {
                        this.deselect();
                        this.dragging = 1;
                    } else if (!this.isSelected()) {
                        this.startSelecting();
                    }
                    this.moveCursorTo(this.cursor, context.mouseX, context.mouseY);
                    this.lastClick = System.currentTimeMillis() + 200L;
                }
            }
            this.lastMX = context.mouseX;
            this.lastMY = context.mouseY;
        }
        if (wasFocused != this.focused) {
            context.focus((IFocusedGuiElement)(wasFocused ? null : this));
        }
        return this.focused;
    }

    public void mouseReleased(GuiContext context) {
        super.mouseReleased(context);
        this.dragging = 0;
    }

    public boolean keyTyped(GuiContext context) {
        boolean shift;
        if (super.keyTyped(context)) {
            return true;
        }
        if (!this.editable) {
            return false;
        }
        if (!this.focused) {
            return false;
        }
        if (context.keyCode == 1) {
            context.unfocus();
            return true;
        }
        boolean ctrl = GuiScreen.func_146271_m();
        if (this.handleKeys(context, ctrl, shift = GuiScreen.func_146272_n())) {
            // empty if block
        }
        this.update = context.tick + 20L;
        return false;
    }

    protected void keyNewLine() {
        this.deleteSelection();
        this.deselect();
        this.writeNewLine();
    }

    protected boolean handleKeys(GuiContext context, boolean ctrl, boolean shift) {
        if (ctrl && context.keyCode == 30) {
            this.selectAll();
        } else {
            if (context.keyCode == 200 || context.keyCode == 208 || context.keyCode == 205 || context.keyCode == 203) {
                int y;
                int x;
                int n = context.keyCode == 205 ? 1 : (x = context.keyCode == 203 ? -1 : 0);
                int n2 = context.keyCode == 200 ? -1 : (y = context.keyCode == 208 ? 1 : 0);
                if (x != 0 && ctrl) {
                    if (!this.selectGroup(x, shift)) {
                        this.checkSelection(shift);
                        this.moveCursor(x, 0);
                    }
                } else {
                    this.checkSelection(shift);
                    this.moveCursor(x, y);
                }
                this.playSound(SoundEvents.field_187554_ai);
                return true;
            }
            if (context.keyCode == 199) {
                this.checkSelection(shift);
                this.moveCursorToLineStart();
                this.playSound(SoundEvents.field_187737_v);
                return true;
            }
            if (context.keyCode == 207) {
                this.checkSelection(shift);
                this.moveCursorToLineEnd();
                this.playSound(SoundEvents.field_187731_t);
                return true;
            }
            if (ctrl && (context.keyCode == 46 || context.keyCode == 45) && this.isSelected()) {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (context.keyCode == 45) {
                    this.deleteSelection();
                    this.deselect();
                    this.playSound(SoundEvents.field_187698_i);
                } else {
                    this.playSound(SoundEvents.field_187638_cR);
                }
                return context.keyCode == 45;
            }
            if (ctrl && context.keyCode == 47) {
                String pasted = GuiScreen.func_146277_j();
                this.deleteSelection();
                this.deselect();
                this.writeString(pasted);
                this.playSound(SoundEvents.field_187539_bB);
                return true;
            }
            if (ctrl && context.keyCode == 32) {
                this.deselect();
                String copy = ((TextLine)this.text.get((int)this.cursor.line)).text;
                this.moveCursorToLineEnd();
                this.writeNewLine();
                this.moveCursorToLineStart();
                this.writeString(copy);
                this.playSound(SoundEvents.field_187539_bB);
                return true;
            }
            if (context.keyCode == 15) {
                this.playSound(GuiScreen.func_146272_n() ? SoundEvents.field_187712_dQ : SoundEvents.field_187715_dR);
                return true;
            }
            if (ctrl && context.keyCode == 53) {
                String line;
                int i;
                Cursor min = new Cursor();
                Cursor max = new Cursor();
                if (this.isSelected()) {
                    min.copy(this.getMin());
                    max.copy(this.getMax());
                } else {
                    min.copy(this.cursor);
                    max.copy(this.cursor);
                }
                int numCommentedLines = 0;
                int numUncommentedLines = 0;
                for (i = min.line; i <= max.line; ++i) {
                    line = ((TextLine)this.text.get((int)i)).text;
                    if (line.startsWith("//")) {
                        ++numCommentedLines;
                        continue;
                    }
                    ++numUncommentedLines;
                }
                for (i = min.line; i <= max.line; ++i) {
                    line = ((TextLine)this.text.get((int)i)).text;
                    if (numUncommentedLines == 0 && numCommentedLines > 0) {
                        if (!line.startsWith("//")) continue;
                        ((TextLine)this.text.get(i)).set(line.substring(2));
                        continue;
                    }
                    if (numUncommentedLines <= 0 || line.startsWith("//")) continue;
                    ((TextLine)this.text.get(i)).set("//" + line);
                }
                if (this.isSelected()) {
                    String selected = this.getSelectedText();
                    this.deleteSelection();
                    this.writeString(selected);
                } else {
                    String currentLine = ((TextLine)this.text.get((int)this.cursor.line)).text;
                    ((TextLine)this.text.get(this.cursor.line)).set("");
                    this.writeString(currentLine);
                }
                this.changedLineAfter(min.line);
                this.playSound(SoundEvents.field_187654_U);
                return true;
            }
            if (context.keyCode == 28) {
                if (ctrl) {
                    this.keyNewLine();
                    return true;
                }
                if (this.enterCallback) {
                    if (this.callback != null) {
                        this.callback.accept(this.getText());
                    }
                    return true;
                }
            } else {
                if (context.keyCode == 14 || context.keyCode == 211) {
                    boolean delete;
                    boolean bl = delete = context.keyCode == 211;
                    if (this.isSelected()) {
                        this.deleteSelection();
                        this.deselect();
                        this.playSound(SoundEvents.field_187539_bB);
                    } else {
                        String text = ((TextLine)this.text.get((int)this.cursor.line)).text;
                        if (delete) {
                            int measure = ctrl ? Math.max(this.measureGroup(1, this.cursor), 1) : 1;
                            for (int i = 0; i < measure; ++i) {
                                this.moveCursor(1, 0);
                            }
                        } else {
                            this.keyBackspace(text, ctrl);
                        }
                        this.playSound(SoundEvents.field_187835_fT);
                    }
                    return true;
                }
                if (ChatAllowedCharacters.func_71566_a((char)context.typedChar)) {
                    String character = this.getFromChar(context.typedChar);
                    if (!character.isEmpty()) {
                        this.deleteSelection();
                        this.deselect();
                        this.writeCharacter(character);
                        this.moveCursor(1, 0);
                        this.playSound(SoundEvents.field_187845_fY);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void keyBackspace(String string, boolean ctrl) {
        int measure = ctrl ? Math.max(Math.abs(this.measureGroup(-1, this.cursor)), 1) : 1;
        for (int i = 0; i < measure; ++i) {
            string = this.deleteCharacter();
        }
    }

    public String deleteCharacter() {
        if (this.hasLine(this.cursor.line)) {
            String line = ((TextLine)this.text.get((int)this.cursor.line)).text;
            int index = Math.min(this.cursor.offset, line.length());
            if (line.isEmpty()) {
                if (this.cursor.line > 0) {
                    this.text.remove(this.cursor.line);
                    --this.cursor.line;
                    this.moveCursorToLineEnd();
                    this.changedLineAfter(this.cursor.line);
                    return "\n";
                }
            } else {
                if (index >= line.length()) {
                    String deleted = line.substring(line.length() - 1);
                    line = line.substring(0, line.length() - 1);
                    ((TextLine)this.text.get(this.cursor.line)).set(line);
                    this.moveCursorToLineEnd();
                    this.changedLine(this.cursor.line);
                    return deleted;
                }
                if (index == 0) {
                    if (this.cursor.line > 0) {
                        String text = ((TextLine)this.text.remove((int)this.cursor.line)).text;
                        --this.cursor.line;
                        this.moveCursorToLineEnd();
                        ((TextLine)this.text.get((int)this.cursor.line)).text = ((TextLine)this.text.get((int)this.cursor.line)).text + text;
                        this.changedLineAfter(this.cursor.line);
                        return "\n";
                    }
                } else {
                    String deleted = line.substring(this.cursor.getOffset(line, -1), this.cursor.getOffset(line));
                    ((TextLine)this.text.get((int)this.cursor.line)).text = line = this.cursor.start(line, -1) + this.cursor.end(line);
                    this.moveCursor(-1, 0);
                    this.changedLine(this.cursor.line);
                    return deleted;
                }
            }
        }
        return "";
    }

    protected void playSound(SoundEvent event) {
        GuiMappetUtils.playSound((SoundEvent)event);
    }

    protected String getFromChar(char typedChar) {
        return String.valueOf(typedChar);
    }

    public static void drawCustomBackground(int x, int y, int width, int height) {
        ResourceLocation background = McLib.backgroundImage.get();
        int color = (Integer)McLib.primaryColor.get();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (background == null) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(background);
            ColorUtils.bindColor((int)color);
            GlStateManager.func_179141_d();
            GuiDraw.drawBillboard((int)x, (int)y, (int)0, (int)0, (int)width, (int)height, (int)width, (int)height);
        }
    }

    public void draw(GuiContext context) {
        this.handleLogic(context);
        int n = this.textColor = this.area.isInside(context) ? this.hover : this.color;
        if (this.editingChatMod && ClientProxy.haveAIInDialog) {
            if (this.area.isInside(context)) {
                this.editPanel.setVisible(true);
                this.editPanel.area.x = this.area.ex() - this.editPanel.area.w - 5;
                this.editPanel.area.y = this.area.y + 5;
                this.editPanel.resize();
                if (!this.editPanel.getChildren().isEmpty()) {
                    GuiDialogTextElement.drawCustomBackground(this.editPanel.area.getX(), this.editPanel.area.getY(), this.editPanel.getChildren().size() * 20, this.editPanel.area.getH());
                }
                this.editPanel.area.draw(305481267);
            } else {
                this.editPanel.setVisible(false);
            }
        }
        if (this.background) {
            this.drawBackground();
        }
        super.draw(context);
        GuiDraw.scissor((int)this.area.x, (int)this.area.y, (int)(this.area.w * 2), (int)this.area.h, (GuiContext)context);
        int x = this.area.x + this.padding;
        int y = this.area.y + this.padding;
        Cursor min = this.getMin();
        Cursor max = this.getMax();
        if (this.isSelected()) {
            this.drawSelectionBar(x, y, min, max);
        }
        int ci = this.text.size();
        for (int i = 0; i < ci; ++i) {
            int lines;
            boolean drawCursor;
            int newY;
            TextLine textLine = (TextLine)this.text.get(i);
            String line = textLine.text;
            int newX = x + this.getShiftX();
            if (this.arrow) {
                newX += 7;
            }
            if ((newY = y) > this.area.ey()) break;
            boolean bl = drawCursor = this.cursor.line == i;
            if (!this.alwaysCursor) {
                boolean bl2 = drawCursor = drawCursor && this.focused;
            }
            if (newY + this.font.field_78288_b + (lines = textLine.getLines() - 1) * this.lineHeight >= this.area.y) {
                int cursorW = 0;
                int cursorA = 0;
                if (drawCursor) {
                    cursorW = line.isEmpty() ? 0 : this.font.func_78256_a(this.cursor.start(line));
                    cursorA = (int)(Math.sin((double)((float)context.tick + context.partialTicks) / 2.0) * 127.5 + 127.5) << 24;
                }
                if (textLine.wrappedLines == null) {
                    if (drawCursor) {
                        Gui.func_73734_a((int)(newX + cursorW), (int)(newY - 1), (int)(newX + cursorW + 1), (int)(newY + this.font.field_78288_b + 1), (int)(cursorA + 0xFFFFFF));
                    }
                    this.drawTextLine(line, i, 0, newX, newY);
                    if (this.arrow) {
                        this.drawTextLine("> ", i, 0, x, y);
                    }
                } else {
                    int wrappedW = 0;
                    int cj = textLine.wrappedLines.size();
                    for (int j = 0; j < cj; ++j) {
                        String wrappedLine = textLine.wrappedLines.get(j);
                        int lineW = this.font.func_78256_a(wrappedLine);
                        int lineY = newY + j * this.lineHeight;
                        if ((cursorW >= wrappedW && cursorW < wrappedW + lineW || this.cursor.offset >= textLine.text.length()) && wrappedW != 0) {
                            Gui.func_73734_a((int)(newX + cursorW - wrappedW), (int)(lineY - 1), (int)(newX + cursorW - wrappedW + 1), (int)(lineY + this.font.field_78288_b + 1), (int)(cursorA + 0xFFFFFF));
                        }
                        this.drawTextLine(wrappedLine, i, j, newX, lineY);
                        wrappedW += lineW;
                    }
                }
            }
            y += textLine.getLines() * this.lineHeight;
        }
        this.drawForeground(context);
        GuiDraw.unscissor((GuiContext)context);
    }

    protected int getShiftX() {
        return 0;
    }

    private int findNextUnescapedStar(String str, int start) {
        boolean escaped = false;
        for (int i = start; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != '*') continue;
            return i;
        }
        return -1;
    }

    private void renderSegment(String text, int x, int y, int color) {
        this.font.func_175065_a(text, (float)x, (float)y, color, this.textShadow);
    }

    protected void drawBackground() {
        this.area.draw(-2013265920);
    }

    protected void drawForeground(GuiContext context) {
    }

    private void handleLogic(GuiContext context) {
        if (this.update > this.lastUpdate) {
            this.lastUpdate = this.update;
            if (!this.enterCallback && this.callback != null) {
                this.callback.accept(this.getText());
            }
        }
        if (this.dragging == 1 && (Math.abs(context.mouseX - this.lastMX) > 4 || Math.abs(context.mouseY - this.lastMY) > 4)) {
            this.startSelecting();
            this.dragging = 2;
        }
        if (this.focused && this.dragging == 2) {
            this.moveCursorTo(this.cursor, context.mouseX, context.mouseY);
        }
    }

    private void drawSelectionBar(int x, int y, Cursor min, Cursor max) {
        Vector2d minPos = this.getCursorPosition(min);
        Vector2d maxPos = this.getCursorPosition(max);
        this.drawSelectionArea(x + (int)minPos.x, y + (int)minPos.y, x + (int)maxPos.x, y + (int)maxPos.y);
    }

    protected Vector2d getCursorPosition(Cursor cursor) {
        Vector2d pos = new Vector2d();
        if (this.wrapping) {
            this.getCusrorPositionWrapped(cursor, pos);
        } else {
            String line = ((TextLine)this.text.get((int)cursor.line)).text;
            pos.x = this.font.func_78256_a(cursor.start(line));
            pos.y = cursor.line * this.lineHeight;
        }
        pos.x += (double)this.getShiftX();
        return pos;
    }

    private void getCusrorPositionWrapped(Cursor cursor, Vector2d pos) {
        int lines = 0;
        int offset = 0;
        int c = this.text.size();
        for (int i = 0; i < c; ++i) {
            TextLine textLine = (TextLine)this.text.get(i);
            int textLines = textLine.getLines();
            if (i == cursor.line) {
                if (textLine.wrappedLines == null) {
                    offset = this.font.func_78256_a(cursor.start(textLine.text));
                    break;
                }
                int textOffset = 0;
                for (int j = 0; j < textLine.wrappedLines.size(); ++j) {
                    String wrappedLine = textLine.wrappedLines.get(j);
                    if (cursor.offset >= textOffset && cursor.offset < textOffset + wrappedLine.length()) {
                        offset = this.font.func_78256_a(wrappedLine.substring(0, cursor.offset - textOffset));
                        break;
                    }
                    ++lines;
                    textOffset += wrappedLine.length();
                }
                if (cursor.offset < textLine.text.length()) break;
                --lines;
                offset = this.font.func_78256_a(textLine.wrappedLines.get(textLine.wrappedLines.size() - 1));
                break;
            }
            lines += textLines;
        }
        pos.x = offset;
        pos.y = lines * this.lineHeight;
    }

    private void drawSelectionArea(int x1, int y1, int x2, int y2) {
        int endY;
        int selectionPad = 2;
        int color = -2013265920 + (Integer)McLib.primaryColor.get();
        boolean middle = y2 > y1 + this.lineHeight;
        boolean bottom = y2 > y1;
        int endX = bottom || middle ? this.area.ex() : x2 + 2;
        int n = endY = bottom && !middle ? y2 : y1 + this.font.field_78288_b;
        if (!bottom && !middle) {
            endY += 2;
        }
        Gui.func_73734_a((int)(x1 - 2), (int)(y1 - 2), (int)endX, (int)endY, (int)color);
        if (middle) {
            Gui.func_73734_a((int)this.area.x, (int)(y1 + this.font.field_78288_b), (int)this.area.ex(), (int)y2, (int)color);
        }
        if (bottom) {
            Gui.func_73734_a((int)this.area.x, (int)y2, (int)(x2 + 2), (int)(y2 + this.font.field_78288_b + 2), (int)color);
        }
    }

    public GuiDialogTextElement<T> callback(Consumer<String> callback) {
        this.callback = callback;
        return this;
    }

    public static enum ElementType {
        REACTION,
        ANSWER,
        AI_REACTION;

    }
}

