/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.network.common.dialogue;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.dialogues.DialogueFragment;
import mchorse.mappet.api.dialogues.DialogueInputFragment;
import mchorse.mappet.api.quests.chains.QuestContext;
import mchorse.mappet.api.quests.chains.QuestInfo;
import mchorse.mclib.utils.NBTUtils;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketDialogueFragment
implements IMessage {
    public String title = "";
    public boolean closable;
    public AbstractMorph morph;
    public DialogueFragment reaction = new DialogueFragment();
    public List<DialogueFragment> replies = new ArrayList<DialogueFragment>();
    public CraftingTable table;
    public boolean hasQuests;
    public boolean singleQuest;
    public List<QuestInfo> quests = new ArrayList<QuestInfo>();
    public boolean replyShow = true;

    public PacketDialogueFragment() {
    }

    public PacketDialogueFragment(boolean closable, DialogueFragment reaction, List<DialogueFragment> replies) {
        this.closable = closable;
        this.reaction = reaction;
        this.replies = replies;
    }

    public void addMorph(AbstractMorph morph) {
        this.morph = morph;
    }

    public void addCraftingTable(CraftingTable table) {
        this.table = table;
    }

    public void addQuests(QuestContext context) {
        this.hasQuests = true;
        this.quests.addAll(context.quests);
    }

    public void addQuest(QuestInfo questInfo) {
        this.hasQuests = true;
        this.singleQuest = true;
        this.quests.add(questInfo);
    }

    public void showReplies(boolean show) {
        this.replyShow = show;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.title = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.closable = buf.readBoolean();
        this.morph = MorphUtils.morphFromBuf((ByteBuf)buf);
        this.reaction.deserializeNBT(NBTUtils.readInfiniteTag((ByteBuf)buf));
        int c = buf.readInt();
        for (i = 0; i < c; ++i) {
            DialogueFragment fragment;
            NBTTagCompound tag = NBTUtils.readInfiniteTag((ByteBuf)buf);
            if (tag.func_74764_b("input")) {
                fragment = new DialogueInputFragment();
                ((DialogueInputFragment)fragment).deserializeNBT(tag);
                this.replies.add(fragment);
                continue;
            }
            fragment = new DialogueFragment();
            fragment.deserializeNBT(tag);
            this.replies.add(fragment);
        }
        if (buf.readBoolean()) {
            String id = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.table = (CraftingTable)Mappet.crafting.create(id, NBTUtils.readInfiniteTag((ByteBuf)buf));
        }
        this.hasQuests = buf.readBoolean();
        this.singleQuest = buf.readBoolean();
        c = buf.readInt();
        for (i = 0; i < c; ++i) {
            QuestInfo info = new QuestInfo();
            info.fromBytes(buf);
            this.quests.add(info);
        }
        this.replyShow = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.title);
        buf.writeBoolean(this.closable);
        MorphUtils.morphToBuf((ByteBuf)buf, (AbstractMorph)this.morph);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.reaction.serializeNBT());
        buf.writeInt(this.replies.size());
        for (DialogueFragment fragment : this.replies) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)fragment.serializeNBT());
        }
        buf.writeBoolean(this.table != null);
        if (this.table != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.table.getId());
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.table.serializeNBT());
        }
        buf.writeBoolean(this.hasQuests);
        buf.writeBoolean(this.singleQuest);
        buf.writeInt(this.quests.size());
        for (QuestInfo info : this.quests) {
            info.toBytes(buf);
        }
        buf.writeBoolean(this.replyShow);
    }

    public boolean isEmpty() {
        return this.replies.isEmpty() && !this.hasQuests && this.table == null;
    }
}

