/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.keyframes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeElement;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiKeyframeInterpolationsList;
import mchorse.mclib.client.gui.framework.elements.keyframes.GuiSheet;
import mchorse.mclib.client.gui.framework.elements.keyframes.IAxisConverter;
import mchorse.mclib.client.gui.framework.elements.keyframes.Selection;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.tooltips.InterpolationTooltip;
import mchorse.mclib.client.gui.utils.GuiUtils;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.MathUtils;
import mchorse.mclib.utils.keyframes.Keyframe;
import mchorse.mclib.utils.keyframes.KeyframeEasing;
import mchorse.mclib.utils.keyframes.KeyframeInterpolation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class GuiKeyframesEditor<T extends GuiKeyframeElement>
extends GuiElement {
    public GuiElement frameButtons;
    public GuiTrackpadElement tick;
    public GuiTrackpadElement value;
    public GuiButtonElement interp;
    public GuiListElement<KeyframeInterpolation> interpolations;
    public GuiCirculateElement easing;
    public T graph;
    private int clicks;
    private long clickTimer;
    private IAxisConverter converter;

    public GuiKeyframesEditor(Minecraft mc) {
        super(mc);
        InterpolationTooltip tooltip = new InterpolationTooltip(0.0f, 0.0f, () -> {
            Keyframe keyframe = ((GuiKeyframeElement)this.graph).getCurrent();
            if (keyframe == null) {
                return null;
            }
            return keyframe.interp.from(keyframe.easing);
        }, null);
        this.frameButtons = new GuiElement(mc);
        this.frameButtons.flex().relative(this).x(1.0f, -10).y(10).w(170).h(50).anchorX(1.0f);
        this.frameButtons.setVisible(false);
        this.tick = new GuiTrackpadElement(mc, this::setTick);
        this.tick.limit(-2.147483648E9, 2.147483647E9, true).tooltip(IKey.lang("mclib.gui.keyframes.tick"));
        this.value = new GuiTrackpadElement(mc, this::setValue);
        this.value.tooltip(IKey.lang("mclib.gui.keyframes.value"));
        this.interp = new GuiButtonElement(mc, IKey.lang(""), b -> this.interpolations.toggleVisible());
        this.interp.tooltip(tooltip);
        this.interpolations = new GuiKeyframeInterpolationsList(mc, interp -> this.pickInterpolation((KeyframeInterpolation)((Object)((Object)interp.get(0)))));
        this.interpolations.tooltip(tooltip).setVisible(false);
        this.easing = new GuiCirculateElement(mc, b -> this.changeEasing());
        this.easing.tooltip(tooltip);
        for (KeyframeEasing easing : KeyframeEasing.values()) {
            this.easing.addLabel(IKey.lang(easing.getKey()));
        }
        this.graph = this.createElement(mc);
        this.tick.flex().relative(this).set(0.0f, 10.0f, 80.0f, 20.0f).x(1.0f, -90);
        this.value.flex().relative(this).set(0.0f, 35.0f, 80.0f, 20.0f).x(1.0f, -90);
        this.interp.flex().relative(this.tick).set(-90.0f, 0.0f, 80.0f, 20.0f);
        this.easing.flex().relative(this.value).set(-90.0f, 0.0f, 80.0f, 20.0f);
        this.interpolations.flex().relative(this).set(0.0f, 30.0f, 80.0f, 20.0f).x(1.0f, -180).h(1.0f, -30).maxH(112);
        ((GuiElement)this.graph).flex().relative(this).set(0.0f, 0.0f, 0.0f, 0.0f).w(1.0f, 0).h(1.0f, 0);
        this.add(new IGuiElement[]{this.graph, this.frameButtons});
        this.frameButtons.add(this.tick, this.value, this.interp, this.easing, this.interpolations);
        this.keys().register(IKey.lang("mclib.gui.keyframes.context.maximize"), 199, this::resetView).inside();
        this.keys().register(IKey.lang("mclib.gui.keyframes.context.select_all"), 30, this::selectAll).held(29).inside();
    }

    protected abstract T createElement(Minecraft var1);

    protected void toggleInterpolation() {
        Keyframe keyframe = ((GuiKeyframeElement)this.graph).getCurrent();
        if (keyframe == null) {
            return;
        }
        KeyframeInterpolation interp = keyframe.interp;
        int factor = GuiScreen.func_146272_n() ? -1 : 1;
        int index = MathUtils.cycler(interp.ordinal() + factor, 0, KeyframeInterpolation.values().length - 1);
        this.pickInterpolation(KeyframeInterpolation.values()[index]);
        this.interpolations.setCurrent(interp);
        GuiUtils.playClick();
    }

    protected void toggleEasing() {
        this.easing.clickItself(GuiBase.getCurrent(), GuiScreen.func_146272_n() ? 1 : 0);
    }

    public void setConverter(IAxisConverter converter) {
        this.converter = converter;
        ((GuiKeyframeElement)this.graph).setConverter(converter);
        if (converter != null) {
            converter.updateField(this.tick);
        }
        this.fillData(((GuiKeyframeElement)this.graph).getCurrent());
    }

    @Override
    public boolean mouseClicked(GuiContext context) {
        if (super.mouseClicked(context)) {
            return true;
        }
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.area.isInside(mouseX, mouseY) && context.mouseButton == 0) {
            long time = System.currentTimeMillis();
            if (time - this.clickTimer < 175L) {
                ++this.clicks;
                if (this.clicks >= 1) {
                    this.clicks = 0;
                    this.doubleClick(mouseX, mouseY);
                }
            } else {
                this.clicks = 0;
            }
            this.clickTimer = time;
        }
        return this.area.isInside(mouseX, mouseY);
    }

    @Override
    public GuiContextMenu createContextMenu(GuiContext context) {
        Map<String, List<Keyframe>> pasted;
        GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc);
        menu.action(Icons.MAXIMIZE, IKey.lang("mclib.gui.keyframes.context.maximize"), this::resetView);
        menu.action(Icons.FULLSCREEN, IKey.lang("mclib.gui.keyframes.context.select_all"), this::selectAll);
        if (((GuiKeyframeElement)this.graph).which != Selection.NOT_SELECTED) {
            menu.action(Icons.REMOVE, IKey.lang("mclib.gui.keyframes.context.remove"), this::removeSelectedKeyframes);
            menu.action(Icons.COPY, IKey.lang("mclib.gui.keyframes.context.copy"), this::copyKeyframes);
        }
        if ((pasted = this.parseKeyframes()) != null) {
            Map<String, List<Keyframe>> keyframes = pasted;
            double offset = ((GuiKeyframeElement)this.graph).scaleX.from(context.mouseX);
            int mouseY = context.mouseY;
            menu.action(Icons.PASTE, IKey.lang("mclib.gui.keyframes.context.paste"), () -> this.pasteKeyframes(keyframes, (long)offset, mouseY));
        }
        if (((GuiKeyframeElement)this.graph).which != Selection.NOT_SELECTED && ((GuiKeyframeElement)this.graph).isMultipleSelected()) {
            menu.action(Icons.LEFT_HANDLE, IKey.lang("mclib.gui.keyframes.context.to_left"), () -> {
                ((GuiKeyframeElement)this.graph).which = Selection.LEFT_HANDLE;
            });
            menu.action(Icons.MAIN_HANDLE, IKey.lang("mclib.gui.keyframes.context.to_main"), () -> {
                ((GuiKeyframeElement)this.graph).which = Selection.KEYFRAME;
            });
            menu.action(Icons.RIGHT_HANDLE, IKey.lang("mclib.gui.keyframes.context.to_right"), () -> {
                ((GuiKeyframeElement)this.graph).which = Selection.RIGHT_HANDLE;
            });
        }
        return menu;
    }

    private Map<String, List<Keyframe>> parseKeyframes() {
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
            HashMap<String, List<Keyframe>> temp = new HashMap<String, List<Keyframe>>();
            for (String key : tag.func_150296_c()) {
                NBTTagList list = tag.func_150295_c(key, 10);
                int c = list.func_74745_c();
                for (int i = 0; i < c; ++i) {
                    ArrayList<Keyframe> keyframes = (ArrayList<Keyframe>)temp.get(key);
                    if (keyframes == null) {
                        keyframes = new ArrayList<Keyframe>();
                        temp.put(key, keyframes);
                    }
                    Keyframe keyframe = new Keyframe();
                    keyframe.fromNBT(list.func_150305_b(i));
                    keyframes.add(keyframe);
                }
            }
            if (!temp.isEmpty()) {
                return temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void copyKeyframes() {
        NBTTagCompound keyframes = new NBTTagCompound();
        for (GuiSheet sheet : ((GuiKeyframeElement)this.graph).getSheets()) {
            int c = sheet.getSelectedCount();
            if (c <= 0) continue;
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < c; ++i) {
                Keyframe keyframe = sheet.channel.get(sheet.selected.get(i));
                list.func_74742_a((NBTBase)keyframe.toNBT());
            }
            if (list.func_74745_c() <= 0) continue;
            keyframes.func_74782_a(sheet.id, (NBTBase)list);
        }
        GuiScreen.func_146275_d((String)keyframes.toString());
    }

    protected void pasteKeyframes(Map<String, List<Keyframe>> keyframes, long offset, int mouseY) {
        List<GuiSheet> sheets = ((GuiKeyframeElement)this.graph).getSheets();
        ((GuiKeyframeElement)this.graph).clearSelection();
        if (keyframes.size() == 1) {
            GuiSheet current = ((GuiKeyframeElement)this.graph).getSheet(mouseY);
            if (current == null) {
                current = sheets.get(0);
            }
            this.pasteKeyframesTo(current, keyframes.get(keyframes.keySet().iterator().next()), offset);
            return;
        }
        for (Map.Entry<String, List<Keyframe>> entry : keyframes.entrySet()) {
            for (GuiSheet sheet : sheets) {
                if (!sheet.id.equals(entry.getKey())) continue;
                this.pasteKeyframesTo(sheet, entry.getValue(), offset);
            }
        }
    }

    private void pasteKeyframesTo(GuiSheet sheet, List<Keyframe> keyframes, long offset) {
        long firstX = keyframes.get((int)0).tick;
        ArrayList<Keyframe> toSelect = new ArrayList<Keyframe>();
        if (GuiScreen.func_146271_m()) {
            offset = firstX;
        }
        for (Keyframe keyframe : keyframes) {
            keyframe.tick = keyframe.tick - firstX + offset;
            int index = sheet.channel.insert(keyframe.tick, keyframe.value);
            Keyframe inserted = sheet.channel.get(index);
            inserted.copy(keyframe);
            toSelect.add(inserted);
        }
        for (Keyframe select : toSelect) {
            sheet.selected.add(sheet.channel.getKeyframes().indexOf(select));
        }
        ((GuiKeyframeElement)this.graph).which = Selection.KEYFRAME;
        ((GuiKeyframeElement)this.graph).setKeyframe(((GuiKeyframeElement)this.graph).getCurrent());
    }

    protected void doubleClick(int mouseX, int mouseY) {
        ((GuiKeyframeElement)this.graph).doubleClick(mouseX, mouseY);
        this.fillData(((GuiKeyframeElement)this.graph).getCurrent());
    }

    @Override
    public boolean mouseScrolled(GuiContext context) {
        return super.mouseScrolled(context) || this.area.isInside(context.mouseX, context.mouseY);
    }

    public void resetView() {
        ((GuiKeyframeElement)this.graph).resetView();
    }

    public void selectAll() {
        ((GuiKeyframeElement)this.graph).selectAll();
    }

    public void removeSelectedKeyframes() {
        ((GuiKeyframeElement)this.graph).removeSelectedKeyframes();
    }

    public void setTick(double tick) {
        ((GuiKeyframeElement)this.graph).setTick(this.converter == null ? tick : this.converter.from(tick), false);
    }

    public void setValue(double value) {
        ((GuiKeyframeElement)this.graph).setValue(value, false);
    }

    public void pickInterpolation(KeyframeInterpolation interp) {
        ((GuiKeyframeElement)this.graph).setInterpolation(interp);
        this.interp.label.set(interp.getKey());
    }

    public void changeEasing() {
        ((GuiKeyframeElement)this.graph).setEasing(KeyframeEasing.values()[this.easing.getValue()]);
    }

    public void fillData(Keyframe frame) {
        boolean show = frame != null && ((GuiKeyframeElement)this.graph).which != Selection.NOT_SELECTED;
        this.frameButtons.setVisible(show);
        if (!show) {
            return;
        }
        double tick = ((GuiKeyframeElement)this.graph).which.getX(frame);
        boolean forceInteger = ((GuiKeyframeElement)this.graph).which == Selection.KEYFRAME;
        this.tick.integer = this.converter == null ? forceInteger : this.converter.forceInteger(frame, ((GuiKeyframeElement)this.graph).which, forceInteger);
        this.tick.setValue(this.converter == null ? tick : this.converter.to(tick));
        this.value.setValue(((GuiKeyframeElement)this.graph).which.getY(frame));
        this.interp.label.set(frame.interp.getKey());
        this.interpolations.setCurrent(frame.interp);
        this.easing.setValue(frame.easing.ordinal());
    }
}

