/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.list;

import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiFolderEntryListElement
extends GuiListElement<AbstractEntry> {
    public Consumer<FileEntry> fileCallback;
    public ResourceLocation rl;
    public FolderEntry parent;

    public GuiFolderEntryListElement(Minecraft mc, Consumer<FileEntry> fileCallback) {
        super(mc, null);
        this.callback = list -> {
            AbstractEntry entry = (AbstractEntry)list.get(0);
            if (entry instanceof FileEntry) {
                if (this.fileCallback != null) {
                    this.fileCallback.accept((FileEntry)entry);
                }
            } else if (entry.isFolder()) {
                this.setFolder((FolderEntry)entry);
            }
        };
        this.fileCallback = fileCallback;
        this.scroll.scrollItemSize = 16;
        this.scroll.scrollSpeed = 16;
    }

    public void setFolder(FolderEntry folder) {
        if (folder.getEntries().size() <= 2 && !folder.isTop()) {
            for (AbstractEntry subEntry : folder.getEntries()) {
                FolderEntry subFolder;
                if (!subEntry.isFolder() || (subFolder = (FolderEntry)subEntry).isTop()) continue;
                this.setFolder(subFolder);
                return;
            }
        }
        this.setDirectFolder(folder);
    }

    public void setDirectFolder(FolderEntry folder) {
        List<AbstractEntry> entries = folder.getEntries();
        List current = this.getCurrent();
        this.parent = folder;
        this.setList(entries);
        this.setCurrent(current.isEmpty() ? null : (AbstractEntry)current.get(0));
        if (this.current.isEmpty()) {
            this.setCurrent(this.rl);
        }
    }

    public ResourceLocation getCurrentResource() {
        List entry = this.getCurrent();
        if (!entry.isEmpty() && entry.get(0) instanceof FileEntry) {
            return ((FileEntry)entry.get((int)0)).resource;
        }
        return null;
    }

    @Override
    public void setCurrent(ResourceLocation rl) {
        this.setIndex(-1);
        if (rl == null) {
            return;
        }
        int c = this.list.size();
        for (int i = 0; i < c; ++i) {
            AbstractEntry entry = (AbstractEntry)this.list.get(i);
            if (!(entry instanceof FileEntry) || !((FileEntry)entry).resource.equals((Object)rl)) continue;
            this.setIndex(i);
            break;
        }
    }

    @Override
    protected void drawElementPart(AbstractEntry element, int i, int x, int y, boolean hover, boolean selected) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.mc.field_71446_o.func_110577_a(GuiBase.field_110324_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 0.8f : 0.6f));
        (element instanceof FolderEntry ? Icons.FOLDER : Icons.SERVER).render(x + 2, y);
        this.font.func_175063_a(element.title, (float)(x + 20), (float)(y + 4), hover ? 0xFFFFA0 : 0xFFFFFF);
    }
}

