/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.elements.modals;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class GuiListModal
extends GuiModal {
    public Consumer<List<String>> callback = list -> {
        if (callback != null) {
            callback.accept(this.list.getIndex() == 0 ? "" : (String)this.list.getCurrentFirst());
        }
    };
    public String label;
    public GuiButtonElement pick;
    public GuiButtonElement cancel;
    public GuiStringListElement list;

    public GuiListModal(Minecraft mc, IKey label, Consumer<String> callback) {
        super(mc, label);
        this.pick = new GuiButtonElement(mc, IKey.lang("mclib.gui.ok"), b -> this.send());
        this.cancel = new GuiButtonElement(mc, IKey.lang("mclib.gui.cancel"), b -> this.removeFromParent());
        this.list = new GuiStringListElement(mc, null);
        this.list.flex().set(10.0f, 0.0f, 0.0f, 0.0f).relative(this.area).y(0.4f, 0).w(1.0f, -20).h(0.6f, -35);
        this.list.add(I18n.func_135052_a((String)"mclib.gui.none", (Object[])new Object[0]));
        this.list.setIndex(0);
        this.bar.add(this.pick, this.cancel);
        this.add((IGuiElement)this.list);
    }

    public GuiListModal callback(Consumer<List<String>> callback) {
        this.callback = callback;
        return this;
    }

    public GuiListModal setValue(String value) {
        if (value.isEmpty()) {
            this.list.setIndex(0);
        } else {
            this.list.setCurrent(value);
        }
        return this;
    }

    public GuiListModal addValues(Collection<String> values) {
        this.list.add(values);
        return this;
    }

    public void send() {
        if (this.list.isDeselected()) {
            return;
        }
        this.removeFromParent();
        if (this.callback != null) {
            this.callback.accept(this.list.getCurrent());
        }
    }

    @Override
    public boolean keyTyped(GuiContext context) {
        if (super.keyTyped(context)) {
            return true;
        }
        if (context.keyCode == 28) {
            this.send();
            return true;
        }
        if (context.keyCode == 1) {
            this.removeFromParent();
            return true;
        }
        return false;
    }
}

