/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.framework.tooltips;

import java.util.List;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.tooltips.ITooltip;
import mchorse.mclib.client.gui.framework.tooltips.styles.TooltipStyle;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.MathUtils;

public class LabelTooltip
implements ITooltip {
    public IKey label;
    public int width = 200;
    public Direction direction;

    public LabelTooltip(IKey label, Direction direction) {
        this.label = label;
        this.direction = direction;
    }

    public LabelTooltip(IKey label, int width, Direction direction) {
        this(label, direction);
        this.width = width;
    }

    @Override
    public void drawTooltip(GuiContext context) {
        String label = this.label.get();
        if (label.isEmpty()) {
            return;
        }
        List strings = context.font.func_78271_c(label, this.width);
        if (strings.isEmpty()) {
            return;
        }
        TooltipStyle style = TooltipStyle.get();
        Direction dir = this.direction;
        Area area = context.tooltip.area;
        this.calculate(context, strings, dir, area, Area.SHARED);
        if (Area.SHARED.intersects(area)) {
            this.calculate(context, strings, dir.opposite(), area, Area.SHARED);
        }
        Area.SHARED.offset(3);
        style.drawBackground(Area.SHARED);
        Area.SHARED.offset(-3);
        for (String line : strings) {
            context.font.func_78276_b(line, Area.SHARED.x, Area.SHARED.y, style.getTextColor());
            Area.SHARED.y += context.font.field_78288_b + 3;
        }
    }

    private void calculate(GuiContext context, List<String> strings, Direction dir, Area elementArea, Area targetArea) {
        int w = strings.size() == 1 ? context.font.func_78256_a(strings.get(0)) : this.width;
        int h = (context.font.field_78288_b + 3) * strings.size() - 3;
        int x = elementArea.x(dir.anchorX) - (int)((float)w * (1.0f - dir.anchorX)) + 6 * dir.factorX;
        int y = elementArea.y(dir.anchorY) - (int)((float)h * (1.0f - dir.anchorY)) + 6 * dir.factorY;
        x = MathUtils.clamp(x, 3, context.screen.field_146294_l - w - 3);
        y = MathUtils.clamp(y, 3, context.screen.field_146295_m - h - 3);
        targetArea.set(x, y, w, h);
    }
}

