/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.mclib;

import java.util.function.Consumer;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiPanelBase;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.mclib.GuiDashboardPanel;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.permissions.PermissionUtils;
import mchorse.mclib.utils.Direction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;

public class GuiDashboardPanels
extends GuiPanelBase<GuiDashboardPanel> {
    public GuiDashboardPanels(Minecraft mc) {
        super(mc, Direction.LEFT);
    }

    public void open() {
        for (GuiDashboardPanel panel : this.panels) {
            Consumer<Boolean> task = enabled -> {
                if (enabled.booleanValue()) {
                    panel.open();
                }
            };
            if (panel.getRequiredPermission() != null) {
                PermissionUtils.hasPermission((EntityPlayer)Minecraft.func_71410_x().field_71439_g, panel.getRequiredPermission(), task);
                continue;
            }
            task.accept(true);
        }
    }

    public void close() {
        for (GuiDashboardPanel panel : this.panels) {
            panel.close();
        }
    }

    @Override
    public void setPanel(GuiDashboardPanel panel) {
        if (this.view.delegate != null) {
            ((GuiDashboardPanel)this.view.delegate).disappear();
        }
        super.setPanel(panel);
        if (this.view.delegate != null) {
            ((GuiDashboardPanel)this.view.delegate).appear();
        }
    }

    @Override
    public GuiIconElement registerPanel(GuiDashboardPanel panel, IKey tooltip, Icon icon) {
        GuiIconElement element = super.registerPanel(panel, tooltip, icon);
        int key = this.getKeybind();
        if (key != -1) {
            element.keys().register(IKey.comp(IKey.lang("mclib.gui.dashboard.open_panel"), tooltip), key, () -> element.clickItself(GuiBase.getCurrent())).category(IKey.lang("mclib.gui.dashboard.category"));
        }
        return element;
    }

    protected int getKeybind() {
        int size = this.panels.size();
        switch (size) {
            case 1: {
                return 82;
            }
            case 2: {
                return 79;
            }
            case 3: {
                return 80;
            }
            case 4: {
                return 81;
            }
            case 5: {
                return 75;
            }
            case 6: {
                return 76;
            }
            case 7: {
                return 77;
            }
            case 8: {
                return 71;
            }
            case 9: {
                return 72;
            }
            case 10: {
                return 73;
            }
        }
        return -1;
    }

    @Override
    protected void drawBackground(GuiContext context, int x, int y, int w, int h) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-15658735);
    }
}

