/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.client.gui.utils;

import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.ScrollArea;

public enum ScrollDirection {
    VERTICAL{

        @Override
        public int getPosition(Area area, float x) {
            return area.y(x);
        }

        @Override
        public int getSide(Area area) {
            return area.h;
        }

        @Override
        public int getScroll(ScrollArea area, int x, int y) {
            return y - area.y + area.scroll;
        }

        @Override
        public float getProgress(Area area, int x, int y) {
            return (float)(y - area.y) / (float)area.h;
        }
    }
    ,
    HORIZONTAL{

        @Override
        public int getPosition(Area area, float x) {
            return area.x(x);
        }

        @Override
        public int getSide(Area area) {
            return area.w;
        }

        @Override
        public int getScroll(ScrollArea area, int x, int y) {
            return x - area.x + area.scroll;
        }

        @Override
        public float getProgress(Area area, int x, int y) {
            return (float)(x - area.x) / (float)area.w;
        }
    };


    public abstract int getPosition(Area var1, float var2);

    public abstract int getSide(Area var1);

    public abstract int getScroll(ScrollArea var1, int var2, int var3);

    public abstract float getProgress(Area var1, int var2, int var3);
}

