/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.ICopy;
import mchorse.mclib.utils.Interpolation;
import net.minecraft.nbt.NBTBase;

public abstract class GenericBaseValue<T>
extends Value {
    protected T value;
    protected T serverValue;

    public GenericBaseValue(String id) {
        super(id);
    }

    public GenericBaseValue(String id, T value) {
        super(id);
        this.value = value;
    }

    public T get() {
        if (this.serverValue == null) {
            if (this.value instanceof ICopy) {
                return ((ICopy)this.value).copy();
            }
            return this.value;
        }
        if (this.serverValue instanceof ICopy) {
            return ((ICopy)this.serverValue).copy();
        }
        return this.serverValue;
    }

    public void set(T value) {
        this.value = value == null ? this.getNullValue() : (value instanceof ICopy ? ((ICopy)value).copy() : value);
        this.saveLater();
    }

    protected T getNullValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            return;
        }
        try {
            this.set(value);
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getValue() {
        return this.get();
    }

    @Override
    public abstract GenericBaseValue<T> copy();

    @Override
    public abstract void copy(Value var1);

    public boolean equals(Object obj) {
        if (!(obj instanceof GenericBaseValue)) {
            return obj == null && this.value == null;
        }
        GenericBaseValue valueObj = (GenericBaseValue)obj;
        if (valueObj.value == null && this.value == null) {
            return true;
        }
        if (valueObj.value == null) {
            return false;
        }
        if (valueObj.value.equals(this.value)) {
            return true;
        }
        return this == obj;
    }

    @Override
    public abstract void fromBytes(ByteBuf var1);

    @Override
    public abstract void toBytes(ByteBuf var1);

    public abstract void valueFromBytes(ByteBuf var1);

    public abstract void valueToBytes(ByteBuf var1);

    @Override
    public abstract void valueFromJSON(JsonElement var1);

    @Override
    public abstract JsonElement valueToJSON();

    public abstract void valueFromNBT(NBTBase var1);

    @Nullable
    public abstract NBTBase valueToNBT();

    public abstract T interpolate(Interpolation var1, GenericBaseValue<?> var2, float var3);
}

