/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.config.values;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.config.gui.GuiConfigPanel;
import mchorse.mclib.config.values.GenericBaseValue;
import mchorse.mclib.config.values.GenericNumberValue;
import mchorse.mclib.config.values.IConfigGuiProvider;
import mchorse.mclib.config.values.IServerValue;
import mchorse.mclib.config.values.Value;
import mchorse.mclib.utils.Interpolation;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ValueFloat
extends GenericNumberValue<Float>
implements IServerValue,
IConfigGuiProvider {
    public ValueFloat(String id) {
        super(id, Float.valueOf(0.0f), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public ValueFloat(String id, float defaultValue) {
        super(id, Float.valueOf(defaultValue), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY));
    }

    public ValueFloat(String id, float defaultValue, float min, float max) {
        super(id, Float.valueOf(defaultValue), Float.valueOf(min), Float.valueOf(max));
    }

    @Override
    public void resetServer() {
        this.serverValue = null;
    }

    @Override
    protected Float getNullValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Float numberToValue(Number number) {
        return Float.valueOf(number.floatValue());
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiElement> getFields(Minecraft mc, GuiConfigPanel gui) {
        GuiElement element = new GuiElement(mc);
        GuiLabel label = Elements.label(IKey.lang(this.getLabelKey()), 0).anchor(0.0f, 0.5f);
        GuiTrackpadElement trackpad = new GuiTrackpadElement(mc, this);
        trackpad.flex().w(90);
        element.flex().row(0).preferred(0).height(20);
        element.add(label, trackpad.removeTooltip());
        return Arrays.asList(element.tooltip(IKey.lang(this.getCommentKey())));
    }

    @Override
    public void valueFromJSON(JsonElement element) {
        this.set(Float.valueOf(element.getAsFloat()));
    }

    @Override
    public void valueFromNBT(NBTBase tag) {
        if (tag instanceof NBTPrimitive) {
            this.set(Float.valueOf(((NBTPrimitive)tag).func_150288_h()));
        }
    }

    @Override
    public NBTBase valueToNBT() {
        return new NBTTagFloat(((Float)this.value).floatValue());
    }

    @Override
    public boolean parseFromCommand(String value) {
        try {
            this.set(Float.valueOf(Float.parseFloat(value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void copy(Value value) {
        if (value instanceof ValueFloat) {
            this.set((Number)((ValueFloat)value).value);
        }
    }

    @Override
    public void copyServer(Value value) {
        if (value instanceof ValueFloat) {
            this.serverValue = ((ValueFloat)value).value;
        }
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        this.superFromBytes(buffer);
        this.defaultValue = Float.valueOf(buffer.readFloat());
        this.min = Float.valueOf(buffer.readFloat());
        this.max = Float.valueOf(buffer.readFloat());
        this.valueFromBytes(buffer);
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        this.superToBytes(buffer);
        buffer.writeFloat(((Float)this.defaultValue).floatValue());
        buffer.writeFloat(((Float)this.min).floatValue());
        buffer.writeFloat(((Float)this.max).floatValue());
        this.valueToBytes(buffer);
    }

    @Override
    public void valueFromBytes(ByteBuf buffer) {
        this.set(Float.valueOf(buffer.readFloat()));
    }

    @Override
    public void valueToBytes(ByteBuf buffer) {
        buffer.writeFloat(((Float)this.value).floatValue());
    }

    public String toString() {
        return Float.toString(((Float)this.value).floatValue());
    }

    @Override
    public ValueFloat copy() {
        ValueFloat clone = new ValueFloat(this.id, ((Float)this.defaultValue).floatValue(), ((Float)this.min).floatValue(), ((Float)this.max).floatValue());
        clone.value = this.value;
        return clone;
    }

    @Override
    public Float interpolate(Interpolation interpolation, GenericBaseValue<?> to, float factor) {
        if (!(to.value instanceof Float)) {
            return (Float)this.value;
        }
        return Float.valueOf(interpolation.interpolate(((Float)this.value).floatValue(), ((Float)to.value).floatValue(), factor));
    }
}

