/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.network.mclib.common;

import io.netty.buffer.ByteBuf;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nullable;
import mchorse.mclib.McLib;
import mchorse.mclib.network.mclib.common.IAnswerRequest;
import mchorse.mclib.network.mclib.common.PacketBoolean;
import mchorse.mclib.permissions.PermissionCategory;

public class PacketRequestPermission
implements IAnswerRequest<Boolean> {
    private PermissionCategory request;
    private int callbackID = -1;

    public PacketRequestPermission() {
    }

    public PacketRequestPermission(int callbackID, PermissionCategory permission) {
        this.callbackID = callbackID;
        this.request = permission;
    }

    @Nullable
    public PermissionCategory getPermissionRequest() {
        return this.request;
    }

    @Override
    public void setCallbackID(int callbackID) {
        this.callbackID = callbackID;
    }

    @Override
    public Optional<Integer> getCallbackID() {
        return Optional.of(this.callbackID == -1 ? null : Integer.valueOf(this.callbackID));
    }

    public PacketBoolean getAnswer(Boolean value) throws NoSuchElementException {
        return new PacketBoolean((int)this.getCallbackID().get(), value);
    }

    public void fromBytes(ByteBuf buf) {
        this.callbackID = buf.readInt();
        this.request = McLib.permissionFactory.getPermission(buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.callbackID);
        buf.writeInt(McLib.permissionFactory.getPermissionID(this.request));
    }
}

