/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mclib.permissions;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import javax.annotation.Nullable;
import mchorse.mclib.McLib;
import mchorse.mclib.permissions.PermissionCategory;

public class PermissionFactory {
    private final BiMap<Integer, PermissionCategory> permissions = HashBiMap.create();

    public void registerPermission(PermissionCategory permission) {
        String name = permission.toString();
        int hash = name.hashCode();
        if (this.permissions.containsKey((Object)hash)) {
            McLib.LOGGER.warn("The hash of the permission " + name + " is equal to the already registered permission " + this.permissions.get((Object)hash));
            return;
        }
        if (!permission.hasChildren() && !this.permissions.containsValue((Object)permission)) {
            this.permissions.put((Object)hash, (Object)permission);
        }
    }

    public boolean isRegistered(PermissionCategory permission) {
        return this.permissions.containsValue((Object)permission);
    }

    public int getPermissionID(PermissionCategory permission) {
        return (Integer)this.permissions.inverse().get((Object)permission);
    }

    @Nullable
    public PermissionCategory getPermission(int id) {
        return (PermissionCategory)this.permissions.get((Object)id);
    }
}

